% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R
\name{mutate_as_tbl}
\alias{mutate_as_tbl}
\title{Base implementation of mutate}
\usage{
mutate_as_tbl(.data, ...)
}
\arguments{
\item{.data}{A \code{tbl_graph} object}

\item{...}{columns to mutate}
}
\value{
A \code{tbl_graph} object
}
\description{
This implementation of mutate is slightly faster than \code{mutate} at the expense
of the graph only being updated in the end. This means that graph algorithms
will not take changes happening during the mutate call into account.
}
\details{
The order of speed increase are rather small and in the ~1 millisecond per
mutateed column order, so for regular use this should not be a choice. The
operations not supported by \code{mutate_as_tbl} are e.g.

\if{html}{\out{<div class="sourceCode">}}\preformatted{gr \%>\%
  activate(nodes) \%>\%
  mutate(weights = runif(10), degree = centrality_degree(weights))
}\if{html}{\out{</div>}}

as \code{weights} will only be made available in the graph at the end of the
mutate call.
}
\keyword{internal}
