# Contributing

Thanks for getting involved! I hope the information below will help you contribute to graphql-ruby.

## Issues

When reporting a bug, please include these details when applicable:

- `graphql` version and other applicable versions (Rails, `graphql-batch`, etc)
- Definitions of schema or relevant types and fields (in Ruby is best, in GraphQL IDL is ok)
- Example GraphQL query and response (if query execution is involved)
- Full backtrace (if a Ruby exception is involved)

With these details, we can efficiently hunt down the bug!

## Code

It's important for code to fit in with design and maintenance goals of the project. For this reason, consider an issue to discuss new features or large refactors. That way we can work together to find suitable solution!

## Legal

By submitting a Pull Request, you disavow any rights or claims to any changes submitted to `graphql-ruby` and assign the copyright of those changes to Robert Mosolgo, the author and maintainer of `graphql-ruby`. If you cannot or don't want to reassign those rights (your employment contract for your employer may not allow this), don't submit a PR. Instead, open an issue so that someone else can give it a try.

In short, contributing code means that the code belongs to the maintainer. That's generally what you want, since the burden of upkeep, support and distribution falls on the maintainer anyways. I hope this doesn't prohibit you from contributing!
