/* SPDX-License-Identifier: LGPL-2.1-or-later */

#include "varlink-idl-common.h"
#include "varlink-io.systemd.Manager.h"

static SD_VARLINK_DEFINE_STRUCT_TYPE(
                LogLevelStruct,
                SD_VARLINK_FIELD_COMMENT("'console' target log level"),
                SD_VARLINK_DEFINE_FIELD(console, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("'kmsg' target log level"),
                SD_VARLINK_DEFINE_FIELD(kmsg, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("'syslog' target log level"),
                SD_VARLINK_DEFINE_FIELD(syslog, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("'journal' target log level"),
                SD_VARLINK_DEFINE_FIELD(journal, SD_VARLINK_STRING, 0));

/* The split between ManagerContext and ManagerRuntime follows the rule:
 * - Context is what cannot change once configuration is loaded. You can think about context settings as constants.
 * - Runtime is changeable settings at runtime, in other words - variables. */

static SD_VARLINK_DEFINE_STRUCT_TYPE(
                ManagerContext,
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#LogColor="),
                SD_VARLINK_DEFINE_FIELD(ShowStatus, SD_VARLINK_BOOL, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#LogColor="),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(LogLevel, LogLevelStruct, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#LogColor="),
                SD_VARLINK_DEFINE_FIELD(LogTarget, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#ManagerEnvironment="),
                SD_VARLINK_DEFINE_FIELD(Environment, SD_VARLINK_STRING, SD_VARLINK_ARRAY|SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultStandardOutput="),
                SD_VARLINK_DEFINE_FIELD(DefaultStandardOutput, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultStandardError="),
                SD_VARLINK_DEFINE_FIELD(DefaultStandardError, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#ServiceWatchdogs="),
                SD_VARLINK_DEFINE_FIELD(ServiceWatchdogs, SD_VARLINK_BOOL, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultTimerAccuracySec="),
                SD_VARLINK_DEFINE_FIELD(DefaultTimerAccuracyUSec, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultTimeoutStartSec="),
                SD_VARLINK_DEFINE_FIELD(DefaultTimeoutStartUSec, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultTimeoutStopSec="),
                SD_VARLINK_DEFINE_FIELD(DefaultTimeoutStopUSec, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultTimeoutAbortSec="),
                SD_VARLINK_DEFINE_FIELD(DefaultTimeoutAbortUSec, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultDeviceTimeoutSec="),
                SD_VARLINK_DEFINE_FIELD(DefaultDeviceTimeoutUSec, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultRestartSec="),
                SD_VARLINK_DEFINE_FIELD(DefaultRestartUSec, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultStartLimit="),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(DefaultStartLimit, RateLimit, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultIOAccounting="),
                SD_VARLINK_DEFINE_FIELD(DefaultIOAccounting, SD_VARLINK_BOOL, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultIPAccounting="),
                SD_VARLINK_DEFINE_FIELD(DefaultIPAccounting, SD_VARLINK_BOOL, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultMemoryAccounting="),
                SD_VARLINK_DEFINE_FIELD(DefaultMemoryAccounting, SD_VARLINK_BOOL, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultTasksAccounting="),
                SD_VARLINK_DEFINE_FIELD(DefaultTasksAccounting, SD_VARLINK_BOOL, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultLimitCPU="),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(DefaultLimits, ResourceLimitTable, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultTasksMax="),
                SD_VARLINK_DEFINE_FIELD(DefaultTasksMax, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultMemoryPressureThresholdUSec="),
                SD_VARLINK_DEFINE_FIELD(DefaultMemoryPressureThresholdUSec, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultMemoryPressureWatch="),
                SD_VARLINK_DEFINE_FIELD(DefaultMemoryPressureWatch, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#RuntimeWatchdogSec="),
                SD_VARLINK_DEFINE_FIELD(RuntimeWatchdogUSec, SD_VARLINK_INT, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#RebootWatchdogSec="),
                SD_VARLINK_DEFINE_FIELD(RebootWatchdogUSec, SD_VARLINK_INT, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#KExecWatchdogSec="),
                SD_VARLINK_DEFINE_FIELD(KExecWatchdogUSec, SD_VARLINK_INT, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#RuntimeWatchdogPreSec="),
                SD_VARLINK_DEFINE_FIELD(RuntimeWatchdogPreUSec, SD_VARLINK_INT, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#RuntimeWatchdogPreGovernor="),
                SD_VARLINK_DEFINE_FIELD(RuntimeWatchdogPreGovernor, SD_VARLINK_STRING, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#WatchdogDevice="),
                SD_VARLINK_DEFINE_FIELD(WatchdogDevice, SD_VARLINK_STRING, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#TimerSlackNSec="),
                SD_VARLINK_DEFINE_FIELD(TimerSlackNSec, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultOOMPolicy="),
                SD_VARLINK_DEFINE_FIELD(DefaultOOMPolicy, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultOOMScoreAdjust="),
                SD_VARLINK_DEFINE_FIELD(DefaultOOMScoreAdjust, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#DefaultRestrictSUIDSGID="),
                SD_VARLINK_DEFINE_FIELD(DefaultRestrictSUIDSGID, SD_VARLINK_BOOL, 0),
                SD_VARLINK_FIELD_COMMENT("https://www.freedesktop.org/software/systemd/man/"PROJECT_VERSION_STR"/systemd-system.conf.html#CtrlAltDelBurstAction="),
                SD_VARLINK_DEFINE_FIELD(CtrlAltDelBurstAction, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("The console on which systemd asks for confirmation when spawning processes"),
                SD_VARLINK_DEFINE_FIELD(ConfirmSpawn, SD_VARLINK_STRING, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Root of the control group hierarchy that the manager is running in"),
                SD_VARLINK_DEFINE_FIELD(ControlGroup, SD_VARLINK_STRING, SD_VARLINK_NULLABLE));

static SD_VARLINK_DEFINE_STRUCT_TYPE(
                ManagerRuntime,
                SD_VARLINK_FIELD_COMMENT("The version string of the running systemd instance"),
                SD_VARLINK_DEFINE_FIELD(Version, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("A short ID string describing the architecture the systemd instance is running on"),
                SD_VARLINK_DEFINE_FIELD(Architecture, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("The features that have been enabled and disabled for this build"),
                SD_VARLINK_DEFINE_FIELD(Features, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("An array of strings describing the taints applied to the running system"),
                SD_VARLINK_DEFINE_FIELD(Taints, SD_VARLINK_STRING, SD_VARLINK_ARRAY|SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("The unit search path"),
                SD_VARLINK_DEFINE_FIELD(UnitPath, SD_VARLINK_STRING, SD_VARLINK_ARRAY),
                SD_VARLINK_FIELD_COMMENT("A short ID string describing the virtualization technology the system runs in"),
                SD_VARLINK_DEFINE_FIELD(Virtualization, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("A short ID string describing the confidential virtualization technology the system runs in"),
                SD_VARLINK_DEFINE_FIELD(ConfidentialVirtualization, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the firmware first began execution"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(FirmwareTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the boot loader first began execution"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(LoaderTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the kernel first began execution"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(KernelTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the initrd first began execution"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(InitRDTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the initrd first began execution"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(UserspaceTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the system finished booting up"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(FinishTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager started uploading security policies to the kernel"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(SecurityStartTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager finished uploading security policies to the kernel"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(SecurityFinishTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager started executing generators"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(GeneratorsStartTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager finished executing generators"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(GeneratorsFinishTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager first started loading units"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(UnitsLoadStartTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager first finished loading units"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(UnitsLoadFinishTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager last started loading units"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(UnitsLoadTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager started uploading security policies to the kernel in the initrd"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(InitRDSecurityStartTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager finished uploading security policies to the kernel in the initrd"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(InitRDSecurityFinishTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager started executing generators in the initrd"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(InitRDGeneratorsStartTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager finished executing generators in the initrd"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(InitRDGeneratorsFinishTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager first started loading units in the initrd"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(InitRDUnitsLoadStartTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the manager first finished loading units in the initrd"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(InitRDUnitsLoadFinishTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("The amount of unique unit names currently loaded"),
                SD_VARLINK_DEFINE_FIELD(NNames, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("The amount of failed units"),
                SD_VARLINK_DEFINE_FIELD(NFailedUnits, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("The amount of currently queued jobs"),
                SD_VARLINK_DEFINE_FIELD(NJobs, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("The total amount of queued jobs"),
                SD_VARLINK_DEFINE_FIELD(NInstalledJobs, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("The total amount of failed jobs"),
                SD_VARLINK_DEFINE_FIELD(NFailedJobs, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("IDs of transactions that encountered ordering cycle"),
                SD_VARLINK_DEFINE_FIELD(TransactionsWithOrderingCycle, SD_VARLINK_INT, SD_VARLINK_ARRAY|SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Boot progress as a floating point value between 0.0 and 1.0"),
                SD_VARLINK_DEFINE_FIELD(Progress, SD_VARLINK_FLOAT, 0),
                SD_VARLINK_FIELD_COMMENT("Timestamp when the hardware watchdog was last pinged"),
                SD_VARLINK_DEFINE_FIELD_BY_TYPE(WatchdogLastPingTimestamp, Timestamp, SD_VARLINK_NULLABLE),
                SD_VARLINK_FIELD_COMMENT("Current state of the system"),
                SD_VARLINK_DEFINE_FIELD(SystemState, SD_VARLINK_STRING, 0),
                SD_VARLINK_FIELD_COMMENT("Exit code of the manager"),
                SD_VARLINK_DEFINE_FIELD(ExitCode, SD_VARLINK_INT, 0),
                SD_VARLINK_FIELD_COMMENT("Encodes how many soft-reboots were successfully completed"),
                SD_VARLINK_DEFINE_FIELD(SoftRebootsCount, SD_VARLINK_INT, 0));

static SD_VARLINK_DEFINE_METHOD(
                Describe,
                SD_VARLINK_FIELD_COMMENT("Configuration of the manager"),
                SD_VARLINK_DEFINE_OUTPUT_BY_TYPE(context, ManagerContext, 0),
                SD_VARLINK_FIELD_COMMENT("Runtime information of the manager"),
                SD_VARLINK_DEFINE_OUTPUT_BY_TYPE(runtime, ManagerRuntime, 0));

static SD_VARLINK_DEFINE_METHOD(
                Reexecute);

static SD_VARLINK_DEFINE_METHOD(
                Reload);

static SD_VARLINK_DEFINE_ERROR(RateLimitReached);

SD_VARLINK_DEFINE_INTERFACE(
                io_systemd_Manager,
                "io.systemd.Manager",
                &vl_method_Describe,
                SD_VARLINK_SYMBOL_COMMENT("Reexecute the main manager process"),
                &vl_method_Reexecute,
                SD_VARLINK_SYMBOL_COMMENT("Reload the manager configuration"),
                &vl_method_Reload,
                &vl_error_RateLimitReached,
                &vl_type_ManagerContext,
                &vl_type_ManagerRuntime,
                &vl_type_Timestamp,
                &vl_type_ResourceLimit,
                &vl_type_ResourceLimitTable,
                &vl_type_RateLimit,
                &vl_type_LogLevelStruct);
