/* This file is part of the KDE libraries
   Copyright 2010 Canonical
   Author: Aurelien Gateau <aurelien.gateau@canonical.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License (LGPL) as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later
   version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef DBUSMENULXQT_VERSION_H
#define DBUSMENULXQT_VERSION_H

#define DBUSMENULXQT_VERSION_MAJOR 0
#define DBUSMENULXQT_VERSION_MINOR 2
#define DBUSMENULXQT_VERSION_PATCH 0

#define DBUSMENULXQT_MAKE_VERSION(a, b, c) (((a) << 16) | ((b) << 8) | (c))

#define DBUSMENULXQT_VERSION DBUSMENULXQT_MAKE_VERSION( \
    DBUSMENULXQT_VERSION_MAJOR, \
    DBUSMENULXQT_VERSION_MINOR, \
    DBUSMENULXQT_VERSION_PATCH)

// Use this macro to add code which depends on a minimum version of dbusmenu-lxqt
#define DBUSMENULXQT_IS_VERSION(a, b, c) \
    (DBUSMENULXQT_VERSION >= DBUSMENULXQT_MAKE_VERSION(a, b, c))

#endif /*DBUSMENULXQT_VERSION_H */
