'\"
'\" Generated from domDoc.xml
'\"
'\" BEGIN man.macros
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.de DS
.RS
.nf
.sp
..
.de DE
.fi
.RE
.sp
..
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.if t .ft C
..
.de CE
.fi
.if t .ft R
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\" END man.macros
.TH domDoc n "" Tcl ""
.BS
.SH NAME
domDoc \- Manipulates an instance of a DOM document object
.SH SYNOPSIS
.nf
domDocObjCmd \fImethod\fR ?\fIarg arg ...\fR?
.fi
.BE
.SH "DESCRIPTION "
.PP
This command manipulates one particular instance of a document
object. \fImethod\fR indicates a specific method of the document class. These
methods should closely conform to the W3C recommendation "Document Object Model
(Core) Level 1" (http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html). Look
at these documents for a deeper understanding of the functionality.
.PP
The valid methods are:
.TP
\&\fB\fBdocumentElement\fP ?\fIobjVar\fB?
\&\fRReturns the top most element in the document (the root
element).
.TP
\&\fB\fBgetElementsByTagName\fP \fIname\fB
\&\fRReturns a list of all elements in the document matching
(glob style) \fIname\fR.
.TP
\&\fB\fBgetElementsByTagNameNS\fP \fIuri\fB \fIlocalname\fB
\&\fR Returns a list of all elements in the subtree
matching (glob style) \fIlocalname\fR and having the given namespace
\&\fIuri\fR.
.TP
\&\fB\fBcreateElement\fP \fItagName\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new element node with node name
\&\fItagName\fR, append it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given the new
node object is stored in this variable.
.TP
\&\fB\fBcreateElementNS\fP \fIurl\fB \fItagName\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new element node within a namespace
having \fIuri\fR as the URI and node name \fItagName\fR, which
could include the namespace prefix, append it to the hidden fragment list in
the document object and returns the node object.  If \fIobjVar\fR is
given the new node object is stored in this variable.
.TP
\&\fB\fBcreateTextNode\fP \fItext\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new text node with node value
\&\fItext\fR, appends it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given, the new
node object is stored in this variable.
.TP
\&\fB\fBcreateComment\fP \fItext\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new comment node with value
\&\fItext\fR, appends it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given, the new
comment node object is stored in this variable.
.TP
\&\fB\fBcreateCDATASection\fP \fIdata\fB ?\fIobjVar\fB?
\&\fRCreates (allocates) a new CDATA node with node value
\&\fIdata\fR, appends it to the hidden fragment list in the document
object and returns the node object.  If \fIobjVar\fR is given, the new
node object is stored in this variable.
.TP
\&\fB\fBcreateProcessingInstruction\fP \fItarget\fB \fIdata\fB ?\fIobjVar\fB?
\&\fRCreates a process instruction, appends it to the hidden
fragment list in the document object and returns the node object.  If
\&\fIobjVar\fR is given, the new node object is stored in this variable.
.TP
\&\fB\fBdelete\fP
\&\fRExplicitly deletes the document, including the associated
Tcl object commands (for nodes, fragment/new nodes, the document object itself)
and the underlying DOM tree.
.TP
\&\fB\fBgetDefaultOutputMethod\fP
\&\fRReturns the default output method of the document. This is
usually a result of a XSLT transformation.
.TP
\&\fB\fBasXML\fP \fB?-indent none/tabs/1..8?\fP \fB?-channel channelId?\fP \fB?-escapeNonASCII?\fP \fB?-doctypeDeclaration <boolean>?\fP \fB-xmlDeclaration <boolean>?\fP \fB-encString <string>\fP \fB?-escapeAllQuot?\fP \fB?-indentAttrs?\fP \fB?-nogtescape?\fP \fB?-noEmptyElementTag?\fP
\&\fR
.RS
.PP
Returns the DOM tree as an (optional indented) XML
string or sends the output directly to the given
channelId.
.PP
The -indent option requires "no", "none", "tabs" or a
natural number betwenn 0 and 8, both included, as value. With
the values "no" or "none" no additional white space outside of
markup will be added to the serialization. I. Otherwise, it's
a "pretty-print" serialization, due to inserting white space
between end and the next start tag according to the nesting
level. The level indentation wide is given with the number. If
the value is "tabs", then indentation is done with tabs, one
tab per level.
.PP
If the option \fI-escapeNonASCII\fR is given,
every non 7 bit ASCII character in attribute values or element
PCDATA content will be escaped as character reference in
decimal representation.
.PP
The flag \fI-doctypeDeclaration\fR determines whether
there will be a DOCTYPE declaration emitted before the first
node of the document. The default is not to emit it. The
DOCTYPE name will always be the element name of the document
element. An external entity declaration of the external subset
is only emitted if the document has a system identifier.
.PP
The flag \fI-xmlDeclaration\fR determines whether there
will be an XML Declaration and a newline emitted before
anything else. The default is not to emit one. If this flag is
given with a true argument then
.PP
\&\fI-encString\fR sets the encoding value in the XML
Declaration. Otherwise this option is ignored. Please note
that this option just enhances the string representation of the
generated XML Declaration with an encoding information string,
nothing more. It's up to the user to handle encoding in case
of writing to a channel or reparsing.
.PP
If the option \fI-escapeAllQuot\fR is given,
quotation marks will be escaped with &quot; even in text
content of elements.
.PP
If the option \fI-indentAttrs\fR is
given, then attributes will each be separated with newlines
and indented to the same level as the parent node plus the
value given as argument to \fI-indentAttrs\fR (0..8).
.PP
If the option \fI-nogtescape\fR is given then the
character '>' won't get escaped in attribute values and text
content of elements. The default is to escape this
character.
.PP
If the option \fI-noEmptyElementTag\fR is given then no
empty tag syntax will be used. Instead, if an element has
empty content it will be serialized with an element start tag
and an immediately following element end tag.
.RE
.TP
\&\fB\fBasHTML\fP \fB?-channel channelId?\fP \fB?-escapeNonASCII?\fP \fB?-htmlEntities?\fP \fB?-doctypeDeclaration <boolean>?\fP \fB?-breakLines?\fP \fB?-onlyContents?\fP
\&\fR
.RS
.PP
Returns the DOM tree serialized according to HTML rules
(HTML elements are recognized regardless of case, without end
tags for empty HTML elements etc.) as string or sends the
output directly to the given channelId.
.PP
If the option \fI-escapeNonASCII\fR is given, every non 7
bit ASCII character in attribute values or element PCDATA
content will be escaped as character reference in decimal
representation.
.PP
If the option \fI-htmlEntities\fR is given, a character is
written using its HTML 4.01 character entity reference, if it
has one.
.PP
If the option \fI-breakLines\fR is given the serialization
outputs "\en>" instead of ">" for the opening tags of
elements.
.PP
If the option \fI-onlyContents\fR is given only all child
nodes are serialized. This option is ignored by document
nodes.
.PP
If the flag \fI-doctypeDeclaration\fR is given there will
be a DOCTYPE declaration emitted before the first node of the
document. The default is, to do not. The DOCTYPE name will
always be the element name of the document element without
case normalization. An external entity declaration of the
external subset is only emitted, if the document has a system
identifier. The doctype declaration will be written from the
available information, without check, if this is a known (w3c)
HTML version information or if the document confirms to the
given HTML version. All nodes types other than document nodes
ignore this option.
.RE
.TP
\&\fB\fBasText\fP
\&\fRThe asText method returns the tree by serializing the
string-value of every text node in document order without
any escaping. In effect, this is what the xslt output method
"text" (XSLT 1.0 recommendation, section 16.3) does.
.TP
\&\fB\fBasJSON\fP \fB?-indent none/0..8?\fP \fB?-channel channelId?\fP
\&\fR
.RS
.PP
The asJSON method serializes the tree into a valid
JSON data string. In general, this may be a lossy
serialization. For this serialization all comment, character
data sections and processing instruction nodes, all
attributes and all XML namespaces are ignored. Only element
and text nodes may be reflected in the generated JSON
serialization. Appropriate JSON data type information of a
node will be respected.
.PP
If an element node has the JSON type OBJECT, then every
element node child of this element will be serialized as
member of that object, with the node name of the child as
the member name and the relevant children of that child as
the value. Every other child nodes will be ignored.
.PP
If an element node has the JSON type ARRAY, then the text
and element node children of that element node are serialized
as the consecutive values of the array. Element node children
of an ARRAY element will be container nodes for nested ARRAY
or OBJECT values.
.PP
Text nodes with the JSON types TRUE, FALSE or NULL will
be serialized to the corresponding JSON token without
looking at the value of the text node. A text node without
JSON type will always be serialized as a JSON string token.
A text node with JSON type NUMBER will be serialized as JSON
number token if the text node value is in fact a valid JSON
number and as a JSON string if not.
.PP
If an element node doesn't has a JSON type then the
serialization of its children is determined by the following
rules:
.PP
Only text and element node child are relevant. If the
element node to serialize is the member of a JSON object and
there is no relevant child node the value of that member
will be an empty JSON string. If the only relevant child
node of this element node is a text node then the JSON
value of that text node will be the value of the object
member. If the element has more than one relevant child
nodes and the first one is a text node then the relevant
children will be serialized as JSON array. If the only
relevant child node is an element node or the first relevant
child is an element node and the node name of that only or
first relevant child isn't equal to the array container node
name all element node children will be serialized as the
members of a JSON object (while ignoring any intermixed text
nodes). If the only or first relevant child is an element
node and the node name of this child is equal to the array
container element name then all relevant children will be
serialized as the values of a JSON array.
.PP
If the element to serialize is a value of a JSON array
and the node name of this element isn't equal to the array
container node name that element will be seen as a container
node for a JSON object and all element node children will be
serialized as the members of that array while ignoring any
text node children. If the element to serialize is a value of
a JSON array and the node name of this element is equal to
the array container node name, all relevant children will be
serialized as JSON array.
.PP
If the \fI-channel\fR option is given the serialization
isn't returned as string but send directly to the channel,
given as argument to the option.
.PP
If the \fI-indent\fR option is given and the argument
given to this option isn't "none" then the returned JSON
string is "pretty-printed". The numeric argument to this
option defines the number of spaces for any indentation
level. The default is to not emit any additional
white space.
.RE
.TP
\&\fB\fBpublicId\fP \fI?publicId?\fB
\&\fRReturns the public identifier of the doctype declaration of the
document, if there is one, otherwise the empty string. If there is a value
given to the method, the public identifier of the document is set to this
value.
.TP
\&\fB\fBsystemId\fP \fI?systemId?\fB
\&\fRReturns the system identifier of the doctype declaration of the
document, if there is one, otherwise the empty string. If there is a value
given to the method, the system identifier of the document is set to this
value.
.TP
\&\fB\fBinternalSubset\fP \fI?internalSubset?\fB
\&\fRReturns the internal subset of the doctype declaration of the
document, if there is one, otherwise the empty string. If there is a value
given to the method, the internal subset of the document is set to this
value. Note that none of the parsing methods preserve the internal subset
of a document; a freshly parsed document will always have an empty internal
subset. Also note, that the method doesn't do any syntactical check on a
given internal subset.
.TP
\&\fB\fBcdataSectionElements\fP \fI(?URI:?localname|*) ?<boolean>?\fB
\&\fRThis method allows one to control for which element nodes
the text node children will be serialized as CDATA sections (this affects only
serialization with the asXML method, no text node is altered in any
way by this method). IF the method is called with an element name as
first argument and a boolean with value true as second argument, every
text node child of every element node in the document with the same
name as the first argument will be serialized as CDATA section. If the
second argument is a boolean with value false, all text nodes of all
elements with the same name as the first argument will be serialized
as usual. Namespaced element names have to be given in the form
namespace_URI:localname, not in the otherwise usual prefix:localname
form. With two arguments called, the method returns the used boolean
value. If the method is called with only an element name, it will
return a boolean value, indicating that the text node children of all
elements with that name in the document will be serialized as CDATA
section elements (return value 1) or not (return value 0). If the
method is called with only one argument and that argument is an
asterisk ('*'), then the method returns an unordered list of all
element names of the document, for which the text node children will be
serialized as CDATA section nodes.
.TP
\&\fB\fBselectNodesNamespaces\fP \fB?prefixUriList?\fP
\&\fRThis method gives control to a document global prefix to
namespace URI mapping, which will be used for selectNodes
method calls (on document as well as on all nodes, which
belongs to the document) if it is not overwritten by using the
-namespaces option of the selectNodes method. Any namespace
prefix within an xpath expression will be first resolved
against this list. If the list binds the same prefix to
different namespaces, then the first binding will win. If a
prefix could not resolved against the document global prefix /
namespaces list, then the namespace definitions in scope of
the context node will be used to resolve the prefix, as usual.
If the optional argument \fIprefixUriList\fR is given, then
the global prefix / namespace list is set to this list and
returns it. Without the optional argument the method returns
the current list. The default is the empty list.
.TP
\&\fB\fBxslt\fP \fB?-parameters parameterList?\fP \fB?-ignoreUndeclaredParameters?\fP \fB?-maxApplyDepth int?\fP \fB?-xsltmessagecmd script?\fP \fIstylesheet\fB \fI?outputVar?\fB
\&\fRApplies an XSLT transformation on the whole document of the node
object using the XSLT \fIstylesheet\fR (given as domDoc). Returns a document
object containing the result document of the transformation and stores that
document object in the optional \fIoutputVar\fR, if that was given.
.RS
.PP
The optional \fI-parameters\fR option sets top level
<xsl:param> to string values. The \fIparameterList\fR has to be a tcl
list consisting of parameter name and value pairs.
.PP
If the option \fI-ignoreUndeclaredParameters\fR is given, then parameter
names in the \fIparameterList\fR given to the \fI-parameters\fR options that
are not declared as top-level parameters in the stylesheet are silently
ignored. Without this option, an error is raised if the user tries to set a
top-level parameter that is not declared in the stylesheet.
.PP
The option \fI-maxApplyDepth\fR expects a positiv integer as
argument. By default, the xslt engine allows xslt templates to nest up
to 3000 levels (and raises error if they nest deeper). This limit can
be set by the \fI-maxApplyDepth\fR option.
.PP
The \fI-xsltmessagecmd\fR option sets a callback for xslt:message elements
in the stylesheet. The actual command consists of the script, given as argument
to the option, appended with the XML Fragment from instantiating the
xsl:message element content as string (as if the XPath string() function would
have been applied to the XML Fragment) and a flag, which indicates, if the
xsl:message has an attribute "terminate" with the value "yes". If the
called script returns anything else then TCL_OK then the xslt
transformation will be aborted, returning error. If the called script
returns -code break, the error message is empty, otherwise the result
code is reported. In case of terminated transformation, the outputVar,
if given, is set to the empty string.
.RE
.TP
\&\fB\fBtoXSLTcmd\fP ?\fIobjVar\fB?
\&\fRIf the DOM tree represents a valid XSLT stylesheet, this method
transforms the DOM tree into an xslt command, otherwise it returns error. The
created xsltCmd is returned and stored in the \fIobjVar\fR, if a var name was
given. A successful transformation of the DOM tree to an xsltCmd removes the
domDoc cmd and all nodeCmds of the document.
.RS
.PP
The syntax of the created xsltCmd is:

 

.CS

\&\fBxsltCmd\fP \fBmethod\fP \fB?arg ...?\fP

.CE
.PP
The valid methods are:
.TP
\&\fB\fBtransform\fP \fB?-parameters parameterList?\fP \fB?-ignoreUndeclaredParameters?\fP \fB?-maxApplyDepth int?\fP  \fB?-xsltmessagecmd script?\fP \fIdomDoc\fB \fI?outputVar?\fB
\&\fRApplies XSLT transformation on the document
\&\fIdomDoc\fR. Returns a document object containing the
result document of that transformation and stores it in the optional
\&\fIoutputVar\fR.
.RS
.PP
The optional \fI-parameters\fR option sets top level
<xsl:param> to string values. The \fIparameterList\fR has to be a tcl
list consisting of parameter name and value pairs.
.PP
If the option \fI-ignoreUndeclaredParameters\fR is given, then parameter
names in the \fIparameterList\fR given to the \fI-parameters\fR options that
are not declared as top-level parameters in the stylesheet are silently
ignored. Without this option, an error is raised if the user tries to set a
top-level parameter, which is not declared in the stylesheet.
.PP
The option \fI-maxApplyDepth\fR expects a positiv integer as
argument. By default, the xslt engine allows xslt templates to nest up
to 3000 levels (and raises error if they nest deeper). This limit can
be set by the \fI-maxApplyDepth\fR option.
.PP
The \fI-xsltmessagecmd\fR option sets a callback for xslt:message elements
in the stylesheet. The actual command consists of the script, given as argument
to the option, appended with the XML Fragment from instantiating the
xsl:message element content as string (as if the XPath string() function would
have been applied to the XML Fragment) and a flag, which indicates, if the
xsl:message has an attribute "terminate" with the value "yes".
.RE
.TP
\&\fB\fBdelete\fP
\&\fRDeletes the xsltCmd and cleans up all used recourses
.PP
If the first argument to an xsltCmd is a domDoc or starts with a "-",
then the command is processed in the same way as
\&\fI<xsltCmd> transform\fR.
.RE
.TP
\&\fB\fBnormalize\fP \fI?-forXPath?\fB
\&\fRPuts all text nodes in the document
into a "normal" form where only structure (e.g., elements,
comments, processing instructions and CDATA
sections) separates text nodes, i.e., there
are neither adjacent text nodes nor empty text nodes. If the option
\&\fI-forXPath\fR is given, all CDATA sections in the nodes are
converted to text nodes, as a first step before the
normalization.
.TP
\&\fB\fBnodeType\fP
\&\fRReturns the node type of the document node. This is always
DOCUMENT_NODE.
.TP
\&\fB\fBgetElementById\fP \fIid\fB
\&\fRReturns the node having a id attribute with value
\&\fIid\fR or the empty string, if no node has an id attribute with that value.
.TP
\&\fB\fBfirstChild\fP \fB?objVar?\fP
\&\fRReturns the first top level node of the document.
.TP
\&\fB\fBlastChild\fP \fB?objVar?\fP
\&\fRReturns the last top level node of the document.
.TP
\&\fB\fBappendChild\fP \fInewChild\fB
\&\fRAppend \fInewChild\fR to the end of the list of top level nodes
of the document.
.TP
\&\fB\fBremoveChild\fP \fIchild\fB
\&\fRRemoves \fIchild\fR from the list of top level nodes of the
document. \fIchild\fR will be part of the document fragment list
after this operation. It is not physically deleted.
.TP
\&\fB\fBhasChildNodes\fP
\&\fRReturns 1 if the document has any nodes in the tree. Otherwise 0 is returned.
.TP
\&\fB\fBchildNodes\fP
\&\fRReturns a list of the top level nodes of the document.
.TP
\&\fB\fBownerDocument\fP \fB?domObjVar?\fP
\&\fRReturns the document itself.
.TP
\&\fB\fBinsertBefore\fP \fInewChild\fB  \fIrefChild\fB
\&\fRInsert \fInewChild\fR before the \fIrefChild\fR into the list of
top level nodes of the document. If \fIrefChild\fR is the empty string, inserts
\&\fInewChild\fR at the end of the top level nodes.
.TP
\&\fB\fBreplaceChild\fP \fInewChild\fB  \fIoldChild\fB
\&\fRReplaces \fIoldChild\fR with \fInewChild\fR in the list of
children of that node. The \fIoldChild\fR node will be part of the
document fragment list after this operation.
.TP
\&\fB\fBappendFromList\fP \fIlist\fB
\&\fRParses \fIlist\fR , creates an according DOM subtree and
appends this subtree at the end of the current list of top level nodes of the document.
.TP
\&\fB\fBappendXML\fP \fIXMLstring\fB
\&\fRParses \fIXMLstring\fR, creates an according DOM subtree and
appends this subtree at the end of the current list of top level nodes of the document.
.TP
\&\fB\fBselectNodes\fP \fB?-namespaces prefixUriList?\fP \fB?-cache <boolean>?\fP \fIxpathQuery\fB \fB?typeVar?\fP
\&\fR
.RS
.PP
Returns the result of applying the XPath query
\&\fIxpathQuery\fR to the document. The context node of the query is the root
node in the sense of the XPath recommendation (not the document element). The
result can be a string/value, a list of strings, a list of nodes or a list
of attribute name / value pairs. If \fItypeVar\fR is given
the result type name is stored into that variable (empty,
bool, number, string, nodes, attrnodes or mixed).
.PP
See the documentation of the of the
.TP
\&\fBdomNode
\&\fR command method
\&\fBselectNodes\fP for a detailed description of
the arguments.
.RE
.TP
\&\fB\fBbaseURI\fP \fI?URI?\fB
\&\fRReturns the present baseURI of the document. If the optional
argument URI is given, sets the base URI of the document to the given URI.
.TP
\&\fB\fBappendFromScript\fP \fItclScript\fB
\&\fRAppends the nodes created by the \fItclScript\fR by
Tcl functions, which have been built using \fIdom createNodeCmd\fR, at the end
of the current list of top level nodes of the document.
.TP
\&\fB\fBinsertBeforeFromScript\fP \fItclScript\fB \fIrefChild\fB
\&\fRInserts the nodes created in the \fItclScript\fR by Tcl
functions, which have been built using \fIdom
createNodeCmd\fR, before the \fIrefChild\fR into to the list
of top level nodes of the document. If \fIrefChild\fR is the
empty string, the new nodes will be appended.
.TP
\&\fB\fBdeleteXPathCache\fP \fI?xpathQuery?\fB
\&\fRIf called without the optional argument, all cached XPath
expressions of the document are freed. If called with the optional
argument \fIxpathQuery\fR, this single XPath query will be removed
from the cache, if it is there. The method always returns an
empty string.
.PP
Otherwise, if an unknown method name is given, the command with the
same name as the given method within the namespace \fB::dom::domDoc\fR is
tried to be executed. This allows quick method additions on Tcl level.
.PP
Newly created nodes are appended to a hidden fragment list. If they
are not moved into the tree they are automatically deleted as soon as the whole
document gets deleted.
.SH "SEE ALSO"
dom, domNode
.SH KEYWORDS
DOM node creation, document element
