/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.validator.servlet.DelegatingServletInputStream;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.servlet5.JakartaServletFileUpload;

public final class MultipartFormDataFilter
implements Filter {
    private static Pattern EXTENSION = Pattern.compile("^.*\\.(.+)$");
    private static final Map<String, String> EXTENSION_TO_TYPE = new HashMap<String, String>();

    private static String utf8ByteStreamToString(InputStream stream) throws IOException {
        int c;
        CharsetDecoder dec = Charset.forName("UTF-8").newDecoder();
        dec.onMalformedInput(CodingErrorAction.REPORT);
        dec.onUnmappableCharacter(CodingErrorAction.REPORT);
        InputStreamReader reader = new InputStreamReader(stream, dec);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while ((c = ((Reader)reader).read()) != -1) {
            if (i > 2048) {
                throw new IOException("Form field value too large.");
            }
            builder.append((char)c);
            ++i;
        }
        return builder.toString();
    }

    private static void putParam(Map<String, String[]> params, String key, String value) {
        String[] oldVal = params.get(key);
        if (oldVal == null) {
            String[] arr = new String[]{value};
            params.put(key, arr);
        } else {
            for (String string : oldVal) {
                if (!string.equals(value)) continue;
                return;
            }
            String[] arr = new String[oldVal.length + 1];
            System.arraycopy(oldVal, 0, arr, 0, oldVal.length);
            arr[oldVal.length] = value;
            params.put(key, arr);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (JakartaServletFileUpload.isMultipartContent(request)) {
            try {
                boolean utf8 = false;
                String contentType = null;
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                InputStream fileStream = null;
                JakartaServletFileUpload upload = new JakartaServletFileUpload();
                FileItemInputIterator iter = upload.getItemIterator(request);
                while (iter.hasNext()) {
                    FileItemInput fileItemInput = iter.next();
                    if (fileItemInput.isFormField()) {
                        String fieldName = fileItemInput.getFieldName();
                        if ("content".equals(fieldName) || "fragment".equals(fieldName)) {
                            utf8 = true;
                            String[] parser = (String[])params.get("parser");
                            contentType = parser != null && parser[0].startsWith("xml") ? "application/xml" : "text/html";
                            String[] css = (String[])params.get("css");
                            if (css != null && "yes".equals(css[0])) {
                                contentType = "text/css";
                            }
                            request.setAttribute("nu.validator.servlet.MultipartFormDataFilter.type", "textarea");
                            fileStream = fileItemInput.getInputStream();
                            break;
                        }
                        MultipartFormDataFilter.putParam(params, fieldName, MultipartFormDataFilter.utf8ByteStreamToString(fileItemInput.getInputStream()));
                        continue;
                    }
                    String fileName = fileItemInput.getName();
                    if (fileName != null) {
                        MultipartFormDataFilter.putParam(params, fileItemInput.getFieldName(), fileName);
                        request.setAttribute("nu.validator.servlet.MultipartFormDataFilter.filename", fileName);
                        Matcher m = EXTENSION.matcher(fileName);
                        if (m.matches()) {
                            contentType = EXTENSION_TO_TYPE.get(m.group(1));
                        }
                    }
                    if (contentType == null) {
                        contentType = "text/html";
                    }
                    request.setAttribute("nu.validator.servlet.MultipartFormDataFilter.type", "file");
                    fileStream = fileItemInput.getInputStream();
                    break;
                }
                if (fileStream == null) {
                    fileStream = new ByteArrayInputStream(new byte[0]);
                }
                if (contentType == null) {
                    contentType = "text/html";
                }
                chain.doFilter(new RequestWrapper(request, params, contentType, utf8, fileStream), response);
            }
            catch (CharacterCodingException | FileUploadException e) {
                response.sendError(415, e.getMessage());
            }
            catch (IOException e) {
                response.sendError(400, e.getMessage());
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    @Override
    public void init(FilterConfig arg0) throws ServletException {
    }

    static {
        EXTENSION_TO_TYPE.put("html", "text/html");
        EXTENSION_TO_TYPE.put("htm", "text/html");
        EXTENSION_TO_TYPE.put("xhtml", "application/xhtml+xml");
        EXTENSION_TO_TYPE.put("xht", "application/xhtml+xml");
        EXTENSION_TO_TYPE.put("css", "text/css");
        EXTENSION_TO_TYPE.put("svg", "image/svg+xml");
        EXTENSION_TO_TYPE.put("atom", "application/atom+xml");
        EXTENSION_TO_TYPE.put("rng", "application/xml");
        EXTENSION_TO_TYPE.put("xsl", "application/xml");
        EXTENSION_TO_TYPE.put("xml", "application/xml");
        EXTENSION_TO_TYPE.put("dbk", "application/xml");
        EXTENSION_TO_TYPE.put("csl", "application/xml");
    }

    private final class RequestWrapper
    extends HttpServletRequestWrapper {
        private final Map<String, String[]> params;
        private final String contentType;
        private final boolean utf8;
        private final ServletInputStream stream;

        public RequestWrapper(HttpServletRequest req, Map<String, String[]> params, String contentType, boolean utf8, InputStream stream) {
            super(req);
            this.params = Collections.unmodifiableMap(params);
            this.contentType = contentType;
            this.utf8 = utf8;
            this.stream = new DelegatingServletInputStream(stream);
        }

        @Override
        public long getDateHeader(String name) {
            if ("Content-Length".equalsIgnoreCase(name)) {
                return -1L;
            }
            if ("Content-MD5".equalsIgnoreCase(name)) {
                return -1L;
            }
            if ("Content-Encoding".equalsIgnoreCase(name)) {
                return -1L;
            }
            if ("Content-Type".equalsIgnoreCase(name)) {
                return -1L;
            }
            return super.getDateHeader(name);
        }

        @Override
        public String getHeader(String name) {
            if ("Content-Length".equalsIgnoreCase(name)) {
                return null;
            }
            if ("Content-MD5".equalsIgnoreCase(name)) {
                return null;
            }
            if ("Content-Encoding".equalsIgnoreCase(name)) {
                return null;
            }
            if ("Content-Type".equalsIgnoreCase(name)) {
                return this.getContentType();
            }
            return super.getHeader(name);
        }

        public Enumeration getHeaderNames() {
            Enumeration<String> e = super.getHeaderNames();
            ArrayList<String> list = new ArrayList<String>();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                if ("Content-Length".equalsIgnoreCase(name) || "Content-MD5".equalsIgnoreCase(name) || "Content-Encoding".equalsIgnoreCase(name)) continue;
                if ("Content-Type".equalsIgnoreCase(name)) {
                    list.add(this.getContentType());
                    continue;
                }
                list.add(name);
            }
            return Collections.enumeration(list);
        }

        public Enumeration getHeaders(String name) {
            if ("Content-Length".equalsIgnoreCase(name)) {
                return Collections.enumeration(Collections.EMPTY_SET);
            }
            if ("Content-MD5".equalsIgnoreCase(name)) {
                return Collections.enumeration(Collections.EMPTY_SET);
            }
            if ("Content-Encoding".equalsIgnoreCase(name)) {
                return Collections.enumeration(Collections.EMPTY_SET);
            }
            if ("Content-Type".equalsIgnoreCase(name)) {
                return Collections.enumeration(Collections.singleton(this.getContentType()));
            }
            return super.getHeaders(name);
        }

        @Override
        public int getIntHeader(String name) {
            if ("Content-Length".equalsIgnoreCase(name)) {
                return -1;
            }
            if ("Content-MD5".equalsIgnoreCase(name)) {
                return -1;
            }
            if ("Content-Encoding".equalsIgnoreCase(name)) {
                return -1;
            }
            if ("Content-Type".equalsIgnoreCase(name)) {
                return -1;
            }
            return super.getIntHeader(name);
        }

        @Override
        public String getCharacterEncoding() {
            return this.utf8 ? "utf-8" : null;
        }

        @Override
        public int getContentLength() {
            return -1;
        }

        @Override
        public String getContentType() {
            return this.utf8 ? this.contentType + "; charset=utf-8" : this.contentType;
        }

        @Override
        public ServletInputStream getInputStream() throws IOException {
            return this.stream;
        }

        @Override
        public String getParameter(String key) {
            String[] arr = this.params.get(key);
            if (arr == null) {
                return null;
            }
            return arr[0];
        }

        public Map getParameterMap() {
            return this.params;
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.params.keySet());
        }

        @Override
        public String[] getParameterValues(String key) {
            return this.params.get(key);
        }

        @Override
        public BufferedReader getReader() throws IOException {
            CharsetDecoder dec = Charset.forName("UTF-8").newDecoder();
            dec.onMalformedInput(CodingErrorAction.REPORT);
            dec.onUnmappableCharacter(CodingErrorAction.REPORT);
            InputStreamReader reader = new InputStreamReader((InputStream)this.stream, dec);
            return new BufferedReader(reader);
        }
    }
}

