/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.publish.pubrec;

import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.mqtt.message.publish.pubrec.MqttPubRec;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubrec.Mqtt5PubRecBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubrec.Mqtt5PubRecReasonCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttPubRecBuilder
implements Mqtt5PubRecBuilder {
    @NotNull
    private final MqttStatefulPublish publish;
    @NotNull
    private Mqtt5PubRecReasonCode reasonCode = MqttPubRec.DEFAULT_REASON_CODE;
    @Nullable
    private MqttUtf8StringImpl reasonString;
    @NotNull
    private MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.NO_USER_PROPERTIES;

    public MqttPubRecBuilder(@NotNull MqttStatefulPublish publish) {
        this.publish = publish;
    }

    @Override
    @NotNull
    public MqttPubRecBuilder reasonCode(@Nullable Mqtt5PubRecReasonCode reasonCode) {
        this.reasonCode = Checks.notNull(reasonCode, "Reason code");
        return this;
    }

    @Override
    @NotNull
    public MqttPubRecBuilder reasonString(@Nullable String reasonString) {
        this.reasonString = MqttChecks.reasonString(reasonString);
        return this;
    }

    @Override
    @NotNull
    public MqttPubRecBuilder reasonString(@Nullable MqttUtf8String reasonString) {
        this.reasonString = MqttChecks.reasonString(reasonString);
        return this;
    }

    @Override
    @NotNull
    public MqttPubRecBuilder userProperties(@Nullable Mqtt5UserProperties userProperties) {
        this.userProperties = MqttChecks.userProperties(userProperties);
        return this;
    }

    public @NotNull MqttUserPropertiesImplBuilder.Nested<MqttPubRecBuilder> userProperties() {
        return new MqttUserPropertiesImplBuilder.Nested<MqttPubRecBuilder>(this.userProperties, this::userProperties);
    }

    @NotNull
    public MqttStatefulPublish getPublish() {
        return this.publish;
    }

    @NotNull
    public MqttPubRec build() {
        return new MqttPubRec(this.publish.getPacketIdentifier(), this.reasonCode, this.reasonString, this.userProperties);
    }
}

