/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.I2PAppContext;
import net.i2p.crypto.AESEngine;
import net.i2p.data.SessionKey;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;

class OutboundGatewayProcessor {
    private final I2PAppContext _context;
    private final TunnelCreatorConfig _config;

    public OutboundGatewayProcessor(I2PAppContext ctx, TunnelCreatorConfig cfg) {
        this._context = ctx;
        this._config = cfg;
    }

    public void process(byte[] orig, int offset, int length) {
        this.decrypt(this._config, orig, offset, length);
    }

    private void decrypt(TunnelCreatorConfig cfg, byte[] orig, int offset, int length) {
        for (int i = cfg.getLength() - 1; i >= 1; --i) {
            OutboundGatewayProcessor.decrypt(this._context, orig, offset, length, cfg.getConfig(i));
        }
    }

    static void decrypt(I2PAppContext ctx, byte[] orig, int offset, int length, HopConfig config) {
        SessionKey ivkey = config.getIVKey();
        AESEngine aes = ctx.aes();
        aes.decryptBlock(orig, offset, ivkey, orig, offset);
        aes.decrypt(orig, offset + 16, orig, offset + 16, config.getLayerKey(), orig, offset, length - 16);
        aes.decryptBlock(orig, offset, ivkey, orig, offset);
    }
}

