/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMOrcCSymbolsList;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCDependenceMapPair
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int JD;
    public static final int NAMES;

    public LLVMOrcCDependenceMapPair(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOrcCDependenceMapPair.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public long JD() {
        return LLVMOrcCDependenceMapPair.nJD(this.address());
    }

    public LLVMOrcCSymbolsList Names() {
        return LLVMOrcCDependenceMapPair.nNames(this.address());
    }

    public LLVMOrcCDependenceMapPair JD(@NativeType(value="LLVMOrcJITDylibRef") long value) {
        LLVMOrcCDependenceMapPair.nJD(this.address(), value);
        return this;
    }

    public LLVMOrcCDependenceMapPair Names(LLVMOrcCSymbolsList value) {
        LLVMOrcCDependenceMapPair.nNames(this.address(), value);
        return this;
    }

    public LLVMOrcCDependenceMapPair Names(Consumer<LLVMOrcCSymbolsList> consumer) {
        consumer.accept(this.Names());
        return this;
    }

    public LLVMOrcCDependenceMapPair set(long JD, LLVMOrcCSymbolsList Names) {
        this.JD(JD);
        this.Names(Names);
        return this;
    }

    public LLVMOrcCDependenceMapPair set(LLVMOrcCDependenceMapPair src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMOrcCDependenceMapPair malloc() {
        return (LLVMOrcCDependenceMapPair)LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static LLVMOrcCDependenceMapPair calloc() {
        return (LLVMOrcCDependenceMapPair)LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static LLVMOrcCDependenceMapPair create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (LLVMOrcCDependenceMapPair)LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static LLVMOrcCDependenceMapPair create(long address) {
        return (LLVMOrcCDependenceMapPair)LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, (long)address);
    }

    @Nullable
    public static LLVMOrcCDependenceMapPair createSafe(long address) {
        return address == 0L ? null : (LLVMOrcCDependenceMapPair)LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)LLVMOrcCDependenceMapPair.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)LLVMOrcCDependenceMapPair.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)LLVMOrcCDependenceMapPair.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCDependenceMapPair.__create((int)capacity, (int)SIZEOF);
        return (Buffer)LLVMOrcCDependenceMapPair.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LLVMOrcCDependenceMapPair.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LLVMOrcCDependenceMapPair.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static LLVMOrcCDependenceMapPair malloc(MemoryStack stack) {
        return (LLVMOrcCDependenceMapPair)LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMOrcCDependenceMapPair calloc(MemoryStack stack) {
        return (LLVMOrcCDependenceMapPair)LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMOrcCDependenceMapPair.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)LLVMOrcCDependenceMapPair.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nJD(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)JD));
    }

    public static LLVMOrcCSymbolsList nNames(long struct) {
        return LLVMOrcCSymbolsList.create(struct + (long)NAMES);
    }

    public static void nJD(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)JD), (long)Checks.check((long)value));
    }

    public static void nNames(long struct, LLVMOrcCSymbolsList value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NAMES), (long)LLVMOrcCSymbolsList.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)JD)));
        LLVMOrcCSymbolsList.validate(struct + (long)NAMES);
    }

    static {
        Struct.Layout layout = LLVMOrcCDependenceMapPair.__struct((Struct.Member[])new Struct.Member[]{LLVMOrcCDependenceMapPair.__member((int)POINTER_SIZE), LLVMOrcCDependenceMapPair.__member((int)LLVMOrcCSymbolsList.SIZEOF, (int)LLVMOrcCSymbolsList.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        JD = layout.offsetof(0);
        NAMES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCDependenceMapPair, Buffer>
    implements NativeResource {
        private static final LLVMOrcCDependenceMapPair ELEMENT_FACTORY = LLVMOrcCDependenceMapPair.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LLVMOrcCDependenceMapPair getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcJITDylibRef")
        public long JD() {
            return LLVMOrcCDependenceMapPair.nJD(this.address());
        }

        public LLVMOrcCSymbolsList Names() {
            return LLVMOrcCDependenceMapPair.nNames(this.address());
        }

        public Buffer JD(@NativeType(value="LLVMOrcJITDylibRef") long value) {
            LLVMOrcCDependenceMapPair.nJD(this.address(), value);
            return this;
        }

        public Buffer Names(LLVMOrcCSymbolsList value) {
            LLVMOrcCDependenceMapPair.nNames(this.address(), value);
            return this;
        }

        public Buffer Names(Consumer<LLVMOrcCSymbolsList> consumer) {
            consumer.accept(this.Names());
            return this;
        }
    }
}

