/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.checkpoint.Confirmable;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttStatefulPublishWithFlows;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

class MqttIncomingPublishConfirmable
implements Confirmable,
Runnable {
    @NotNull
    private final MqttIncomingPublishFlow flow;
    @NotNull
    private final MqttStatefulPublishWithFlows publishWithFlows;
    @NotNull
    private final AtomicBoolean confirmed = new AtomicBoolean(false);

    MqttIncomingPublishConfirmable(@NotNull MqttIncomingPublishFlow flow, @NotNull MqttStatefulPublishWithFlows publishWithFlows) {
        this.flow = flow;
        this.publishWithFlows = publishWithFlows;
    }

    @Override
    public long getId() {
        return this.publishWithFlows.id;
    }

    @Override
    public boolean confirm() {
        if (this.confirmed.compareAndSet(false, true)) {
            this.flow.getEventLoop().execute((Runnable)this);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        this.publishWithFlows.acknowledge(this.flow);
    }

    static class Qos0
    implements Confirmable {
        @NotNull
        private final AtomicBoolean confirmed = new AtomicBoolean(false);

        Qos0() {
        }

        @Override
        public long getId() {
            return 0L;
        }

        @Override
        public boolean confirm() {
            return this.confirmed.compareAndSet(false, true);
        }
    }
}

