/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.news;

import java.util.List;
import net.i2p.data.DataHelper;
import net.i2p.util.VersionComparator;

public class NewsMetadata {
    public String feedTitle;
    public String feedSubtitle;
    public String feedID;
    public long feedUpdated;
    public List<Release> releases;

    public static class Update
    implements Comparable<Update> {
        public String type;
        public String torrent;
        public List<String> clearnet;
        public List<String> ssl;
        public List<String> i2pnet;

        @Override
        public int compareTo(Update other) {
            return this.getTypeOrder() - other.getTypeOrder();
        }

        protected int getTypeOrder() {
            if ("su3".equalsIgnoreCase(this.type)) {
                return 1;
            }
            if ("su2".equalsIgnoreCase(this.type)) {
                return 2;
            }
            return 3;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Update)) {
                return false;
            }
            Update u = (Update)o;
            return this.getTypeOrder() == u.getTypeOrder();
        }

        public int hashCode() {
            return this.getTypeOrder();
        }
    }

    public static class Release
    implements Comparable<Release> {
        public long date;
        public String minVersion;
        public String minJavaVersion;
        public String i2pVersion;
        public List<Update> updates;

        @Override
        public int compareTo(Release other) {
            return VersionComparator.comp(other.i2pVersion, this.i2pVersion);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Release)) {
                return false;
            }
            Release r = (Release)o;
            return DataHelper.eq(this.i2pVersion, r.i2pVersion);
        }

        public int hashCode() {
            return DataHelper.hashCode(this.i2pVersion);
        }
    }
}

