/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.List;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.crypto.ChaCha20;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.i2np.BuildResponseRecord;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.TunnelBuildReplyMessage;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.pool.BuildMessageGenerator;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

class BuildReplyHandler {
    private final I2PAppContext ctx;
    private final Log log;
    private static final Result RESULT_NG = new Result(-1, null);
    private static final Result RESULT_OK = new Result(0, null);
    private static final Result RESULT_BW = new Result(30, null);

    public BuildReplyHandler(I2PAppContext context) {
        this.ctx = context;
        this.log = this.ctx.logManager().getLog(BuildReplyHandler.class);
    }

    public Result[] decrypt(TunnelBuildReplyMessage reply, TunnelCreatorConfig cfg, List<Integer> recordOrder) {
        if (reply.getRecordCount() != recordOrder.size()) {
            this.log.error("Corrupted build reply, expected " + recordOrder.size() + " records, got " + reply.getRecordCount());
            return null;
        }
        Result[] rv = new Result[reply.getRecordCount()];
        for (int i = 0; i < rv.length; ++i) {
            int hop = recordOrder.get(i);
            if (BuildMessageGenerator.isBlank(cfg, hop)) {
                if (this.log.shouldLog(10)) {
                    this.log.debug(reply.getUniqueId() + ": skipping record " + i + "/" + hop + " for: " + cfg);
                }
                if (cfg.isInbound() && hop + 1 == cfg.getLength()) {
                    byte[] h1 = new byte[32];
                    byte[] data = reply.getRecord(i).getData();
                    this.ctx.sha().calculateHash(data, 0, data.length, h1, 0);
                    Hash h2 = cfg.getBlankHash();
                    if (h2 != null && DataHelper.eq(h1, h2.getData())) {
                        rv[i] = RESULT_OK;
                        continue;
                    }
                    if (this.log.shouldWarn()) {
                        this.log.warn("IBEP record corrupt on " + cfg);
                    }
                    return null;
                }
                rv[i] = RESULT_OK;
                continue;
            }
            Result res = this.decryptRecord(reply, cfg, i, hop);
            if (res.code == -1) {
                if (this.log.shouldLog(30)) {
                    this.log.warn(reply.getUniqueId() + ": decrypt record " + i + "/" + hop + " fail: " + cfg);
                }
                return null;
            }
            if (this.log.shouldLog(10)) {
                this.log.debug(reply.getUniqueId() + ": decrypt record " + i + "/" + hop + " code: " + res.code + " for " + cfg);
            }
            rv[i] = res;
        }
        return rv;
    }

    private Result decryptRecord(TunnelBuildReplyMessage reply, TunnelCreatorConfig cfg, int recordNum, int hop) {
        int rv;
        Object replyKey;
        boolean isShort;
        EncryptedBuildRecord rec = reply.getRecord(recordNum);
        int type = reply.getType();
        if (rec == null) {
            if (this.log.shouldWarn()) {
                this.log.warn("Missing record " + recordNum);
            }
            return RESULT_NG;
        }
        byte[] data = rec.getData();
        int start = cfg.getLength() - 1;
        if (cfg.isInbound()) {
            --start;
        }
        int end = hop;
        boolean isEC = cfg.isEC(hop);
        if (isEC) {
            ++end;
        }
        boolean isOTBRM = type == 26;
        boolean bl = isShort = isOTBRM || type == 999;
        if (isShort) {
            byte[] iv = new byte[12];
            for (int j = start; j >= end; --j) {
                replyKey = cfg.getChaChaReplyKey(j).getData();
                if (this.log.shouldDebug()) {
                    this.log.debug(reply.getUniqueId() + ": Decrypting ChaCha record " + recordNum + "/" + hop + "/" + j + " with replyKey " + Base64.encode((byte[])replyKey) + " : " + cfg);
                }
                iv[4] = (byte)recordNum;
                ChaCha20.encrypt((byte[])replyKey, iv, data, 0, data, 0, 218);
            }
        } else {
            for (int j = start; j >= end; --j) {
                SessionKey replyKey2 = cfg.getAESReplyKey(j);
                byte[] replyIV = cfg.getAESReplyIV(j);
                if (this.log.shouldDebug()) {
                    this.log.debug(reply.getUniqueId() + ": Decrypting AES record " + recordNum + "/" + hop + "/" + j + " with replyKey " + replyKey2.toBase64() + "/" + Base64.encode(replyIV) + ": " + cfg);
                }
                this.ctx.aes().decrypt(data, 0, data, 0, replyKey2, replyIV, 0, data.length);
            }
        }
        Properties props = null;
        if (isEC) {
            boolean ok;
            replyKey = cfg.getChaChaReplyKey(hop);
            byte[] replyIV = cfg.getChaChaReplyAD(hop);
            if (this.log.shouldDebug()) {
                this.log.debug(reply.getUniqueId() + ": Decrypting chacha/poly record " + recordNum + "/" + hop + " with replyKey " + ((SimpleDataStructure)replyKey).toBase64() + "/" + Base64.encode(replyIV) + ": " + cfg);
            }
            if (!(ok = isShort ? BuildResponseRecord.decrypt(rec, (SessionKey)replyKey, replyIV, recordNum) : BuildResponseRecord.decrypt(rec, (SessionKey)replyKey, replyIV))) {
                if (this.log.shouldWarn()) {
                    this.log.warn(reply.getUniqueId() + ": chacha reply decrypt fail on " + recordNum + "/" + hop);
                }
                return RESULT_NG;
            }
            rv = data[rec.length() - 17] & 0xFF;
            if (rv == 0 && (data[0] != 0 || data[1] != 0)) {
                props = new Properties();
                try {
                    DataHelper.fromProperties(data, 0, props);
                }
                catch (DataFormatException dfe) {
                    if (this.log.shouldWarn()) {
                        this.log.warn(reply.getUniqueId() + ": error reading properties", dfe);
                    }
                    props = null;
                }
            }
        } else {
            byte[] h = SimpleByteCache.acquire(32);
            this.ctx.sha().calculateHash(data, 32, 496, h, 0);
            boolean ok = DataHelper.eq(h, 0, data, 0, 32);
            if (!ok) {
                if (this.log.shouldWarn()) {
                    this.log.warn(reply.getUniqueId() + ": sha256 reply verify fail on " + recordNum + "/" + hop + ": " + Base64.encode(h) + " calculated, " + Base64.encode(data, 0, 32) + " expected\nRecord: " + Base64.encode(data, 32, 496));
                }
                SimpleByteCache.release(h);
                return RESULT_NG;
            }
            SimpleByteCache.release(h);
            rv = data[527] & 0xFF;
        }
        if (this.log.shouldLog(10)) {
            this.log.debug(reply.getUniqueId() + ": Verified: " + rv + " for record " + recordNum + "/" + hop);
        }
        if (props == null) {
            if (rv == 0) {
                return RESULT_OK;
            }
            if (rv == 30) {
                return RESULT_BW;
            }
        }
        return new Result(rv, props);
    }

    public static class Result {
        public final int code;
        public final Properties props;

        public Result(int c, Properties p) {
            this.code = c;
            this.props = p;
        }
    }
}

