/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.cbutil.CBArray;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.jndi.SchemaOps;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.RDN;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class DXAttributes
implements Attributes {
    static Hashtable attOIDs = new Hashtable(100);
    static int ID = 0;
    int id;
    Hashtable atts;
    HashSet must;
    boolean ignoreCase = true;
    boolean schemaChecked = false;
    Attribute allObjectClasses;
    String objectClassName = null;
    Vector orderedSOCs = new Vector();
    static SchemaOps schema;
    static Hashtable knownParents;
    static Hashtable knownSubSets;
    static Hashtable objectClassDepths;
    private static final Logger log;

    void basicInit() {
        this.id = ID++;
        this.atts = new Hashtable();
        this.must = new HashSet();
    }

    public DXAttributes() {
        this.basicInit();
    }

    public DXAttributes(Attribute a) {
        this.basicInit();
        this.put(a);
    }

    public DXAttributes(Attributes a) {
        if (a == null) {
            this.atts = new Hashtable();
            this.must = new HashSet();
        } else {
            this.atts = new Hashtable(a.size() + 10);
            this.must = new HashSet(a.size());
            NamingEnumeration<? extends Attribute> e = a.getAll();
            while (e.hasMoreElements()) {
                DXAttribute newAtt = new DXAttribute((Attribute)e.nextElement());
                this.put(newAtt);
            }
        }
    }

    public DXAttributes(Hashtable newAtts) {
        this.atts = (Hashtable)newAtts.clone();
    }

    public DXAttributes(NamingEnumeration newAtts) {
        this.atts = new Hashtable();
        while (newAtts.hasMoreElements()) {
            Attribute current = (Attribute)newAtts.nextElement();
            this.atts.put(current.getID().toLowerCase(), current);
        }
    }

    public static void setDefaultSchema(SchemaOps defaultSchema) {
        schema = defaultSchema;
        DXAttribute.setDefaultSchema(defaultSchema);
    }

    public int getID() {
        return this.id;
    }

    public Object clone() {
        return new DXAttributes(this.atts);
    }

    public Attribute get(String attrID) {
        Attribute ret = (Attribute)this.atts.get(attrID.toLowerCase());
        if (ret == null) {
            ret = (Attribute)this.atts.get(attrID.toLowerCase() + ";binary");
        }
        return ret;
    }

    public NamingEnumeration getAll() {
        return new DXNamingEnumeration(this.atts.elements()).sort();
    }

    public Attributes getAsNonNullAttributes() {
        return new DXAttributes(this.getAllNonNull());
    }

    public NamingEnumeration getAllNonNull() {
        DXNamingEnumeration returnEnumeration = new DXNamingEnumeration();
        NamingEnumeration allatts = this.getAll();
        while (allatts.hasMoreElements()) {
            Attribute fnord = (Attribute)allatts.nextElement();
            if (fnord == null) continue;
            try {
                if (fnord.get() == null) continue;
                returnEnumeration.add(fnord);
            }
            catch (NoSuchElementException e) {
            }
            catch (NamingException e2) {
                log.log(Level.WARNING, "whoops: Naming Exception reading " + fnord.getID(), e2);
            }
        }
        returnEnumeration.sort();
        return returnEnumeration;
    }

    public NamingEnumeration getMandatory() {
        DXNamingEnumeration returnEnumeration = new DXNamingEnumeration();
        if (this.must == null) {
            return returnEnumeration;
        }
        Iterator musts = this.must.iterator();
        while (musts.hasNext()) {
            String s = (String)musts.next();
            returnEnumeration.add(this.get(s));
        }
        returnEnumeration.sort();
        return returnEnumeration;
    }

    public HashSet getMandatoryIDs() {
        return this.must;
    }

    public NamingEnumeration getOptional() {
        DXNamingEnumeration returnEnumeration = new DXNamingEnumeration();
        Enumeration allIDs = this.atts.keys();
        while (allIDs.hasMoreElements()) {
            String id = (String)allIDs.nextElement();
            if (this.must.contains(id)) continue;
            returnEnumeration.add(this.get(id));
        }
        returnEnumeration.sort();
        return returnEnumeration;
    }

    public NamingEnumeration getIDs() {
        DXNamingEnumeration ret = new DXNamingEnumeration();
        NamingEnumeration allAtts = this.getAll();
        while (allAtts.hasMoreElements()) {
            ret.add(((Attribute)allAtts.nextElement()).getID());
        }
        return ret;
    }

    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    public Attribute put(Attribute attr) {
        if (attr == null) {
            return null;
        }
        Attribute old = this.get(attr.getID().toLowerCase());
        this.schemaChecked = false;
        if (old != null) {
            this.atts.remove(old.getID().toLowerCase());
        }
        String ID2 = attr.getID().toLowerCase();
        if (attr instanceof DXAttribute) {
            this.atts.put(ID2, attr);
        } else {
            this.atts.put(ID2, new DXAttribute(attr));
        }
        return old;
    }

    public Attribute put(String attrID, Object val) {
        this.schemaChecked = false;
        return this.put(new DXAttribute(attrID.toLowerCase(), val));
    }

    public void put(Enumeration attributeList) {
        while (attributeList.hasMoreElements()) {
            Attribute a = (Attribute)attributeList.nextElement();
            if (a instanceof DXAttribute) {
                this.put(a);
                continue;
            }
            this.put(new DXAttribute(a));
        }
    }

    public Attribute remove(String attrID) {
        this.schemaChecked = false;
        return (Attribute)this.atts.remove(attrID.toLowerCase());
    }

    public int size() {
        return this.atts.size();
    }

    public void setAllObjectClasses() {
        this.allObjectClasses = this.getAllObjectClasses();
    }

    public Vector getOrderedOCs() {
        Vector ret = null;
        try {
            Attribute oc = this.getAllObjectClasses();
            if (oc == null) {
                return null;
            }
            ret = new Vector(oc.size());
            NamingEnumeration<?> vals = oc.getAll();
            while (vals.hasMore()) {
                ret.add(vals.next());
            }
            return ret;
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Yet another rare naming exception - DXAttributes:getOrderedOCs ", e);
            return new Vector(0);
        }
    }

    public Attribute getAllObjectClasses() {
        Attribute att = this.get("objectclass");
        if (att != null) {
            if (att instanceof DXAttribute) {
                return DXAttributes.getAllObjectClasses((DXAttribute)att);
            }
            return DXAttributes.getAllObjectClasses(new DXAttribute(att));
        }
        return null;
    }

    public static DXAttribute getAllObjectClasses(DXAttribute oc) {
        if (oc == null) {
            return null;
        }
        if (knownSubSets.containsKey(oc)) {
            return (DXAttribute)knownSubSets.get(oc);
        }
        try {
            DXAttribute orig = new DXAttribute(oc);
            NamingEnumeration<?> vals = oc.getAll();
            while (vals.hasMoreElements()) {
                DXAttribute parents = DXAttributes.getParentObjectClasses((String)vals.nextElement());
                if (parents == null) continue;
                NamingEnumeration<?> parentVals = parents.getAll();
                while (parentVals.hasMoreElements()) {
                    String parent = (String)parentVals.nextElement();
                    if (oc.contains(parent)) continue;
                    oc.add(parent);
                }
            }
            DXAttribute fullOC = DXAttributes.sortOCByDepth(oc);
            knownSubSets.put(orig, fullOC);
            return fullOC;
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "NamingException in getAllObjectClasses ", e);
            return oc;
        }
    }

    protected static DXAttribute sortOCByDepth(Attribute oc) {
        DXAttribute ret = new DXAttribute("objectClass");
        ret.setOrdered(true);
        try {
            NamingEnumeration<?> vals = oc.getAll();
            while (vals.hasMoreElements()) {
                int i;
                String val = (String)vals.nextElement();
                Integer myInt = (Integer)objectClassDepths.get(val);
                if (myInt == null) {
                    DXAttributes.getParentObjectClasses(val);
                    myInt = (Integer)objectClassDepths.get(val);
                    if (myInt == null) {
                        myInt = new Integer(0);
                    }
                }
                int depth = myInt;
                for (i = ret.size() - 1; i >= 0; --i) {
                    int existing = (Integer)objectClassDepths.get(ret.get(i));
                    if (existing < depth) continue;
                    ret.add(i + 1, val);
                    break;
                }
                if (i != -1) continue;
                ret.add(0, val);
            }
            return ret;
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Naming Exception in DXAttributes sortOCByDepth()", e);
            return new DXAttribute(oc);
        }
    }

    public static DXAttribute getParentObjectClasses(String childOC) throws NamingException {
        if (schema == null) {
            objectClassDepths.put(childOC, new Integer(1));
            return null;
        }
        if ("schema attributedefinition classdefinition syntaxdefinition matchingrule".indexOf(childOC.toLowerCase()) != -1) {
            return null;
        }
        if (knownParents.containsKey(childOC)) {
            return (DXAttribute)knownParents.get(childOC);
        }
        DXAttribute parents = new DXAttribute("objectClass");
        String schemaParent = null;
        try {
            Attribute sup;
            Attributes schemaDef = schema.getAttributes("ClassDefinition/" + childOC);
            if (schemaDef != null && (sup = schemaDef.get("SUP")) != null) {
                schemaParent = (String)sup.get();
            }
        }
        catch (NamingException e) {
            log.warning("Possible Schema Error: class definition for " + childOC + " could not be found");
            objectClassDepths.put(childOC, new Integer(1));
            return null;
        }
        if (schemaParent != null) {
            DXAttribute oc = DXAttributes.getParentObjectClasses(schemaParent);
            if (oc != null) {
                NamingEnumeration<?> vals = oc.getAll();
                while (vals.hasMoreElements()) {
                    parents.add(vals.nextElement());
                }
            }
            int depth = (Integer)objectClassDepths.get(schemaParent);
            if (!objectClassDepths.containsKey(childOC)) {
                objectClassDepths.put(childOC, new Integer(depth + 1));
            } else {
                int oldDepth = (Integer)objectClassDepths.get(childOC);
                if (oldDepth <= depth) {
                    objectClassDepths.put(childOC, new Integer(depth + 1));
                }
            }
        } else {
            objectClassDepths.put(childOC, new Integer(1));
        }
        parents.add(childOC);
        knownParents.put(childOC, parents);
        return parents;
    }

    void setOrderedSOCs(String oc) throws NamingException {
        this.orderedSOCs.add(oc);
        if (oc.equalsIgnoreCase("top")) {
            return;
        }
        String parent = schema.schemaLookup("ClassDefinition/" + oc, "SUP");
        String struct = schema.schemaLookup("ClassDefinition/" + parent, "STRUCTURAL");
        if ("true".equalsIgnoreCase(struct)) {
            this.setOrderedSOCs(parent);
            return;
        }
    }

    public boolean registerOID(String oid, String ldapName) {
        char test = oid.charAt(0);
        if (test < '0' || test > '9') {
            return false;
        }
        if (oid.endsWith(";binary")) {
            oid = oid.substring(0, oid.indexOf(";binary"));
        }
        if (ldapName.endsWith(";binary")) {
            ldapName = ldapName.substring(0, ldapName.indexOf(";binary"));
        }
        if (attOIDs.contains(oid)) {
            return false;
        }
        attOIDs.put(oid, ldapName);
        return true;
    }

    public void removeEmptyAttributes() {
        NamingEnumeration atts = this.getAll();
        while (atts.hasMoreElements()) {
            Attribute att = (Attribute)atts.nextElement();
            if (att.size() != 0) continue;
            this.remove(att.getID());
        }
    }

    public void expandAllAttributes() {
        if (schema == null) {
            return;
        }
        Attribute oc = null;
        oc = this.getAllObjectClasses();
        try {
            if (oc.contains("synthetic_JXplorer_schema_object")) {
                return;
            }
            NamingEnumeration<?> ocs = oc.getAll();
            while (ocs.hasMore()) {
                String ldapName;
                String attOID;
                String objectClass = (String)ocs.next();
                Attributes ocAttrs = schema.getAttributes("ClassDefinition/" + objectClass);
                Attribute mustAtt = ocAttrs.get("MUST");
                Attribute mayAtt = ocAttrs.get("MAY");
                if (mustAtt != null) {
                    NamingEnumeration<?> musts = mustAtt.getAll();
                    while (musts.hasMore()) {
                        attOID = (String)musts.next();
                        if (attOID.indexOf(";binary") > 0) {
                            attOID = attOID.substring(0, attOID.indexOf(";binary"));
                        }
                        ldapName = this.getldapName(attOID);
                        this.registerOID(attOID, ldapName);
                        if (this.get(ldapName) == null) {
                            this.put(new DXAttribute(this.getldapName(attOID)));
                        }
                        if (this.must.contains(ldapName.toLowerCase())) continue;
                        this.must.add(ldapName.toLowerCase());
                    }
                }
                if (mayAtt == null) continue;
                NamingEnumeration<?> mays = mayAtt.getAll();
                while (mays.hasMore()) {
                    attOID = (String)mays.next();
                    if (attOID.indexOf(";binary") > 0) {
                        attOID = attOID.substring(0, attOID.indexOf(";binary"));
                    }
                    ldapName = this.getldapName(attOID);
                    this.registerOID(attOID, ldapName);
                    if (this.get(ldapName) != null) continue;
                    this.put(new DXAttribute(this.getldapName(attOID)));
                }
            }
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "unable to read attribute list for object classes: ", e);
            try {
                CBUtility.printEnumeration(oc.getAll());
            }
            catch (NamingException e2) {
                log.warning("...(further error: can't print object class list)...");
            }
            return;
        }
        catch (NullPointerException e) {
            log.log(Level.WARNING, "ERROR: unable to read list of object classes from schema - some functionality will not be available", e);
        }
    }

    public String getldapName(String attOID) {
        return schema == null ? attOID : schema.translateOID(attOID);
    }

    public String toString() {
        StringBuffer text = new StringBuffer("size (" + this.size() + ")\n");
        NamingEnumeration allatts = this.getAll();
        while (allatts.hasMoreElements()) {
            Attribute fnord = (Attribute)allatts.nextElement();
            if (fnord == null) {
                log.warning("bizarre null attribute in element list");
                continue;
            }
            if (this.must != null && this.must.contains(fnord.getID())) {
                text.append("must ");
            }
            if (fnord instanceof DXAttribute) {
                text.append(" dx ").append(((DXAttribute)fnord).toDebugString()).append(" ");
                continue;
            }
            String ID2 = fnord.getID();
            text.append("\n    " + ID2 + " (not DXAttribute)");
            try {
                if (fnord.size() == 0) {
                    text.append("         (empty) ");
                    continue;
                }
                NamingEnumeration<?> vals = fnord.getAll();
                while (vals.hasMoreElements()) {
                    Object val = vals.nextElement();
                    String fnordel = val == null ? "*null*" : val.toString();
                    text.append("        '" + fnordel + "'");
                }
            }
            catch (NamingException e) {
                log.log(Level.WARNING, "whoops: Naming Exception reading " + ID2, e);
            }
        }
        return text.toString();
    }

    public void print() {
        this.print(null);
    }

    public void print(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        DXAttributes.printAttributes(this);
    }

    public static void printAttributes(Attributes a) {
        if (a == null) {
            System.out.println("null attributes set");
        }
        NamingEnumeration<? extends Attribute> allatts = a.getAll();
        DXAttributes.printAttributeList(allatts);
    }

    public static void printAttributeList(NamingEnumeration en) {
        while (en.hasMoreElements()) {
            Attribute fnord = (Attribute)en.nextElement();
            if (fnord == null) {
                log.warning("bizarre null attribute in element list");
                continue;
            }
            String ID2 = fnord.getID();
            System.out.println("    " + ID2);
            try {
                NamingEnumeration<?> vals = fnord.getAll();
                while (vals.hasMoreElements()) {
                    Object val = vals.nextElement();
                    String fnordel = val == null ? "*null*" : val.toString();
                    System.out.println("        " + fnordel);
                }
            }
            catch (NamingException e) {
                log.log(Level.WARNING, "whoops: Naming Exception reading " + ID2, e);
            }
        }
    }

    public static DXAttributes getAdditionSet(RDN newRDN, Attributes oldSet, Attributes newSet) throws NamingException {
        DXAttributes additionSet = new DXAttributes();
        NamingEnumeration<? extends Attribute> listOfNewAttributes = newSet.getAll();
        while (listOfNewAttributes.hasMore()) {
            Attribute newAtt = listOfNewAttributes.next();
            String attributeName = newAtt.getID();
            boolean isNamingAttribute = newRDN.contains(attributeName);
            Attribute oldAtt = oldSet.get(attributeName);
            if (DXAttributes.emptyAtt(newAtt)) continue;
            if (!isNamingAttribute && (oldAtt == null || DXAttributes.emptyAtt(oldAtt))) {
                additionSet.put(newAtt);
                continue;
            }
            if (!isNamingAttribute && oldAtt.size() <= 1 && newAtt.size() <= 1) continue;
            DXNamingEnumeration valuesToAdd = DXAttributes.getMissingValues(oldAtt.getAll(), newAtt.getAll());
            if (isNamingAttribute) {
                DXAttributes.removeAnyDistinguishedValues(newRDN, attributeName, valuesToAdd);
            }
            if (valuesToAdd.size() <= 0) continue;
            additionSet.put(new DXAttribute(attributeName, valuesToAdd));
        }
        return additionSet;
    }

    public static DXAttributes getReplacementSet(RDN newRDN, Attributes oldSet, Attributes newSet) throws NamingException {
        DXAttributes replacementSet = new DXAttributes();
        NamingEnumeration<? extends Attribute> listOfNewAttributes = newSet.getAll();
        while (listOfNewAttributes.hasMore()) {
            Attribute oldAtt;
            String attributeName;
            Attribute newAtt = listOfNewAttributes.next();
            if (newAtt == null || newAtt.size() != 1 || newRDN.contains(attributeName = newAtt.getID()) || (oldAtt = oldSet.get(attributeName)) == null || oldAtt.size() != 1 || DXAttributes.attributesEqual(newAtt, oldAtt)) continue;
            replacementSet.put(newAtt);
        }
        return replacementSet;
    }

    public static DXAttributes getDeletionSet(RDN newRDN, Attributes oldSet, Attributes newSet) throws NamingException {
        DXAttributes deletionSet = new DXAttributes();
        NamingEnumeration<? extends Attribute> listOfOldAttributes = oldSet.getAll();
        while (listOfOldAttributes.hasMore()) {
            Attribute oldAtt = listOfOldAttributes.next();
            if (DXAttributes.emptyAtt(oldAtt)) continue;
            String attributeName = oldAtt.getID();
            boolean isNamingAttribute = newRDN.contains(attributeName);
            Attribute newAtt = newSet.get(attributeName);
            if (newAtt == null) {
                newAtt = new DXAttribute(attributeName);
            }
            if (DXAttributes.emptyAtt(newAtt) && !isNamingAttribute) {
                deletionSet.put(newAtt);
                continue;
            }
            if (!isNamingAttribute && oldAtt.size() <= 1 && newAtt.size() <= 1) continue;
            DXNamingEnumeration valuesToDelete = DXAttributes.getMissingValues(newAtt.getAll(), oldAtt.getAll());
            if (isNamingAttribute) {
                DXAttributes.removeAnyDistinguishedValues(newRDN, attributeName, valuesToDelete);
            }
            if (valuesToDelete.size() <= 0) continue;
            deletionSet.put(new DXAttribute(attributeName, valuesToDelete));
        }
        return deletionSet;
    }

    private static boolean attributesEqual(Attribute a, Attribute b) throws NamingException {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() == 0 && b.size() == 0) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        if (a.get() == null && b.get() == null) {
            return true;
        }
        if (a.get() == null || b.get() == null) {
            return false;
        }
        if (!a.getID().equalsIgnoreCase(b.getID())) {
            return false;
        }
        try {
            Object[] A = CBArray.enumerationToArray(a.getAll());
            Object[] B = CBArray.enumerationToArray(b.getAll());
            return CBArray.isUnorderedEqual(A, B);
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Naming Exception testing attributes " + a.getID() + " & " + b.getID() + " in DXAttributes:attributesEqual()", e);
            return false;
        }
    }

    public static boolean attributesEqual(Attributes a, Attributes b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            if (o instanceof Attributes) {
                return this.equals((Attributes)o);
            }
        }
        catch (NamingException e) {
            return false;
        }
        return false;
    }

    public boolean equals(Attributes atts) throws NamingException {
        if (atts == null) {
            return false;
        }
        if (this.size() == 0 && atts.size() == 0) {
            return true;
        }
        if (this.size() != atts.size()) {
            return false;
        }
        NamingEnumeration testAtts = this.getAll();
        while (testAtts.hasMore()) {
            Attribute testAtt = (Attribute)testAtts.next();
            String ID2 = testAtt.getID();
            Attribute bAtt = atts.get(ID2);
            if (DXAttributes.emptyAtt(bAtt) ^ DXAttributes.emptyAtt(testAtt)) {
                return false;
            }
            if (DXAttributes.attributesEqual(testAtt, bAtt)) continue;
            return false;
        }
        return true;
    }

    private static void removeAnyDistinguishedValues(RDN newRDN, String attributeName, DXNamingEnumeration values) {
        String distinguishedValue = newRDN.getRawVal(attributeName);
        values.remove(distinguishedValue);
    }

    private static DXNamingEnumeration getMissingValues(NamingEnumeration A, NamingEnumeration B) throws NamingException {
        DXNamingEnumeration ret = new DXNamingEnumeration(B);
        if (A == null) {
            return ret;
        }
        while (A.hasMore()) {
            ret.remove(A.next());
        }
        return ret;
    }

    public String[] toIDStringArray() {
        DXNamingEnumeration ret = new DXNamingEnumeration(this.getIDs());
        return ret.toStringArray();
    }

    public boolean hasOIDs() {
        return attOIDs.size() > 0;
    }

    public static boolean emptyAtt(Attribute att) {
        return DXAttribute.isEmpty(att);
    }

    static {
        knownParents = new Hashtable(30);
        knownSubSets = new Hashtable(30);
        objectClassDepths = new Hashtable(30);
        log = Logger.getLogger(DXAttributes.class.getName());
        objectClassDepths.put("top", new Integer(0));
        objectClassDepths.put("schema", new Integer(1));
        objectClassDepths.put("AttributeDefinition", new Integer(2));
        objectClassDepths.put("ClassDefinition", new Integer(2));
        objectClassDepths.put("SyntaxDefinition", new Integer(2));
    }
}

