/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.util;

import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class HexUtils {
    private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int ASCII_DIGITS_START_POSITION = 48;
    private static final int ASCII_UPPERCASE_LETTERS_START_POSITION = 65;

    private HexUtils() {
    }

    public static String bytesToHex(byte[] bytes, @Nullable CharSequence delimiter) {
        return HexUtils.bytesToHexInt(bytes, delimiter != null ? delimiter : "");
    }

    private static String bytesToHexInt(byte[] bytes, CharSequence delimiter) {
        byte[] hex;
        if (bytes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2 + delimiter.length() * (bytes.length - 1));
        int pos = 0;
        while (pos < bytes.length - 1) {
            hex = HexUtils.byteToHex(bytes[pos++]);
            sb.append((char)hex[0]);
            sb.append((char)hex[1]);
            sb.append(delimiter);
        }
        hex = HexUtils.byteToHex(bytes[pos++]);
        sb.append((char)hex[0]);
        sb.append((char)hex[1]);
        return sb.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        return HexUtils.bytesToHexInt(bytes, "");
    }

    public static byte[] byteToHex(byte value) {
        byte[] out = new byte[]{HEX[value >>> 4 & 0xF], HEX[value & 0xF]};
        return out;
    }

    public static byte[] hexToBytes(String hexString, String delimiter) {
        if (hexString.isEmpty()) {
            return new byte[0];
        }
        String ucHexString = hexString.toUpperCase();
        String[] splitted = ucHexString.split(delimiter);
        byte[] bytes = new byte[splitted.length];
        int pos = 0;
        String[] stringArray = splitted;
        int n = splitted.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            byte[] in = part.getBytes(StandardCharsets.UTF_8);
            if (in.length != 2) {
                throw new IllegalArgumentException("hexString needs to have an even length: " + hexString);
            }
            bytes[pos++] = (byte)(HexUtils.unhex(in[0]) << 4 | HexUtils.unhex(in[1]));
            ++n2;
        }
        return bytes;
    }

    public static byte[] hexToBytes(String hexString) {
        return HexUtils.hexToBytes(hexString, "(?<=\\G.{2})");
    }

    public static byte hexToByte(byte high, byte low) {
        return (byte)(HexUtils.unhex(high) << 4 | HexUtils.unhex(low));
    }

    private static byte unhex(byte value) {
        if (48 <= value && value <= 57) {
            return (byte)(value - 48);
        }
        if (65 <= value && value <= 70) {
            return (byte)(value - 65 + 10);
        }
        throw new IllegalArgumentException("hexString contains illegal character for hexToBytes: " + value);
    }
}

