/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.openhab.core.io.rest.JSONInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONResponse {
    private static final JSONResponse INSTANCE = new JSONResponse();
    private final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
    static final String JSON_KEY_ERROR_MESSAGE = "message";
    static final String JSON_KEY_ERROR = "error";
    static final String JSON_KEY_HTTPCODE = "http-code";
    static final String JSON_KEY_ENTITY = "entity";

    private JSONResponse() {
    }

    public static Response createErrorResponse(Response.StatusType status, String errormessage) {
        return JSONResponse.createResponse(status, null, errormessage);
    }

    public static Response createResponse(Response.StatusType status, Object entity, String errormessage) {
        if (status.getFamily() != Response.Status.Family.SUCCESSFUL) {
            return INSTANCE.createErrorResponse(status, entity, errormessage);
        }
        return INSTANCE.createResponse(status, entity);
    }

    private Response.ResponseBuilder responseBuilder(Response.StatusType status) {
        return Response.status((Response.StatusType)status).header("Content-Type", (Object)"application/json");
    }

    private JsonElement createErrorJson(String message, Response.StatusType status, Object entity, Exception ex) {
        JsonObject resultJson = new JsonObject();
        JsonObject errorJson = new JsonObject();
        resultJson.add(JSON_KEY_ERROR, (JsonElement)errorJson);
        errorJson.addProperty(JSON_KEY_ERROR_MESSAGE, message);
        if (status != null) {
            errorJson.addProperty(JSON_KEY_HTTPCODE, (Number)status.getStatusCode());
        }
        if (entity != null) {
            resultJson.add(JSON_KEY_ENTITY, this.gson.toJsonTree(entity));
        }
        if (ex != null) {
            JsonObject exceptionJson = new JsonObject();
            exceptionJson.addProperty("class", ex.getClass().getName());
            exceptionJson.addProperty(JSON_KEY_ERROR_MESSAGE, ex.getMessage());
            exceptionJson.addProperty("localized-message", ex.getLocalizedMessage());
            exceptionJson.addProperty("cause", ex.getCause() != null ? ex.getCause().getClass().getName() : null);
            errorJson.add("exception", (JsonElement)exceptionJson);
        }
        return resultJson;
    }

    private Response createErrorResponse(Response.StatusType status, Object entity, String errormessage) {
        Response.ResponseBuilder rp = this.responseBuilder(status);
        JsonElement errorJson = this.createErrorJson(errormessage, status, entity, null);
        rp.entity((Object)errorJson);
        return rp.build();
    }

    private Response createResponse(Response.StatusType status, Object entity) {
        Response.ResponseBuilder rp = this.responseBuilder(status);
        if (entity == null) {
            return rp.build();
        }
        rp.entity(target -> {
            JsonWriter jsonWriter = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(target, StandardCharsets.UTF_8)));
            this.gson.toJson(entity, entity.getClass(), jsonWriter);
            jsonWriter.flush();
        });
        return rp.build();
    }

    public static class ExceptionMapper
    implements javax.ws.rs.ext.ExceptionMapper<Exception> {
        private final Logger logger = LoggerFactory.getLogger(ExceptionMapper.class);

        /*
         * WARNING - void declaration
         */
        public Response toResponse(Exception e) {
            this.logger.debug("Exception during REST handling.", (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            Exception exception = e;
            if (exception instanceof WebApplicationException) {
                void exception2;
                WebApplicationException webApplicationException = (WebApplicationException)exception;
                WebApplicationException cfr_ignored_0 = (WebApplicationException)exception;
                status = exception2.getResponse().getStatusInfo();
            }
            JsonElement ret = INSTANCE.createErrorJson(e.getMessage(), (Response.StatusType)status, null, e);
            return INSTANCE.responseBuilder((Response.StatusType)status).entity((Object)JSONResponse.INSTANCE.gson.toJson(ret)).build();
        }
    }

    private static class PipedJSONInputStream
    extends PipedInputStream
    implements JSONInputStream {
        public PipedJSONInputStream(PipedOutputStream src) throws IOException {
            super(src);
        }
    }
}

