/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.property;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eigenbase.util.property.Property;

class PersistentPropertyStorage {
    private static final HashMap propertyFileMap = new HashMap();
    private File propertyFile;

    private PersistentPropertyStorage(File file) {
        this.propertyFile = file;
    }

    static synchronized PersistentPropertyStorage newPersistentPropertyStorage(String string) throws IOException {
        File file = new File(string);
        String string2 = file.getCanonicalPath();
        if (propertyFileMap.containsKey(string2)) {
            return (PersistentPropertyStorage)propertyFileMap.get(string2);
        }
        PersistentPropertyStorage persistentPropertyStorage = new PersistentPropertyStorage(file);
        propertyFileMap.put(string2, persistentPropertyStorage);
        return persistentPropertyStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void storeProperty(Property property) throws IOException {
        Closeable closeable;
        boolean bl = this.propertyFile.exists();
        boolean bl2 = false;
        File file = null;
        if (bl) {
            Object object;
            Object object2;
            file = File.createTempFile("eigenbase", ".properties");
            closeable = new FileReader(this.propertyFile);
            try {
                object2 = new FileWriter(file);
                try {
                    int n;
                    object = new char[4096];
                    while ((n = ((Reader)closeable).read((char[])object)) != -1) {
                        ((OutputStreamWriter)object2).write((char[])object, 0, n);
                    }
                    ((OutputStreamWriter)object2).flush();
                }
                finally {
                    ((OutputStreamWriter)object2).close();
                }
            }
            finally {
                ((InputStreamReader)closeable).close();
            }
            object2 = Pattern.compile("^#?\\Q" + property.getPath() + "\\E=.*");
            object = ((Pattern)object2).matcher("");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.propertyFile));
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        ((Matcher)object).reset(string);
                        if (((Matcher)object).matches()) {
                            this.writePropertyValue(bufferedWriter, property);
                            bl2 = true;
                        } else {
                            bufferedWriter.write(string);
                        }
                        bufferedWriter.newLine();
                    }
                    bufferedWriter.flush();
                }
                finally {
                    bufferedWriter.close();
                }
            }
            finally {
                bufferedReader.close();
                file.delete();
            }
        }
        if (!bl2) {
            closeable = new BufferedWriter(new FileWriter(this.propertyFile, true));
            try {
                ((BufferedWriter)closeable).newLine();
                this.writePropertyValue((Writer)closeable, property);
                ((BufferedWriter)closeable).newLine();
                ((BufferedWriter)closeable).flush();
            }
            finally {
                ((BufferedWriter)closeable).close();
            }
        }
    }

    private void writePropertyValue(Writer writer, Property property) throws IOException {
        writer.write(property.getPath());
        writer.write(61);
        String string = property.getInternal(null, false);
        if (string != null) {
            writer.write(string);
        }
    }
}

