// Copyright 2022 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

#include "../../../../../runtime/textflag.h"

TEXT asmtest(SB),DUPOK|NOSPLIT,$0
lable1:
	BFPT	1(PC)				// 00050048
	BFPT	lable1		// BFPT 2	// 1ffdff4b
	BFPT	FCC0, lable1	// BFPT FCC0, 2	// 1ff9ff4b
	BFPT	FCC7, lable1	// BFPT FCC7, 2	// fff5ff4b

lable2:
	BFPF	1(PC)				// 00040048
	BFPF	lable2		// BFPF 6 	// 1ffcff4b
	BFPF	FCC0, lable2	// BFPF FCC0, 6	// 1ff8ff4b
	BFPF	FCC7, lable2	// BFPF FCC7, 6	// fff4ff4b

	// relocation in play so the assembled offset should be 0
	JMP	foo(SB)			// 00000050

	JMP	(R4)			// 8000004c
	JMP	1(PC)			// 00040050
	MOVW	$65536, R4		// 04020014
	MOVW	$4096, R4		// 24000014
	MOVV	$65536, R4		// 04020014
	MOVB	R4, R5			// 855c0000
	MOVH	R4, R5			// 85580000
	MOVV	$4096, R4		// 24000014
	MOVW	R4, R5			// 85001700
	MOVWU	R4, R5			// 8500df00
	MOVV	R4, R5			// 85001500
	MOVBU	R4, R5			// 85fc4303
	SUB	R4, R5, R6		// a6101100
	SUBV	R4, R5, R6		// a6901100
	ADD	R4, R5, R6		// a6101000
	ADDV	R4, R5, R6		// a6901000
	AND	R4, R5, R6		// a6901400
	SUB	R4, R5			// a5101100
	SUBV	R4, R5			// a5901100
	ADD	R4, R5			// a5101000
	ADDV	R4, R5			// a5901000
	AND	R4, R5			// a5901400
	NEGW	R4, R5			// 05101100
	NEGV	R4, R5			// 05901100
	SLL	R4, R5			// a5101700
	SLL	R4, R5, R6		// a6101700
	SRL	R4, R5			// a5901700
	SRL	R4, R5, R6	 	// a6901700
	SRA	R4, R5			// a5101800
	SRA	R4, R5, R6	 	// a6101800
	ROTR	R4, R5			// a5101b00
	ROTR	R4, R5, R6		// a6101b00
	SLLV	R4, R5			// a5901800
	SLLV	R4, R5, R6		// a6901800
	ROTRV	R4, R5			// a5901b00
	ROTRV	R4, R5, R6		// a6901b00
	CLOW	R4, R5			// 85100000
	CLZW	R4, R5			// 85140000
	CTOW	R4, R5			// 85180000
	CTZW	R4, R5			// 851c0000
	CLOV	R4, R5			// 85200000
	CLZV	R4, R5			// 85240000
	CTOV	R4, R5			// 85280000
	CTZV	R4, R5			// 852c0000
	REVB2H	R4, R5			// 85300000
	REVB4H	R4, R5			// 85340000
	REVB2W	R4, R5			// 85380000
	REVBV	R4, R5			// 853c0000
	REVH2W	R4, R5			// 85400000
	REVHV	R4, R5			// 85440000
	BITREV4B	R4, R5		// 85480000
	BITREVW	R4, R5			// 85500000
	BITREV8B	R4, R5		// 854c0000
	BITREVV	R4, R5			// 85540000
	EXTWB	R4, R5			// 855c0000
	EXTWH	R4, R5			// 85580000
	CPUCFG	R4, R5			// 856c0000
	ADDF	F4, F5			// a5900001
	ADDF	F4, F5, F6		// a6900001
	ABSF	F4, F5			// 85041401
	MOVVF	F4, F5			// 85181d01
	MOVF	F4, F5			// 85941401
	MOVD	F4, F5			// 85981401
	MOVW	R4, result+16(FP)	// 64608029
	MOVWU	R4, result+16(FP)	// 64608029
	MOVV	R4, result+16(FP)	// 6460c029
	MOVB	R4, result+16(FP)	// 64600029
	MOVBU	R4, result+16(FP)	// 64600029
	MOVW	R4, 1(R5)		// a4048029
	MOVWU	R4, 1(R5)		// a4048029
	MOVV	R4, 1(R5)		// a404c029
	MOVB	R4, 1(R5)		// a4040029
	MOVBU	R4, 1(R5)		// a4040029
	SC	R4, 1(R5)		// a4040021
	SCV	R4, 1(R5)		// a4040023
	MOVW	y+8(FP), R4		// 64408028
	MOVWU	y+8(FP), R4		// 6440802a
	MOVV	y+8(FP), R4		// 6440c028
	MOVB	y+8(FP), R4		// 64400028
	MOVBU	y+8(FP), R4		// 6440002a
	MOVW	1(R5), R4		// a4048028
	MOVWU	1(R5), R4		// a404802a
	MOVV	1(R5), R4		// a404c028
	MOVB	1(R5), R4		// a4040028
	MOVBU	1(R5), R4		// a404002a
	LL	1(R5), R4		// a4040020
	LLV	1(R5), R4		// a4040022
	MOVW	$4(R4), R5		// 8510c002
	MOVV	$4(R4), R5		// 8510c002
	MOVW	$-1, R4			// 04fcff02
	MOVV	$-1, R4			// 04fcff02
	MOVW	$1, R4			// 04048003
	MOVV	$1, R4			// 04048003
	ADD	$-1, R4, R5		// 85fcbf02
	ADD	$-1, R4			// 84fcbf02
	ADDV	$-1, R4, R5		// 85fcff02
	ADDV	$-1, R4			// 84fcff02
	AND	$1, R4, R5		// 85044003
	AND	$1, R4			// 84044003
	SLL	$4, R4, R5		// 85904000
	SLL	$4, R4			// 84904000
	SRL	$4, R4, R5		// 85904400
	SRL	$4, R4			// 84904400
	SRA	$4, R4, R5		// 85904800
	SRA	$4, R4			// 84904800
	ROTR	$4, R4, R5		// 85904c00
	ROTR	$4, R4			// 84904c00
	SLLV	$4, R4, R5		// 85104100
	SLLV	$4, R4			// 84104100
	ROTRV	$4, R4, R5		// 85104d00
	ROTRV	$4, R4			// 84104d00
	SYSCALL				// 00002b00
	BEQ	R4, R5, 1(PC)		// 85040058
	BEQ	R4, 1(PC)		// 80040040
	BEQ	R4, R0, 1(PC)		// 80040040
	BEQ	R0, R4, 1(PC)		// 80040040
	BNE	R4, R5, 1(PC)		// 8504005c
	BNE	R4, 1(PC)		// 80040044
	BNE	R4, R0, 1(PC)		// 80040044
	BNE	R0, R4, 1(PC)		// 80040044
	BLTU	R4, 1(PC)		// 80040068
	MOVF	y+8(FP), F4		// 6440002b
	MOVD	y+8(FP), F4		// 6440802b
	MOVF	1(F5), F4		// a404002b
	MOVD	1(F5), F4		// a404802b
	MOVF	F4, result+16(FP)	// 6460402b
	MOVD	F4, result+16(FP)	// 6460c02b
	MOVF	F4, 1(F5)		// a404402b
	MOVD	F4, 1(F5)		// a404c02b
	MOVW	R4, F5			// 85a41401
	MOVW	F4, R5			// 85b41401
	MOVV	R4, F5			// 85a81401
	MOVV	F4, R5			// 85b81401
	WORD	$74565			// 45230100
	BREAK				// 00002a00
	UNDEF				// 00002a00

	ANDN	R4, R5, R6		// a6901600
	ANDN	R4, R5			// a5901600
	ORN	R4, R5, R6		// a6101600
	ORN	R4, R5			// a5101600

	// mul
	MUL	R4, R5	  		// a5101c00
	MUL	R4, R5, R6	  	// a6101c00
	MULV	R4, R5	   		// a5901d00
	MULV	R4, R5, R6	   	// a6901d00
	MULVU	R4, R5			// a5901d00
	MULVU	R4, R5, R6		// a6901d00
	MULHV	R4, R5			// a5101e00
	MULHV	R4, R5, R6		// a6101e00
	MULHVU	R4, R5			// a5901e00
	MULHVU	R4, R5, R6	 	// a6901e00
	REMV	R4, R5	   		// a5902200
	REMV	R4, R5, R6	   	// a6902200
	REMVU	R4, R5			// a5902300
	REMVU	R4, R5, R6		// a6902300
	DIVV	R4, R5			// a5102200
	DIVV	R4, R5, R6	   	// a6102200
	DIVVU	R4, R5	 		// a5102300
	DIVVU	R4, R5, R6		// a6102300

	MOVH	R4, result+16(FP)	// 64604029
	MOVH	R4, 1(R5)		// a4044029
	MOVH	y+8(FP), R4		// 64404028
	MOVH	1(R5), R4		// a4044028
	MOVHU	R4, R5			// 8500cf00
	MOVHU	R4, result+16(FP)	// 64604029
	MOVHU	R4, 1(R5)		// a4044029
	MOVHU	y+8(FP), R4		// 6440402a
	MOVHU	1(R5), R4		// a404402a
	MULU	R4, R5	   		// a5101c00
	MULU	R4, R5, R6		// a6101c00
	MULH	R4, R5	   		// a5901c00
	MULH	R4, R5, R6	   	// a6901c00
	MULHU	R4, R5			// a5101d00
	MULHU	R4, R5, R6		// a6101d00
	REM	R4, R5	  		// a5902000
	REM	R4, R5, R6	  	// a6902000
	REMU	R4, R5	   		// a5902100
	REMU	R4, R5, R6	   	// a6902100
	DIV	R4, R5	  		// a5102000
	DIV	R4, R5, R6	  	// a6102000
	DIVU	R4, R5	   		// a5102100
	DIVU	R4, R5, R6	   	// a6102100
	SRLV	R4, R5 			// a5101900
	SRLV	R4, R5, R6 		// a6101900
	SRLV	$4, R4, R5		// 85104500
	SRLV	$4, R4			// 84104500
	SRLV	$32, R4, R5 		// 85804500
	SRLV	$32, R4			// 84804500

	MASKEQZ	R4, R5, R6		// a6101300
	MASKNEZ	R4, R5, R6		// a6901300

	// CRC32
	CRCWBW	R4, R5, R6		// a6102400
	CRCWHW	R4, R5, R6		// a6902400
	CRCWWW	R4, R5, R6		// a6102500
	CRCWVW	R4, R5, R6		// a6902500
	CRCCWBW	R4, R5, R6		// a6102600
	CRCCWHW	R4, R5, R6		// a6902600
	CRCCWWW	R4, R5, R6		// a6102700
	CRCCWVW	R4, R5, R6		// a6902700

	MOVFD	F4, F5			// 85241901
	MOVDF	F4, F5			// 85181901
	MOVWF	F4, F5			// 85101d01
	MOVFW	F4, F5			// 85041b01
	MOVWD	F4, F5			// 85201d01
	MOVDW	F4, F5			// 85081b01
	NEGF	F4, F5			// 85141401
	NEGD	F4, F5			// 85181401
	ABSD	F4, F5			// 85081401
	TRUNCDW	F4, F5			// 85881a01
	TRUNCFW	F4, F5			// 85841a01
	SQRTF	F4, F5			// 85441401
	SQRTD	F4, F5			// 85481401

	DBAR	 			// 00007238
	NOOP	 			// 00004003

	CMPEQF	F4, F5, FCC0		// a010120c
	CMPGTF	F4, F5, FCC1 		// a190110c
	CMPGTD	F4, F5, FCC2 		// a290210c
	CMPGEF	F4, F5, FCC3		// a390130c
	CMPGED	F4, F5, FCC4		// a490230c
	CMPEQD	F4, F5, FCC5		// a510220c

	RDTIMELW R4, R0			// 80600000
	RDTIMEHW R4, R0			// 80640000
	RDTIMED  R4, R5			// 85680000

	MOVV	R4, FCSR3		// 83c01401
	MOVV	FCSR3, R4		// 64c81401
	MOVV	F4, FCC0		// 80d01401
	MOVV	FCC0, F4		// 04d41401
	MOVV    FCC0, R4		// 04dc1401
	MOVV    R4, FCC0		// 80d81401

	// Loong64 atomic memory access instructions
	AMSWAPB		R14, (R13), R12 // ac395c38
	AMSWAPH		R14, (R13), R12 // acb95c38
	AMSWAPW		R14, (R13), R12 // ac396038
	AMSWAPV		R14, (R13), R12 // acb96038
	AMCASB		R14, (R13), R12 // ac395838
	AMCASH		R14, (R13), R12 // acb95838
	AMCASW		R14, (R13), R12 // ac395938
	AMCASV		R14, (R13), R12 // acb95938
	AMADDW		R14, (R13), R12 // ac396138
	AMADDV		R14, (R13), R12 // acb96138
	AMANDW		R14, (R13), R12 // ac396238
	AMANDV		R14, (R13), R12 // acb96238
	AMORW		R14, (R13), R12 // ac396338
	AMORV		R14, (R13), R12 // acb96338
	AMXORW		R14, (R13), R12 // ac396438
	AMXORV		R14, (R13), R12 // acb96438
	AMMAXW		R14, (R13), R12 // ac396538
	AMMAXV		R14, (R13), R12 // acb96538
	AMMINW		R14, (R13), R12 // ac396638
	AMMINV		R14, (R13), R12 // acb96638
	AMMAXWU		R14, (R13), R12 // ac396738
	AMMAXVU		R14, (R13), R12 // acb96738
	AMMINWU		R14, (R13), R12 // ac396838
	AMMINVU		R14, (R13), R12 // acb96838
	AMSWAPDBB	R14, (R13), R12 // ac395e38
	AMSWAPDBH	R14, (R13), R12 // acb95e38
	AMSWAPDBW	R14, (R13), R12 // ac396938
	AMSWAPDBV	R14, (R13), R12 // acb96938
	AMCASDBB	R14, (R13), R12 // ac395a38
	AMCASDBH	R14, (R13), R12 // acb95a38
	AMCASDBW	R14, (R13), R12 // ac395b38
	AMCASDBV	R14, (R13), R12 // acb95b38
	AMADDDBW	R14, (R13), R12 // ac396a38
	AMADDDBV	R14, (R13), R12 // acb96a38
	AMANDDBW	R14, (R13), R12 // ac396b38
	AMANDDBV	R14, (R13), R12 // acb96b38
	AMORDBW		R14, (R13), R12 // ac396c38
	AMORDBV		R14, (R13), R12 // acb96c38
	AMXORDBW	R14, (R13), R12 // ac396d38
	AMXORDBV	R14, (R13), R12 // acb96d38
	AMMAXDBW	R14, (R13), R12 // ac396e38
	AMMAXDBV	R14, (R13), R12 // acb96e38
	AMMINDBW	R14, (R13), R12 // ac396f38
	AMMINDBV	R14, (R13), R12 // acb96f38
	AMMAXDBWU	R14, (R13), R12 // ac397038
	AMMAXDBVU	R14, (R13), R12 // acb97038
	AMMINDBWU	R14, (R13), R12 // ac397138
	AMMINDBVU	R14, (R13), R12 // acb97138

	FMADDF	F2, F14, F9, F16	// 30391108
	FMADDD	F11, F20, F23, F12	// ecd22508
	FMSUBF	F3, F11, F31, F22	// f6af5108
	FMSUBD	F13, F30, F9, F15	// 2ff96608
	FNMADDF	F27, F11, F5, F21	// b5ac9d08
	FNMADDD	F29, F14, F27, F6	// 66bbae08
	FNMSUBF	F17, F8, F12, F8	// 88a1d808
	FNMSUBD	F29, F21, F3, F17	// 71d4ee08
	FMADDF	F2, F14, F9		// 29391108
	FMADDD	F11, F20, F23		// f7d22508
	FMSUBF	F3, F11, F31		// ffaf5108
	FMSUBD	F13, F30, F9		// 29f96608
	FNMADDF	F27, F11, F5		// a5ac9d08
	FNMADDD	F29, F14, F27		// 7bbbae08
	FNMSUBF	F17, F8, F12		// 8ca1d808
	FNMSUBD	F29, F21, F3		// 63d4ee08

	FMINF	F4, F5, F6		// a6900a01
	FMINF	F4, F5			// a5900a01
	FMIND	F4, F5, F6		// a6100b01
	FMIND	F4, F5			// a5100b01
	FMAXF	F4, F5, F6		// a6900801
	FMAXF	F4, F5			// a5900801
	FMAXD	F4, F5, F6		// a6100901
	FMAXD	F4, F5			// a5100901

	FCOPYSGF	F4, F5, F6	// a6901201
	FCOPYSGD	F4, F5, F6	// a6101301
	FCLASSF		F4, F5		// 85341401
	FCLASSD		F4, F5		// 85381401

	FFINTFW		F0, F1		// 01101d01
	FFINTFV		F0, F1		// 01181d01
	FFINTDW		F0, F1		// 01201d01
	FFINTDV		F0, F1		// 01281d01
	FTINTWF		F0, F1		// 01041b01
	FTINTWD		F0, F1		// 01081b01
	FTINTVF		F0, F1		// 01241b01
	FTINTVD		F0, F1		// 01281b01

	FMAXAF		F4, F5, F6	// a6900c01
	FMAXAF		F4, F5		// a5900c01
	FMAXAD		F4, F5, F6	// a6100d01
	FMAXAD		F4, F5		// a5100d01
	FMINAF		F4, F5, F6	// a6900e01
	FMINAF		F4, F5		// a5900e01
	FMINAD		F4, F5, F6	// a6100f01
	FMINAD		F4, F5		// a5100f01

	FTINTRMWF	F0, F2		// 02041a01
	FTINTRMWD	F0, F2		// 02081a01
	FTINTRMVF	F0, F2		// 02241a01
	FTINTRMVD	F0, F2		// 02281a01
	FTINTRPWF	F0, F2		// 02441a01
	FTINTRPWD	F0, F2		// 02481a01
	FTINTRPVF	F0, F2		// 02641a01
	FTINTRPVD	F0, F2		// 02681a01
	FTINTRZWF	F0, F2		// 02841a01
	FTINTRZWD	F0, F2		// 02881a01
	FTINTRZVF	F0, F2		// 02a41a01
	FTINTRZVD	F0, F2		// 02a81a01
	FTINTRNEWF	F0, F2		// 02c41a01
	FTINTRNEWD	F0, F2		// 02c81a01
	FTINTRNEVF	F0, F2		// 02e41a01
	FTINTRNEVD	F0, F2		// 02e81a01

	// LDX.{B,BU,H,HU,W,WU,D} instructions
	MOVB		(R14)(R13), R12	// cc350038
	MOVBU		(R14)(R13), R12	// cc352038
	MOVH		(R14)(R13), R12	// cc350438
	MOVHU		(R14)(R13), R12	// cc352438
	MOVW		(R14)(R13), R12	// cc350838
	MOVWU		(R14)(R13), R12	// cc352838
	MOVV		(R14)(R13), R12	// cc350c38

	// STX.{B,H,W,D} instructions
	MOVB		R12, (R14)(R13)	// cc351038
	MOVH		R12, (R14)(R13)	// cc351438
	MOVW		R12, (R14)(R13)	// cc351838
	MOVV		R12, (R14)(R13)	// cc351c38

	// FLDX.{S,D} instructions
	MOVF		(R14)(R13), F2	// c2353038
	MOVD		(R14)(R13), F2	// c2353438

	// FSTX.{S,D} instructions
	MOVF		F2, (R14)(R13)	// c2353838
	MOVD		F2, (R14)(R13)	// c2353c38

	BSTRINSW	$0, R4, $0, R5	// 85006000
	BSTRINSW	$31, R4, $0, R5	// 85007f00
	BSTRINSW	$15, R4, $6, R5	// 85186f00
	BSTRINSV	$0, R4, $0, R5	// 85008000
	BSTRINSV	$63, R4, $0, R5	// 8500bf00
	BSTRINSV	$15, R4, $6, R5	// 85188f00

	BSTRPICKW	$0, R4, $0, R5	// 85806000
	BSTRPICKW	$31, R4, $0, R5	// 85807f00
	BSTRPICKW	$15, R4, $6, R5	// 85986f00
	BSTRPICKV	$0, R4, $0, R5	// 8500c000
	BSTRPICKV	$63, R4, $0, R5	// 8500ff00
	BSTRPICKV	$15, R4, $6, R5	// 8518cf00

	FSCALEBF	F4, F5, F6	// a6901001
	FSCALEBD	F4, F5, F6	// a6101101
	FLOGBF		F4, F5		// 85241401
	FLOGBD		F4, F5		// 85281401

	// VSTX/VLDX/XVSTX/XVLDX instructions
	VMOVQ		V2, (R5)(R5)    // a2144438
	VMOVQ		(R4)(R5), V2    // 82144038
	XVMOVQ		X2, (R4)(R5)    // 82144c38
	XVMOVQ		(R4)(R5), X2    // 82144838

	// VST/VLD/XVST/XVLD instructions
	VMOVQ		V2, (R4)        // 8200402c
	VMOVQ		V2, 3(R4)       // 820c402c
	VMOVQ		V2, 2040(R4)    // 82e05f2c
	VMOVQ		V2, -2040(R4)   // 8220602c
	VMOVQ		V2, y+16(FP)    // 0260402c
	VMOVQ		V2, x+2030(FP)  // 02d85f2c
	VMOVQ		(R4), V2        // 8200002c
	VMOVQ		3(R4), V2       // 820c002c
	VMOVQ		2044(R4), V2    // 82f01f2c
	VMOVQ		-2044(R4), V2   // 8210202c
	VMOVQ		y+16(FP), V2    // 0260002c
	VMOVQ		x+2030(FP), V2  // 02d81f2c
	XVMOVQ		X2, (R4)        // 8200c02c
	XVMOVQ		X3, 3(R4)       // 830cc02c
	XVMOVQ		X4, 2040(R4)    // 84e0df2c
	XVMOVQ		X5, -2040(R4)   // 8520e02c
	XVMOVQ		X6, y+16(FP)    // 0660c02c
	XVMOVQ		X7, x+2030(FP)  // 07d8df2c
	XVMOVQ		(R4), X2        // 8200802c
	XVMOVQ		3(R4), X3       // 830c802c
	XVMOVQ		2044(R4), X4    // 84f09f2c
	XVMOVQ		-2044(R4), X5   // 8510a02c
	XVMOVQ		y+16(FP), X6    // 0660802c
	XVMOVQ		x+2030(FP), X7  // 07d89f2c

	// Move vector element to general-purpose register: VMOVQ  <Vn>.<T>[index], Rd
	VMOVQ		V0.B[0], R4     // 0480ef72
	VMOVQ		V3.B[3], R5     // 658cef72
	VMOVQ		V4.H[2], R6     // 86c8ef72
	VMOVQ		V5.W[2], R7     // a7e8ef72
	VMOVQ		V6.V[1], R8     // c8f4ef72
	VMOVQ		V7.BU[0], R4    // e480f372
	VMOVQ		V7.BU[1], R4    // e484f372
	VMOVQ		V9.BU[3], R5    // 258df372
	VMOVQ		V10.HU[2], R6   // 46c9f372
	VMOVQ		V11.WU[2], R7   // 67e9f372
	VMOVQ		V31.VU[1], R8   // e8f7f372
	XVMOVQ		X1.W[2], R7     // 27c8ef76
	XVMOVQ		X6.V[2], R8     // c8e8ef76
	XVMOVQ		X8.WU[2], R7    // 07c9f376
	XVMOVQ		X31.VU[2], R8   // e8ebf376

	// Move general-purpose register to a vector element: VMOVQ  Rn, <Vd>.<T>[index]
	VMOVQ		R4, V2.B[0]     // 8280eb72
	VMOVQ		R4, V3.B[1]     // 8384eb72
	VMOVQ		R5, V4.B[3]     // a48ceb72
	VMOVQ		R6, V5.H[2]     // c5c8eb72
	VMOVQ		R7, V6.W[2]     // e6e8eb72
	VMOVQ		R8, V7.V[1]     // 07f5eb72
	XVMOVQ		R7, X9.W[2]     // e9c8eb76
	XVMOVQ		R8, X10.V[2]    // 0ae9eb76

	// Duplicate general-purpose register to vector
	VMOVQ		R4, V2.B16      // 82009f72
	VMOVQ		R5, V3.H8       // a3049f72
	VMOVQ		R6, V4.W4       // c4089f72
	VMOVQ		R7, V5.V2       // e50c9f72
	XVMOVQ		R16, X31.B32    // 1f029f76
	XVMOVQ		R17, X28.H16    // 3c069f76
	XVMOVQ		R18, X10.W8     // 4a0a9f76
	XVMOVQ		R19, X9.V4      // 690e9f76

	// Move vector
	XVMOVQ		X0, X31.B32     // 1f000777
	XVMOVQ		X1, X30.H16     // 3e800777
	XVMOVQ		X2, X29.W8      // 5dc00777
	XVMOVQ		X3, X28.V4      // 7ce00777
	XVMOVQ		X3, X27.Q2      // 7bf00777

	// Move vector element to scalar.
	XVMOVQ		X0, X31.W[7]    // 1fdcff76
	XVMOVQ		X1, X29.W[0]    // 3dc0ff76
	XVMOVQ		X3, X28.V[3]    // 7cecff76
	XVMOVQ		X4, X27.V[0]    // 9be0ff76
	XVMOVQ		X31.W[7], X0    // e0df0377
	XVMOVQ		X29.W[0], X1    // a1c30377
	XVMOVQ		X28.V[3], X8    // 88ef0377
	XVMOVQ		X27.V[0], X9    // 69e30377

	//Move vector element to vector.
	VMOVQ		V1.B[3], V9.B16 // 298cf772
	VMOVQ		V2.H[2], V8.H8  // 48c8f772
	VMOVQ		V3.W[1], V7.W4  // 67e4f772
	VMOVQ		V4.V[0], V6.V2  // 86f0f772

	// VSEQ{B,H,W,V}, XVSEQ{B,H,W,V} instruction
	VSEQB		V1, V2, V3      // 43040070
	VSEQH		V1, V2, V3      // 43840070
	VSEQW		V1, V2, V3      // 43040170
	VSEQV		V1, V2, V3      // 43840170
	XVSEQB		X3, X2, X4      // 440c0074
	XVSEQH		X3, X2, X4      // 448c0074
	XVSEQW		X3, X2, X4      // 440c0174
	XVSEQV		X3, X2, X4      // 448c0174
	VSEQB		$0, V2, V3      // 43008072
	VSEQH		$1,  V2, V3     // 43848072
	VSEQW		$8, V2, V3      // 43208172
	VSEQV		$15, V2, V3     // 43bc8172
	VSEQV		$-15, V2, V3    // 43c48172
	XVSEQB		$0, X2, X4      // 44008076
	XVSEQH		$3, X2, X4      // 448c8076
	XVSEQW		$12, X2, X4     // 44308176
	XVSEQV		$15, X2, X4     // 44bc8176
	XVSEQV		$-15, X2, X4    // 44c48176

	// VPCNT{B,H,W,V}, XVPCNT{B,H,W,V} instruction
	VPCNTB		V1, V2          // 22209c72
	VPCNTH		V1, V2          // 22249c72
	VPCNTW		V1, V2          // 22289c72
	VPCNTV		V1, V2          // 222c9c72
	XVPCNTB		X3, X2          // 62209c76
	XVPCNTH		X3, X2          // 62249c76
	XVPCNTW		X3, X2          // 62289c76
	XVPCNTV		X3, X2          // 622c9c76

	// VANDV,VORV,VXORV,VNORV,VANDNV,VORNV
	VANDV		V1, V2, V3      // 43042671
	VORV		V1, V2, V3      // 43842671
	VXORV		V1, V2, V3      // 43042771
	VNORV		V1, V2, V3      // 43842771
	VANDNV		V1, V2, V3      // 43042871
	VORNV		V1, V2, V3      // 43842871
	VANDV		V1, V2		// 42042671
	VORV		V1, V2		// 42842671
	VXORV		V1, V2		// 42042771
	VNORV		V1, V2		// 42842771
	VANDNV		V1, V2		// 42042871
	VORNV		V1, V2		// 42842871

	// VANDB,VORB,VXORB,VNORB
	VANDB		$0, V2, V3      // 4300d073
	VORB		$64, V2, V3     // 4300d573
	VXORB		$128, V2, V3    // 4300da73
	VNORB		$255, V2, V3    // 43fcdf73
	VANDB		$0, V2		// 4200d073
	VORB		$64, V2		// 4200d573
	VXORB		$128, V2	// 4200da73
	VNORB		$255, V2	// 42fcdf73

	// XVANDV,XVORV,XVXORV,XVNORV,XVANDNV,XVORNV
	XVANDV		X1, X2, X3      // 43042675
	XVORV		X1, X2, X3      // 43842675
	XVXORV		X1, X2, X3      // 43042775
	XVNORV		X1, X2, X3      // 43842775
	XVANDNV		X1, X2, X3      // 43042875
	XVORNV		X1, X2, X3      // 43842875
	XVANDV		X1, X2		// 42042675
	XVORV		X1, X2		// 42842675
	XVXORV		X1, X2		// 42042775
	XVNORV		X1, X2		// 42842775
	XVANDNV		X1, X2		// 42042875
	XVORNV		X1, X2		// 42842875

	// XVANDB,XVORB,XVXORB,XVNORB
	XVANDB		$0, X2, X3      // 4300d077
	XVORB		$1, X2, X3      // 4304d477
	XVXORB		$127, X2, X3    // 43fcd977
	XVNORB		$255, X2, X3    // 43fcdf77
	XVANDB		$0, X2		// 4200d077
	XVORB		$1, X2		// 4204d477
	XVXORB		$127, X2	// 42fcd977
	XVNORB		$255, X2	// 42fcdf77

	// MOVV C_DCON12_0, r
	MOVV    $0x7a90000000000000, R4         // MOVV $8831558869273542656, R4        // 04a41e03
	MOVV    $0xea90000000000000, R4         // MOVV $-1544734672188080128, R4       // 04a43a03

	// MOVV C_UCON, r
	MOVV    $0x54321000, R4                 // MOVV $1412567040, R4                 // 2464a814
	MOVV    $0xffffffff8432f000, R4         // MOVV $-2077036544, R4                // e4650815

	// MOVV C_ADDCON, r
	MOVV    $0xfffffffffffff821, R4         // MOVV $-2015, R4                      // 0484e002

	// MOVV C_ANDCON, r
	MOVV $0x821, R4                         // MOVV $2081, R4                       // 0484a003

	// ADDV C_SCON, [r1], r2
	ADDV	$0x321, R4			// ADDV	$801, R4			// 8484cc02
	ADDV	$0x321, R5, R4			// ADDV	$801, R5, R4			// a484cc02
	ADDV	$0xfffffffffffffc21, R4		// ADDV	$-991, R4			// 8484f002
	ADDV	$0xfffffffffffffc21, R5, R4	// ADDV	$-991, R5, R4			// a484f002

	// AND C_SCON, [r1], r2
	AND	$0x321, R4			// AND	$801, R4			// 84844c03
	AND	$0x321, R5, R4			// AND	$801, R5, R4			// a4844c03

	// [X]{VSLL/VSRL/VSRA/VROTR}{B,H,W,V} instructions
	VSLLB		V1, V2, V3	// 4304e870
	VSLLH		V1, V2, V3	// 4384e870
	VSLLW		V1, V2, V3	// 4304e970
	VSLLV		V1, V2, V3	// 4384e970
	VSRLB		V1, V2, V3	// 4304ea70
	VSRLH		V1, V2, V3	// 4384ea70
	VSRLW		V1, V2, V3	// 4304eb70
	VSRLV		V1, V2, V3	// 4384eb70
	VSRAB		V1, V2, V3	// 4304ec70
	VSRAH		V1, V2, V3	// 4384ec70
	VSRAW		V1, V2, V3	// 4304ed70
	VSRAV		V1, V2, V3	// 4384ed70
	VROTRB		V1, V2, V3	// 4304ee70
	VROTRH		V1, V2, V3	// 4384ee70
	VROTRW		V1, V2, V3	// 4304ef70
	VROTRV		V1, V2, V3	// 4384ef70
	XVSLLB		X3, X2, X1	// 410ce874
	XVSLLH		X3, X2, X1	// 418ce874
	XVSLLW		X3, X2, X1	// 410ce974
	XVSLLV		X3, X2, X1	// 418ce974
	XVSRLB		X3, X2, X1	// 410cea74
	XVSRLH		X3, X2, X1	// 418cea74
	XVSRLW		X3, X2, X1	// 410ceb74
	XVSRLV		X3, X2, X1	// 418ceb74
	XVSRAB		X3, X2, X1	// 410cec74
	XVSRAH		X3, X2, X1	// 418cec74
	XVSRAW		X3, X2, X1	// 410ced74
	XVSRAV		X3, X2, X1	// 418ced74
	XVROTRB		X3, X2, X1	// 410cee74
	XVROTRH		X3, X2, X1	// 418cee74
	XVROTRW		X3, X2, X1	// 410cef74
	XVROTRV		X3, X2, X1	// 418cef74
	VSLLB		$0, V1, V2	// 22202c73
	VSLLB		$7, V1, V2	// 223c2c73
	VSLLB		$5, V1		// 21342c73
	VSLLH		$0, V1, V2	// 22402c73
	VSLLH		$15, V1, V2	// 227c2c73
	VSLLH		$10, V1		// 21682c73
	VSLLW		$0, V1, V2	// 22802c73
	VSLLW		$31, V1, V2	// 22fc2c73
	VSLLW		$11, V1		// 21ac2c73
	VSLLV		$0, V1, V2	// 22002d73
	VSLLV		$63, V1, V2	// 22fc2d73
	VSLLV		$30, V1		// 21782d73
	VSRLB		$0, V1, V2	// 22203073
	VSRLB		$7, V1, V2	// 223c3073
	VSRLB		$4, V1		// 21303073
	VSRLH		$0, V1, V2	// 22403073
	VSRLH		$15, V1, V2	// 227c3073
	VSRLH		$9, V1		// 21643073
	VSRLW		$0, V1, V2	// 22803073
	VSRLW		$31, V1, V2	// 22fc3073
	VSRLW		$16, V1		// 21c03073
	VSRLV		$0, V1, V2	// 22003173
	VSRLV		$63, V1, V2	// 22fc3173
	VSRLV		$40, V1		// 21a03173
	VSRAB		$0, V1, V2	// 22203473
	VSRAB		$7, V1, V2	// 223c3473
	VSRAB		$6, V1		// 21383473
	VSRAH		$0, V1, V2	// 22403473
	VSRAH		$15, V1, V2	// 227c3473
	VSRAH		$8, V1		// 21603473
	VSRAW		$0, V1, V2	// 22803473
	VSRAW		$31, V1, V2	// 22fc3473
	VSRAW		$12, V1		// 21b03473
	VSRAV		$0, V1, V2	// 22003573
	VSRAV		$63, V1, V2	// 22fc3573
	VSRAV		$50, V1		// 21c83573
	VROTRB		$0, V1, V2	// 2220a072
	VROTRB		$7, V1, V2	// 223ca072
	VROTRB		$3, V1		// 212ca072
	VROTRH		$0, V1, V2	// 2240a072
	VROTRH		$15, V1, V2	// 227ca072
	VROTRH		$5, V1		// 2154a072
	VROTRW		$0, V1, V2	// 2280a072
	VROTRW		$31, V1, V2	// 22fca072
	VROTRW		$18, V1		// 21c8a072
	VROTRV		$0, V1, V2	// 2200a172
	VROTRV		$63, V1, V2	// 22fca172
	VROTRV		$52, V1		// 21d0a172
	XVSLLB		$0, X2, X1	// 41202c77
	XVSLLB		$7, X2, X1	// 413c2c77
	XVSLLB		$4, X2		// 42302c77
	XVSLLH		$0, X2, X1	// 41402c77
	XVSLLH		$15, X2, X1	// 417c2c77
	XVSLLH		$8, X2		// 42602c77
	XVSLLW		$0, X2, X1	// 41802c77
	XVSLLW		$31, X2, X1	// 41fc2c77
	XVSLLW		$13, X2		// 42b42c77
	XVSLLV		$0, X2, X1	// 41002d77
	XVSLLV		$63, X2, X1	// 41fc2d77
	XVSLLV		$36, X2		// 42902d77
	XVSRLB		$0, X2, X1	// 41203077
	XVSRLB		$7, X2, X1	// 413c3077
	XVSRLB		$5, X2		// 42343077
	XVSRLH		$0, X2, X1	// 41403077
	XVSRLH		$15, X2, X1	// 417c3077
	XVSRLH		$9, X2		// 42643077
	XVSRLW		$0, X2, X1	// 41803077
	XVSRLW		$31, X2, X1	// 41fc3077
	XVSRLW		$14, X2		// 42b83077
	XVSRLV		$0, X2, X1	// 41003177
	XVSRLV		$63, X2, X1	// 41fc3177
	XVSRLV		$45, X2		// 42b43177
	XVSRAB		$0, X2, X1	// 41203477
	XVSRAB		$7, X2, X1	// 413c3477
	XVSRAB		$6, X2		// 42383477
	XVSRAH		$0, X2, X1	// 41403477
	XVSRAH		$15, X2, X1	// 417c3477
	XVSRAH		$10, X2		// 42683477
	XVSRAW		$0, X2, X1	// 41803477
	XVSRAW		$31, X2, X1	// 41fc3477
	XVSRAW		$16, X2		// 42c03477
	XVSRAV		$0, X2, X1	// 41003577
	XVSRAV		$63, X2, X1	// 41fc3577
	XVSRAV		$48, X2		// 42c03577
	XVROTRB		$0, X2, X1	// 4120a076
	XVROTRB		$7, X2, X1	// 413ca076
	XVROTRB		$3, X2		// 422ca076
	XVROTRH		$0, X2, X1	// 4140a076
	XVROTRH		$15, X2, X1	// 417ca076
	XVROTRH		$13, X2		// 4274a076
	XVROTRW		$0, X2, X1	// 4180a076
	XVROTRW		$31, X2, X1	// 41fca076
	XVROTRW		$24, X2		// 42e0a076
	XVROTRV		$0, X2, X1	// 4100a176
	XVROTRV		$63, X2, X1	// 41fca176
	XVROTRV		$52, X2		// 42d0a176

	// [X]VADD{B,H,W,V,Q}, [X]VSUB{B,H,W,V,Q} instructions
	VADDB		V1, V2, V3	// 43040a70
	VADDH		V1, V2, V3	// 43840a70
	VADDW		V1, V2, V3	// 43040b70
	VADDV		V1, V2, V3	// 43840b70
	VADDQ		V1, V2, V3	// 43042d71
	VSUBB		V1, V2, V3	// 43040c70
	VSUBH		V1, V2, V3	// 43840c70
	VSUBW		V1, V2, V3	// 43040d70
	VSUBV		V1, V2, V3	// 43840d70
	VSUBQ		V1, V2, V3	// 43842d71
	XVADDB		X3, X2, X1	// 410c0a74
	XVADDH		X3, X2, X1	// 418c0a74
	XVADDW		X3, X2, X1	// 410c0b74
	XVADDV		X3, X2, X1	// 418c0b74
	XVADDQ		X3, X2, X1	// 410c2d75
	XVSUBB		X3, X2, X1	// 410c0c74
	XVSUBH		X3, X2, X1	// 418c0c74
	XVSUBW		X3, X2, X1	// 410c0d74
	XVSUBV		X3, X2, X1	// 418c0d74
	XVSUBQ		X3, X2, X1	// 418c2d75

	// [X]VADD{B,H,W,V}U, [X]VSUB{B,H,W,V}U instructions
	VADDBU		$1, V2, V1	// 41048a72
	VADDHU		$2, V2, V1	// 41888a72
	VADDWU		$3, V2, V1	// 410c8b72
	VADDVU		$4, V2, V1	// 41908b72
	VSUBBU		$5, V2, V1	// 41148c72
	VSUBHU		$6, V2, V1	// 41988c72
	VSUBWU		$7, V2, V1	// 411c8d72
	VSUBVU		$8, V2, V1	// 41a08d72
	XVADDBU		$9, X1, X2	// 22248a76
	XVADDHU		$10, X1, X2	// 22a88a76
	XVADDWU		$11, X1, X2	// 222c8b76
	XVADDVU		$12, X1, X2	// 22b08b76
	XVSUBBU		$13, X1, X2	// 22348c76
	XVSUBHU		$14, X1, X2	// 22b88c76
	XVSUBWU		$15, X1, X2	// 223c8d76
	XVSUBVU		$16, X1, X2	// 22c08d76

	// [X]VILV{L/H}{B,H,W,V} instructions
	VILVLB		V1, V2, V3	// 43041a71
	VILVLH		V1, V2, V3	// 43841a71
	VILVLW		V1, V2, V3	// 43041b71
	VILVLV		V1, V2, V3	// 43841b71
	VILVHB		V1, V2, V3	// 43041c71
	VILVHH		V1, V2, V3	// 43841c71
	VILVHW		V1, V2, V3	// 43041d71
	VILVHV		V1, V2, V3	// 43841d71
	XVILVLB		X3, X2, X1	// 410c1a75
	XVILVLH		X3, X2, X1	// 418c1a75
	XVILVLW		X3, X2, X1	// 410c1b75
	XVILVLV		X3, X2, X1	// 418c1b75
	XVILVHB		X3, X2, X1	// 410c1c75
	XVILVHH		X3, X2, X1	// 418c1c75
	XVILVHW		X3, X2, X1	// 410c1d75
	XVILVHV		X3, X2, X1	// 418c1d75

	// [X]VMUL{B/H/W/V} and [X]VMUH{B/H/W/V}[U] instructions
	VMULB		V1, V2, V3	// 43048470
	VMULH		V1, V2, V3	// 43848470
	VMULW		V1, V2, V3	// 43048570
	VMULV		V1, V2, V3	// 43848570
	VMUHB		V1, V2, V3	// 43048670
	VMUHH		V1, V2, V3	// 43848670
	VMUHW		V1, V2, V3	// 43048770
	VMUHV		V1, V2, V3	// 43848770
	VMUHBU		V1, V2, V3	// 43048870
	VMUHHU		V1, V2, V3	// 43848870
	VMUHWU		V1, V2, V3	// 43048970
	VMUHVU		V1, V2, V3	// 43848970
	XVMULB		X3, X2, X1	// 410c8474
	XVMULH		X3, X2, X1	// 418c8474
	XVMULW		X3, X2, X1	// 410c8574
	XVMULV		X3, X2, X1	// 418c8574
	XVMUHB		X3, X2, X1	// 410c8674
	XVMUHH		X3, X2, X1	// 418c8674
	XVMUHW		X3, X2, X1	// 410c8774
	XVMUHV		X3, X2, X1	// 418c8774
	XVMUHBU		X3, X2, X1	// 410c8874
	XVMUHHU		X3, X2, X1	// 418c8874
	XVMUHWU		X3, X2, X1	// 410c8974
	XVMUHVU		X3, X2, X1	// 418c8974

	// [X]VDIV{B/H/W/V}[U] and [X]VMOD{B/H/W/V}[U] instructions
	VDIVB		V1, V2, V3	// 4304e070
	VDIVH		V1, V2, V3	// 4384e070
	VDIVW		V1, V2, V3	// 4304e170
	VDIVV		V1, V2, V3	// 4384e170
	VDIVBU		V1, V2, V3	// 4304e470
	VDIVHU		V1, V2, V3	// 4384e470
	VDIVWU		V1, V2, V3	// 4304e570
	VDIVVU		V1, V2, V3	// 4384e570
	VMODB		V1, V2, V3	// 4304e270
	VMODH		V1, V2, V3	// 4384e270
	VMODW		V1, V2, V3	// 4304e370
	VMODV		V1, V2, V3	// 4384e370
	VMODBU		V1, V2, V3	// 4304e670
	VMODHU		V1, V2, V3	// 4384e670
	VMODWU		V1, V2, V3	// 4304e770
	VMODVU		V1, V2, V3	// 4384e770
	XVDIVB		X3, X2, X1	// 410ce074
	XVDIVH		X3, X2, X1	// 418ce074
	XVDIVW		X3, X2, X1	// 410ce174
	XVDIVV		X3, X2, X1	// 418ce174
	XVDIVBU		X3, X2, X1	// 410ce474
	XVDIVHU		X3, X2, X1	// 418ce474
	XVDIVWU		X3, X2, X1	// 410ce574
	XVDIVVU		X3, X2, X1	// 418ce574
	XVMODB		X3, X2, X1	// 410ce274
	XVMODH		X3, X2, X1	// 418ce274
	XVMODW		X3, X2, X1	// 410ce374
	XVMODV		X3, X2, X1	// 418ce374
	XVMODBU		X3, X2, X1	// 410ce674
	XVMODHU		X3, X2, X1	// 418ce674
	XVMODWU		X3, X2, X1	// 410ce774
	XVMODVU		X3, X2, X1	// 418ce774

	// [X]VF{SQRT/RECIP/RSQRT}{F/D} instructions
	VFSQRTF		V1, V2		// 22e49c72
	VFSQRTD		V1, V2		// 22e89c72
	VFRECIPF	V1, V2		// 22f49c72
	VFRECIPD	V1, V2		// 22f89c72
	VFRSQRTF	V1, V2		// 22049d72
	VFRSQRTD	V1, V2		// 22089d72
	XVFSQRTF	X2, X1		// 41e49c76
	XVFSQRTD	X2, X1		// 41e89c76
	XVFRECIPF	X2, X1		// 41f49c76
	XVFRECIPD	X2, X1		// 41f89c76
	XVFRSQRTF	X2, X1		// 41049d76
	XVFRSQRTD	X2, X1		// 41089d76

	// [X]VNEG{B/H/W/V} instructions
	VNEGB		V1, V2		// 22309c72
	VNEGH		V1, V2		// 22349c72
	VNEGW		V1, V2		// 22389c72
	VNEGV		V1, V2		// 223c9c72
	XVNEGB		X2, X1		// 41309c76
	XVNEGH		X2, X1		// 41349c76
	XVNEGW		X2, X1		// 41389c76
	XVNEGV		X2, X1		// 413c9c76

	// [X]{VMULW}{EV/OD}.{H.B/W.H/D.W/Q.D}[U] instructions
	VMULWEVHB	V1, V2, V3	// 43049070
	VMULWEVWH	V1, V2, V3	// 43849070
	VMULWEVVW	V1, V2, V3	// 43049170
	VMULWEVQV	V1, V2, V3	// 43849170
	VMULWODHB	V1, V2, V3	// 43049270
	VMULWODWH	V1, V2, V3	// 43849270
	VMULWODVW	V1, V2, V3	// 43049370
	VMULWODQV	V1, V2, V3	// 43849370
	VMULWEVHBU	V1, V2, V3	// 43049870
	VMULWEVWHU	V1, V2, V3	// 43849870
	VMULWEVVWU	V1, V2, V3	// 43049970
	VMULWEVQVU	V1, V2, V3	// 43849970
	VMULWODHBU	V1, V2, V3	// 43049a70
	VMULWODWHU	V1, V2, V3	// 43849a70
	VMULWODVWU	V1, V2, V3	// 43049b70
	VMULWODQVU	V1, V2, V3	// 43849b70
	XVMULWEVHB	X1, X2, X3	// 43049074
	XVMULWEVWH	X1, X2, X3	// 43849074
	XVMULWEVVW	X1, X2, X3	// 43049174
	XVMULWEVQV	X1, X2, X3	// 43849174
	XVMULWODHB	X1, X2, X3	// 43049274
	XVMULWODWH	X1, X2, X3	// 43849274
	XVMULWODVW	X1, X2, X3	// 43049374
	XVMULWODQV	X1, X2, X3	// 43849374
	XVMULWEVHBU	X1, X2, X3	// 43049874
	XVMULWEVWHU	X1, X2, X3	// 43849874
	XVMULWEVVWU	X1, X2, X3	// 43049974
	XVMULWEVQVU	X1, X2, X3	// 43849974
	XVMULWODHBU	X1, X2, X3	// 43049a74
	XVMULWODWHU	X1, X2, X3	// 43849a74
	XVMULWODVWU	X1, X2, X3	// 43049b74
	XVMULWODQVU	X1, X2, X3	// 43849b74

	// [X]{VMULW}{EV/OD}.{H.BU.B/W.HU.H/D.WU.W/Q.DU.D} instructions
	VMULWEVHBUB	V1, V2, V3	// 4304a070
	VMULWEVWHUH	V1, V2, V3	// 4384a070
	VMULWEVVWUW	V1, V2, V3	// 4304a170
	VMULWEVQVUV	V1, V2, V3	// 4384a170
	VMULWODHBUB	V1, V2, V3	// 4304a270
	VMULWODWHUH	V1, V2, V3	// 4384a270
	VMULWODVWUW	V1, V2, V3	// 4304a370
	VMULWODQVUV	V1, V2, V3	// 4384a370
	XVMULWEVHBUB	X1, X2, X3	// 4304a074
	XVMULWEVWHUH	X1, X2, X3	// 4384a074
	XVMULWEVVWUW	X1, X2, X3	// 4304a174
	XVMULWEVQVUV	X1, X2, X3	// 4384a174
	XVMULWODHBUB	X1, X2, X3	// 4304a274
	XVMULWODWHUH	X1, X2, X3	// 4384a274
	XVMULWODVWUW	X1, X2, X3	// 4304a374
	XVMULWODQVUV	X1, X2, X3	// 4384a374

	// [X]VSHUF4I.{B/H/W/D} instructions
	VSHUF4IB	$0, V2, V1	// 41009073
	VSHUF4IB	$16, V2, V1	// 41409073
	VSHUF4IB	$255, V2, V1	// 41fc9373
	VSHUF4IH	$0, V2, V1	// 41009473
	VSHUF4IH	$128, V2, V1	// 41009673
	VSHUF4IH	$255, V2, V1	// 41fc9773
	VSHUF4IW	$0, V2, V1	// 41009873
	VSHUF4IW	$96, V2, V1	// 41809973
	VSHUF4IW	$255, V2, V1	// 41fc9b73
	VSHUF4IV	$0, V2, V1	// 41009c73
	VSHUF4IV	$8, V2, V1	// 41209c73
	VSHUF4IV	$15, V2, V1	// 413c9c73
	XVSHUF4IB	$0, X1, X2	// 22009077
	XVSHUF4IB	$16, X1, X2	// 22409077
	XVSHUF4IB	$255, X1, X2	// 22fc9377
	XVSHUF4IH	$0, X1, X2	// 22009477
	XVSHUF4IH	$128, X1, X2	// 22009677
	XVSHUF4IH	$255, X1, X2	// 22fc9777
	XVSHUF4IW	$0, X1, X2	// 22009877
	XVSHUF4IW	$96, X1, X2	// 22809977
	XVSHUF4IW	$255, X1, X2	// 22fc9b77
	XVSHUF4IV	$0, X1, X2	// 22009c77
	XVSHUF4IV	$8, X1, X2	// 22209c77
	XVSHUF4IV	$15, X1, X2	// 223c9c77

	// [X]VSETEQZ.V, [X]VSETNEZ.V
	VSETEQV		V1, FCC0	// 20989c72
	VSETNEV		V1, FCC0	// 209c9c72
	XVSETEQV	X1, FCC0	// 20989c76
	XVSETNEV	X1, FCC0	// 209c9c76
	// [X]VSETANYEQZ.{B/H/W/D} instructions
	VSETANYEQB	V1, FCC0	// 20a09c72
	VSETANYEQH	V1, FCC0	// 20a49c72
	VSETANYEQW	V1, FCC0	// 20a89c72
	VSETANYEQV	V1, FCC0	// 20ac9c72
	VSETALLNEB	V1, FCC0	// 20b09c72
	VSETALLNEH	V1, FCC0	// 20b49c72
	VSETALLNEW	V1, FCC0	// 20b89c72
	VSETALLNEV	V1, FCC0	// 20bc9c72
	XVSETANYEQB	X1, FCC0	// 20a09c76
	XVSETANYEQH	X1, FCC0	// 20a49c76
	XVSETANYEQW	X1, FCC0	// 20a89c76
	XVSETANYEQV	X1, FCC0	// 20ac9c76
	XVSETALLNEB	X1, FCC0	// 20b09c76
	XVSETALLNEH	X1, FCC0	// 20b49c76
	XVSETALLNEW	X1, FCC0	// 20b89c76
	XVSETALLNEV	X1, FCC0	// 20bc9c76

	// [X]VFRINT[{RNE/RZ/RP/RM}].{S/D} instructions
	VFRINTRNEF	V1, V2		// 22749d72
	VFRINTRNED	V1, V2		// 22789d72
	VFRINTRZF	V1, V2		// 22649d72
	VFRINTRZD	V1, V2		// 22689d72
	VFRINTRPF	V1, V2		// 22549d72
	VFRINTRPD	V1, V2		// 22589d72
	VFRINTRMF	V1, V2		// 22449d72
	VFRINTRMD	V1, V2		// 22489d72
	VFRINTF		V1, V2		// 22349d72
	VFRINTD		V1, V2		// 22389d72
	XVFRINTRNEF	X1, X2		// 22749d76
	XVFRINTRNED	X1, X2		// 22789d76
	XVFRINTRZF	X1, X2		// 22649d76
	XVFRINTRZD	X1, X2		// 22689d76
	XVFRINTRPF	X1, X2		// 22549d76
	XVFRINTRPD	X1, X2		// 22589d76
	XVFRINTRMF	X1, X2		// 22449d76
	XVFRINTRMD	X1, X2		// 22489d76
	XVFRINTF	X1, X2		// 22349d76
	XVFRINTD	X1, X2		// 22389d76

	// [X]VF{ADD/SUB/MUL/DIV}.{S/D} instructions
	VADDF		V1, V2, V3	// 43843071
	VADDD		V1, V2, V3	// 43043171
	VSUBF		V1, V2, V3	// 43843271
	VSUBD		V1, V2, V3	// 43043371
	VMULF		V1, V2, V3	// 43843871
	VMULD		V1, V2, V3	// 43043971
	VDIVF		V1, V2, V3	// 43843a71
	VDIVD		V1, V2, V3	// 43043b71
	XVADDF		X1, X2, X3	// 43843075
	XVADDD		X1, X2, X3	// 43043175
	XVSUBF		X1, X2, X3	// 43843275
	XVSUBD		X1, X2, X3	// 43043375
	XVMULF		X1, X2, X3	// 43843875
	XVMULD		X1, X2, X3	// 43043975
	XVDIVF		X1, X2, X3	// 43843a75
	XVDIVD		X1, X2, X3	// 43043b75

	// [X]VFCLASS.{S/D} instructions
	VFCLASSF	V1, V2		// 22d49c72
	VFCLASSD	V1, V2		// 22d89c72
	XVFCLASSF	X1, X2		// 22d49c76
	XVFCLASSD	X1, X2		// 22d89c76

	// PRELD{,X} instructions
	PRELD	(R4), $0		// 8000c02a
	PRELD	-1(R4), $8		// 88fcff2a
	PRELD	8(R4),  $31		// 9f20c02a
