/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.tools.I18n;

public class WayConnectedToArea
extends Test {
    public WayConnectedToArea() {
        super(I18n.tr("Way connected to Area", new Object[0]), I18n.tr("Checks for ways connected to areas.", new Object[0]));
    }

    @Override
    public void visit(Way w) {
        if (!w.isUsable() || w.isClosed() || !w.hasKey("highway")) {
            return;
        }
        List<OsmPrimitive> r = w.firstNode().getReferrers();
        boolean hasway = r.stream().anyMatch(p -> p != w && p.hasKey("highway"));
        if (!hasway) {
            for (OsmPrimitive p2 : r) {
                this.testForError(w, w.firstNode(), p2);
            }
        }
        if (!(hasway = (r = w.lastNode().getReferrers()).stream().anyMatch(p -> p != w && p.hasKey("highway")))) {
            for (OsmPrimitive p2 : r) {
                this.testForError(w, w.lastNode(), p2);
            }
        }
    }

    private void testForError(Way w, Node wayNode, OsmPrimitive p) {
        if (!wayNode.isOutsideDownloadArea() && wayNode.getReferrers().stream().noneMatch(p1 -> p1.hasTag("route", "ferry"))) {
            if (WayConnectedToArea.isArea(p)) {
                this.addPossibleError(w, wayNode, p, p);
            } else {
                p.referrers(Relation.class).filter(r -> r.isMultipolygon() && WayConnectedToArea.isArea(r)).findFirst().ifPresent(r -> this.addPossibleError(w, wayNode, p, (OsmPrimitive)r));
            }
        }
    }

    private static boolean isArea(OsmPrimitive p) {
        return p.hasKey("landuse", "natural") && ElemStyles.hasAreaElemStyle(p, false);
    }

    private void addPossibleError(Way w, Node wayNode, OsmPrimitive p, OsmPrimitive area) {
        if (w.hasKey("highway") && wayNode.hasTag("leisure", "slipway") && area.hasTag("natural", "water")) {
            return;
        }
        if (wayNode.hasTag("noexit", "yes")) {
            return;
        }
        this.errors.add(TestError.builder(this, Severity.WARNING, 2301).message(I18n.tr("Way terminates on Area", new Object[0])).primitives(w, p).highlight(wayNode).build());
    }
}

