/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.merge;

import java.util.HashMap;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.fonts.cache.FirstLevelFontCache;
import org.pentaho.reporting.libraries.fonts.merge.CompoundFontIdentifier;
import org.pentaho.reporting.libraries.fonts.merge.CompoundFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontKey;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class CompoundFontStorage
implements FontStorage {
    private CompoundFontRegistry fontRegistry = new CompoundFontRegistry();
    private HashMap metricsFactories = new HashMap();
    private FirstLevelFontCache firstLevelFontCache = new FirstLevelFontCache(this.fontRegistry.getSecondLevelCache());
    private FontKey lookupKey = new FontKey();
    private int hits;
    private int misses;

    public void addRegistry(FontRegistry registry) {
        this.fontRegistry.addRegistry(registry);
    }

    @Override
    public FontRegistry getFontRegistry() {
        return this.fontRegistry;
    }

    @Override
    public FontMetrics getFontMetrics(FontIdentifier record, FontContext context) {
        if (record == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        this.lookupKey.setAliased(context.isAntiAliased());
        this.lookupKey.setFontSize(context.getFontSize());
        this.lookupKey.setIdentifier(record);
        this.lookupKey.setFractional(context.isFractionalMetrics());
        FontMetrics cachedMetrics = this.firstLevelFontCache.getFontMetrics(this.lookupKey);
        if (cachedMetrics != null) {
            ++this.hits;
            return cachedMetrics;
        }
        CompoundFontIdentifier cid = (CompoundFontIdentifier)record;
        FontRegistry registry = cid.getRegistry();
        FontMetricsFactory metricsFactory = (FontMetricsFactory)this.metricsFactories.get(registry);
        if (metricsFactory == null) {
            metricsFactory = registry.createMetricsFactory();
            this.metricsFactories.put(registry, metricsFactory);
        }
        ++this.misses;
        FontKey key = new FontKey(record, context.isAntiAliased(), context.isFractionalMetrics(), context.getFontSize());
        FontMetrics metrics = metricsFactory.createMetrics(cid.getIdentifier(), context);
        this.firstLevelFontCache.putFontMetrics(key, metrics);
        return metrics;
    }

    @Override
    public void commit() {
        DebugLog.log((Object)("Font-Storage: hits=" + this.hits + ", misses=" + this.misses));
        this.firstLevelFontCache.commit();
    }
}

