/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.task;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.OpCode;

public class ErrorPageModelChange
extends Change {
    private ErrorPageModel errorPageModel;
    private final List<ErrorPageModel> errorPageModels = new LinkedList<ErrorPageModel>();
    private boolean disabled;
    private final List<OsgiContextModel> newModels = new LinkedList<OsgiContextModel>();

    public ErrorPageModelChange(OpCode kind, ErrorPageModel model, OsgiContextModel ... newModels) {
        super(kind);
        this.errorPageModel = model;
        this.errorPageModels.add(model);
        this.newModels.addAll(Arrays.asList(newModels));
    }

    public ErrorPageModelChange(OpCode op, List<ErrorPageModel> errorPageModels) {
        super(op);
        this.errorPageModels.addAll(errorPageModels);
    }

    public ErrorPageModelChange(OpCode op, ErrorPageModel filterModel, boolean disabled, OsgiContextModel ... newModels) {
        super(op);
        this.errorPageModel = filterModel;
        this.errorPageModels.add(filterModel);
        this.disabled = disabled;
        this.newModels.addAll(Arrays.asList(newModels));
    }

    public List<OsgiContextModel> getNewModels() {
        return this.newModels;
    }

    @Override
    public void uninstall(List<Change> operations) {
        if (this.getKind() == OpCode.ADD) {
            operations.add(new ErrorPageModelChange(OpCode.DELETE, this.errorPageModels));
        }
    }

    @Override
    public void accept(BatchVisitor visitor) {
        visitor.visitErrorPageModelChange(this);
    }

    @Override
    public List<OsgiContextModel> getContextModels() {
        return this.newModels.size() > 0 ? this.newModels : this.errorPageModel.getContextModels();
    }

    public ErrorPageModel getErrorPageModel() {
        return this.errorPageModel;
    }

    public List<ErrorPageModel> getErrorPageModels() {
        return this.errorPageModels;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

