/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.ZoomToFitAction;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.CommonCloseAction;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.JDefaultButton;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class SearchReplace {
    private static final Logger logger = Logger.getLogger(SearchReplace.class);
    private JRadioButton substringMatch;
    private JRadioButton exactMatch;
    private JRadioButton regexMatch;
    private JRadioButton tableSearch;
    private JRadioButton relationshipSearch;
    private JRadioButton columnSearch;
    private JRadioButton allSearch;
    private JRadioButton logicalAspect;
    private JRadioButton physicalAspect;
    private JTextField searchExpression;
    private JCheckBox caseInsensitive;

    public void showSearchDialog(final PlayPen pp) {
        final JDialog d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(JFrame.class, pp), Messages.getString("SearchReplace.dialogTitle"));
        ButtonGroup matchType = new ButtonGroup();
        this.substringMatch = new JRadioButton(Messages.getString("SearchReplace.substringCompareByOption"));
        matchType.add(this.substringMatch);
        this.exactMatch = new JRadioButton(Messages.getString("SearchReplace.exactMatchCompareByOption"));
        matchType.add(this.exactMatch);
        this.regexMatch = new JRadioButton(Messages.getString("SearchReplace.regexCompareByOption"));
        matchType.add(this.regexMatch);
        JPanel matchTypePanel = new JPanel(new GridLayout(1, 3));
        matchTypePanel.add(this.substringMatch);
        matchTypePanel.add(this.exactMatch);
        matchTypePanel.add(this.regexMatch);
        this.substringMatch.setSelected(true);
        ButtonGroup searchAspect = new ButtonGroup();
        this.logicalAspect = new JRadioButton("Logical Name");
        searchAspect.add(this.logicalAspect);
        this.physicalAspect = new JRadioButton("Physical Name");
        searchAspect.add(this.physicalAspect);
        JPanel searchAspectPanel = new JPanel(new GridLayout(1, 3));
        searchAspectPanel.add(this.logicalAspect);
        searchAspectPanel.add(this.physicalAspect);
        searchAspectPanel.add(new JLabel());
        this.logicalAspect.setSelected(true);
        ButtonGroup searchType = new ButtonGroup();
        this.tableSearch = new JRadioButton(Messages.getString("SearchReplace.tablesSearchOption"));
        searchType.add(this.tableSearch);
        this.relationshipSearch = new JRadioButton(Messages.getString("SearchReplace.relationshipsSearchOption"));
        searchType.add(this.relationshipSearch);
        this.columnSearch = new JRadioButton(Messages.getString("SearchReplace.columnsSearchOption"));
        searchType.add(this.columnSearch);
        this.allSearch = new JRadioButton(Messages.getString("SearchReplace.anythingSearchOption"));
        searchType.add(this.allSearch);
        JPanel searchTypePanel = new JPanel(new GridLayout(4, 1));
        searchTypePanel.add(this.tableSearch);
        searchTypePanel.add(this.relationshipSearch);
        searchTypePanel.add(this.columnSearch);
        searchTypePanel.add(this.allSearch);
        this.allSearch.setSelected(true);
        this.caseInsensitive = new JCheckBox(Messages.getString("SearchReplace.ignoreCaseOption"));
        this.caseInsensitive.setSelected(true);
        this.searchExpression = new JTextField();
        JDefaultButton searchButton = new JDefaultButton(Messages.getString("SearchReplace.searchButton"));
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SearchReplace.this.showResults(d, pp);
                }
                catch (SQLObjectException ex) {
                    ASUtils.showExceptionDialogNoReport(d, Messages.getString("SearchReplace.problemDuringSearch"), ex);
                }
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.setVisible(false);
                d.dispose();
            }
        };
        cancelAction.putValue("Name", DataEntryPanelBuilder.CANCEL_BUTTON_LABEL);
        JButton cancelButton = new JButton(cancelAction);
        SPSUtils.makeJDialogCancellable((Window)d, (Action)cancelAction);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add((Component)searchButton);
        buttonPanel.add(cancelButton);
        JComponent cp = (JComponent)d.getContentPane();
        cp.setLayout(new FormLayout(10, 10));
        cp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        cp.add(new JLabel(Messages.getString("SearchReplace.lookForLabel")));
        cp.add(searchTypePanel);
        cp.add(new JLabel(Messages.getString("SearchReplace.byLabel")));
        cp.add(searchAspectPanel);
        cp.add(new JLabel(Messages.getString("SearchReplace.namedLabel")));
        cp.add(this.searchExpression);
        cp.add(new JLabel(Messages.getString("SearchReplace.comparingByLabel")));
        cp.add(matchTypePanel);
        cp.add(new JLabel(""));
        cp.add(this.caseInsensitive);
        cp.add(new JLabel(""));
        cp.add(buttonPanel);
        d.getRootPane().setDefaultButton((JButton)searchButton);
        d.pack();
        d.setLocationRelativeTo(pp);
        d.setVisible(true);
        this.searchExpression.requestFocus();
    }

    public void showResults(final JDialog parent, final PlayPen pp) throws SQLObjectException {
        try {
            SearchAspect aspect;
            if (this.logicalAspect.isSelected()) {
                aspect = SearchAspect.LOGICAL_NAME;
            } else if (this.physicalAspect.isSelected()) {
                aspect = SearchAspect.PHYSICAL_NAME;
            } else {
                throw new IllegalStateException("Don't know which search aspect to choose");
            }
            final List<SQLObject> results = this.doSearch((SQLObject)pp.getSession().getTargetDatabase(), aspect);
            results.remove(pp.getSession().getTargetDatabase());
            final JDialog d = new JDialog((Dialog)parent, Messages.getString("SearchReplace.resultsDialogTitle"));
            final JTable t = new JTable(new SearchResultsTableModel(aspect, results));
            final JButton renameButton = new JButton(Messages.getString("SearchReplace.renameSelectedButton"));
            renameButton.setEnabled(false);
            renameButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newName = JOptionPane.showInputDialog(d, (Object)Messages.getString("SearchReplace.renameInstructions"));
                    TableModel m = t.getModel();
                    int[] selectedRows = t.getSelectedRows();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        if (newName == null) continue;
                        m.setValueAt(newName, selectedRows[i], 1);
                    }
                }
            });
            final JButton gotoButton = new JButton(Messages.getString("SearchReplace.showInPlaypenButton"));
            gotoButton.setEnabled(false);
            gotoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] rows = t.getSelectedRows();
                    if (rows.length == 0) {
                        return;
                    }
                    pp.selectNone();
                    for (int row : rows) {
                        Relationship r;
                        SQLObject searchObj = (SQLObject)results.get(row);
                        SQLTable searchTable = null;
                        SQLColumn searchColumn = null;
                        SQLRelationship searchRelationship = null;
                        if (searchObj instanceof SQLColumn) {
                            searchColumn = (SQLColumn)searchObj;
                            searchTable = searchColumn.getParent();
                        } else if (searchObj instanceof SQLTable) {
                            searchTable = (SQLTable)searchObj;
                        } else if (searchObj instanceof SQLRelationship) {
                            searchRelationship = (SQLRelationship)searchObj;
                        } else {
                            JOptionPane.showMessageDialog(null, Messages.getString("SearchReplace.unknownSearchResultType"));
                            return;
                        }
                        if (searchTable != null) {
                            TablePane tp = pp.findTablePane(searchTable);
                            if (tp == null) continue;
                            tp.setSelected(true, 4);
                            ZoomToFitAction.zoomToFitSelected(pp);
                            if (searchColumn == null) continue;
                            try {
                                tp.selectItem(searchTable.getColumnIndex(searchColumn));
                            }
                            catch (SQLObjectException ex) {
                                logger.error((Object)"Failed to select column becuase getColumnIndex threw the following exception:", (Throwable)ex);
                                ASUtils.showExceptionDialogNoReport(parent, Messages.getString("SearchReplace.couldNotSelectColumn"), ex);
                            }
                            continue;
                        }
                        if (searchRelationship == null || (r = pp.findRelationship(searchRelationship)) == null) continue;
                        r.setSelected(true, 4);
                    }
                    ZoomToFitAction.zoomToFitSelected(pp);
                }
            });
            CommonCloseAction closeAction = new CommonCloseAction(d);
            JButton closeButton = new JButton((Action)closeAction);
            SPSUtils.makeJDialogCancellable((Window)d, (Action)closeAction);
            ListSelectionListener buttonActivator = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    renameButton.setEnabled(t.getSelectedRowCount() > 0);
                    gotoButton.setEnabled(t.getSelectedRowCount() > 0);
                }
            };
            t.getSelectionModel().addListSelectionListener(buttonActivator);
            JComponent cp = (JComponent)d.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)new JScrollPane(t), "Center");
            Box buttonBox = new Box(1);
            buttonBox.add(renameButton);
            buttonBox.add(gotoButton);
            buttonBox.add(Box.createVerticalGlue());
            buttonBox.add(closeButton);
            cp.add((Component)buttonBox, "East");
            d.pack();
            d.setLocationRelativeTo(parent);
            d.setVisible(true);
        }
        catch (PatternSyntaxException e) {
            ASUtils.showExceptionDialogNoReport(parent, Messages.getString("SearchReplace.regularExpressionError"), e);
        }
    }

    public List<SQLObject> doSearch(SQLObject start, SearchAspect aspect) throws SQLObjectException {
        String pat;
        ArrayList<SQLObject> results = new ArrayList<SQLObject>();
        if (this.substringMatch.isSelected() || this.exactMatch.isSelected()) {
            String p = this.searchExpression.getText();
            StringBuffer escapedPat = new StringBuffer();
            for (int i = 0; i < p.length(); ++i) {
                if (!Character.isLetterOrDigit(p.charAt(i)) && !Character.isSpaceChar(p.charAt(i))) {
                    escapedPat.append("\\");
                }
                escapedPat.append(p.charAt(i));
            }
            pat = this.exactMatch.isSelected() ? "^" + escapedPat + "$" : ".*" + escapedPat + ".*";
        } else if (this.regexMatch.isSelected()) {
            pat = this.searchExpression.getText();
        } else {
            throw new IllegalStateException(Messages.getString("SearchReplace.unknownSearchMode"));
        }
        int patternFlags = 0;
        if (this.caseInsensitive.isSelected()) {
            patternFlags |= 0x42;
        }
        Pattern searchPattern = Pattern.compile(pat, patternFlags);
        this.recursiveSearch(start, searchPattern, aspect, results);
        return results;
    }

    private void recursiveSearch(SQLObject obj, Pattern searchPattern, SearchAspect aspect, List<? super SQLObject> appendTo) throws SQLObjectException {
        List children;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Matching \"" + obj.getName() + "\" against /" + searchPattern.pattern() + "/"));
        }
        if (searchPattern.matcher(aspect.getSearchableText(obj)).matches() && this.searchTypeMatches(obj)) {
            appendTo.add((SQLObject)obj);
        }
        if ((children = obj.getChildren()) != null) {
            for (SQLObject so : children) {
                this.recursiveSearch(so, searchPattern, aspect, appendTo);
            }
        }
    }

    private boolean searchTypeMatches(SQLObject obj) {
        if (this.allSearch.isSelected()) {
            return true;
        }
        if (this.tableSearch.isSelected() && obj instanceof SQLTable) {
            return true;
        }
        if (this.columnSearch.isSelected() && obj instanceof SQLColumn) {
            return true;
        }
        return this.relationshipSearch.isSelected() && obj instanceof SQLRelationship;
    }

    public String getSearchExpressionText() {
        return this.searchExpression.getText();
    }

    public void setSearchExpression(String searchExpressionText) {
        this.searchExpression.setText(searchExpressionText);
    }

    private static enum SearchAspect {
        LOGICAL_NAME{

            @Override
            String getSearchableText(SQLObject obj) {
                return obj.getName();
            }

            @Override
            public void setText(SQLObject obj, String text) {
                obj.setName(text);
            }

            @Override
            public String getColumnHeading() {
                return "Logical Name";
            }

            @Override
            public boolean isEditable() {
                return true;
            }
        }
        ,
        PHYSICAL_NAME{

            @Override
            String getSearchableText(SQLObject obj) {
                return obj.getPhysicalName();
            }

            @Override
            public void setText(SQLObject obj, String text) {
                obj.setPhysicalName(text);
            }

            @Override
            public String getColumnHeading() {
                return "Physical Name";
            }

            @Override
            public boolean isEditable() {
                return true;
            }
        };


        abstract String getSearchableText(SQLObject var1);

        abstract String getColumnHeading();

        abstract boolean isEditable();

        abstract void setText(SQLObject var1, String var2);
    }

    private class SearchResultsTableModel
    implements TableModel {
        private List<? extends SQLObject> results;
        private final SearchAspect aspect;
        private ArrayList<TableModelListener> listeners = new ArrayList();

        public SearchResultsTableModel(SearchAspect aspect, List<? extends SQLObject> results) {
            this.aspect = aspect;
            this.results = results;
        }

        @Override
        public int getRowCount() {
            return this.results.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return Messages.getString("SearchReplace.typeResultColumnHeader");
            }
            if (columnIndex == 1) {
                return this.aspect.getColumnHeading();
            }
            return Messages.getString("SearchReplace.invalidResultColumnIndex") + columnIndex;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            SQLObject obj = this.results.get(rowIndex);
            return columnIndex == 1 && this.aspect.isEditable() && (obj instanceof SQLTable || obj instanceof SQLColumn || obj instanceof SQLRelationship);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SQLObject obj = this.results.get(rowIndex);
            if (columnIndex == 0) {
                if (obj instanceof SQLColumn) {
                    return Messages.getString("SearchReplace.columnOfTable", ((SQLColumn)obj).getParent().getName());
                }
                String className = obj.getClass().getName();
                return className.substring(className.lastIndexOf(46) + 4);
            }
            if (columnIndex == 1) {
                return this.aspect.getSearchableText(obj);
            }
            return Messages.getString("SearchReplace.invalidColumnIndex", String.valueOf(columnIndex));
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            SQLObject obj = this.results.get(rowIndex);
            if (columnIndex == 1) {
                this.aspect.setText(obj, (String)aValue);
                this.fireEvent(new TableModelEvent(this, rowIndex, rowIndex, columnIndex, 0));
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        private void fireEvent(TableModelEvent evt) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).tableChanged(evt);
            }
        }
    }
}

