/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferenceListener;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferencesPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class ProxyPreference
extends DefaultTabPreferenceSetting {
    private static final Set<ProxyPreferenceListener> listeners = new HashSet<ProxyPreferenceListener>();
    private ProxyPreferencesPanel pnlProxyPreferences;

    private ProxyPreference() {
        super("proxy", I18n.tr("Proxy", new Object[0]), I18n.tr("Configure whether to use a proxy server", new Object[0]));
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        this.pnlProxyPreferences = new ProxyPreferencesPanel();
        this.pnlProxyPreferences.add(Box.createVerticalGlue(), GBC.eol().fill());
        gui.createPreferenceTab(this).add((Component)this.pnlProxyPreferences, GBC.eol().fill());
    }

    @Override
    public boolean ok() {
        this.pnlProxyPreferences.saveToPreferences();
        for (ProxyPreferenceListener listener : listeners) {
            listener.proxyPreferenceChanged();
        }
        return false;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    public static boolean addProxyPreferenceListener(ProxyPreferenceListener listener) {
        if (listener != null) {
            return listeners.add(listener);
        }
        return false;
    }

    public static boolean removeProxyPreferenceListener(ProxyPreferenceListener listener) {
        if (listener != null) {
            return listeners.remove(listener);
        }
        return false;
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/ProxyPreference");
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ProxyPreference();
        }
    }
}

