/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.template.RuleTemplateProvider;
import org.openhab.core.automation.template.TemplateProvider;
import org.openhab.core.automation.template.TemplateRegistry;
import org.openhab.core.common.registry.AbstractRegistry;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(service={TemplateRegistry.class, RuleTemplateRegistry.class}, immediate=true)
public class RuleTemplateRegistry
extends AbstractRegistry<RuleTemplate, String, RuleTemplateProvider>
implements TemplateRegistry<RuleTemplate> {
    public RuleTemplateRegistry() {
        super(RuleTemplateProvider.class);
    }

    protected void addProvider(Provider<RuleTemplate> provider) {
        if (provider instanceof TemplateProvider) {
            super.addProvider(provider);
        }
    }

    public @Nullable RuleTemplate get(String templateUID) {
        return this.get(templateUID, null);
    }

    @Override
    public @Nullable RuleTemplate get(String templateUID, @Nullable Locale locale) {
        Map.Entry prt = this.getValueAndProvider(templateUID);
        if (prt == null) {
            return null;
        }
        RuleTemplate t = locale == null ? (RuleTemplate)prt.getValue() : (RuleTemplate)((RuleTemplateProvider)prt.getKey()).getTemplate(templateUID, locale);
        return t != null ? this.createCopy(t) : null;
    }

    private RuleTemplate createCopy(RuleTemplate template) {
        return new RuleTemplate(template.getUID(), template.getLabel(), template.getDescription(), new HashSet<String>(template.getTags()), new ArrayList<Trigger>(template.getTriggers()), new ArrayList<Condition>(template.getConditions()), new ArrayList<Action>(template.getActions()), new LinkedList<ConfigDescriptionParameter>(template.getConfigurationDescriptions()), template.getVisibility());
    }

    @Override
    public Collection<RuleTemplate> getByTag(@Nullable String tag) {
        return this.getByTag(tag, null);
    }

    @Override
    public Collection<RuleTemplate> getByTag(@Nullable String tag, @Nullable Locale locale) {
        ArrayList<RuleTemplate> result = new ArrayList<RuleTemplate>();
        this.forEach((provider, resultTemplate) -> {
            RuleTemplate t;
            Set<String> tags = resultTemplate.getTags();
            RuleTemplate ruleTemplate = t = locale == null ? resultTemplate : (RuleTemplate)((RuleTemplateProvider)provider).getTemplate(resultTemplate.getUID(), locale);
            if (t != null && (tag == null || tags.contains(tag))) {
                result.add(t);
            }
        });
        return result;
    }

    @Override
    public Collection<RuleTemplate> getByTags(String ... tags) {
        return this.getByTags((Locale)null, tags);
    }

    @Override
    public Collection<RuleTemplate> getByTags(@Nullable Locale locale, String ... tags) {
        HashSet<String> tagSet = new HashSet<String>(Arrays.asList(tags));
        ArrayList<RuleTemplate> result = new ArrayList<RuleTemplate>();
        this.forEach((provider, resultTemplate) -> {
            RuleTemplate t;
            Set<String> tTags = resultTemplate.getTags();
            RuleTemplate ruleTemplate = t = locale == null ? resultTemplate : (RuleTemplate)((RuleTemplateProvider)provider).getTemplate(resultTemplate.getUID(), locale);
            if (t != null && tTags.containsAll(tagSet)) {
                result.add(t);
            }
        });
        return result;
    }

    @Override
    public Collection<RuleTemplate> getAll(@Nullable Locale locale) {
        return this.getByTag(null, locale);
    }
}

