/* SPDX-FileCopyrightText: 2023-2025 - Sébastien Wilmet
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gio/gio.h>

G_BEGIN_DECLS

/**
 * GtkSourceSimpleProgressCallback:
 * @number: the number.
 * @user_data: user data.
 *
 * Like #GFileProgressCallback but without the total.
 *
 * Since: 299.6
 */
typedef void (*GtkSourceSimpleProgressCallback) (gsize    number,
						 gpointer user_data);

G_MODULE_EXPORT
void		gtk_source_input_stream_read_async	(GInputStream                    *input_stream,
							 gsize                            expected_size,
							 gsize                            max_size,
							 gint                             io_priority,
							 GCancellable                    *cancellable,
							 GtkSourceSimpleProgressCallback  progress_callback,
							 gpointer                         progress_callback_data,
							 GAsyncReadyCallback              callback,
							 gpointer                         user_data);

G_MODULE_EXPORT
GBytes *	gtk_source_input_stream_read_finish	(GInputStream  *input_stream,
							 GAsyncResult  *result,
							 gboolean      *is_truncated,
							 GError       **error);

G_END_DECLS
