/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.egl.EGL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class MESADRMImage {
    public static final int EGL_DRM_BUFFER_FORMAT_MESA = 12752;
    public static final int EGL_DRM_BUFFER_USE_MESA = 12753;
    public static final int EGL_DRM_BUFFER_FORMAT_ARGB32_MESA = 12754;
    public static final int EGL_DRM_BUFFER_MESA = 12755;
    public static final int EGL_DRM_BUFFER_STRIDE_MESA = 12756;
    public static final int EGL_DRM_BUFFER_USE_SCANOUT_MESA = 1;
    public static final int EGL_DRM_BUFFER_USE_SHARE_MESA = 2;

    protected MESADRMImage() {
        throw new UnsupportedOperationException();
    }

    public static long neglCreateDRMImageMESA(long dpy, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
        }
        return JNI.callPPP((long)dpy, (long)attrib_list, (long)__functionAddress);
    }

    @NativeType(value="EGLImageKHR")
    public static long eglCreateDRMImageMESA(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLint const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((IntBuffer)attrib_list, (int)12344);
        }
        return MESADRMImage.neglCreateDRMImageMESA(dpy, MemoryUtil.memAddressSafe((IntBuffer)attrib_list));
    }

    public static int neglExportDRMImageMESA(long dpy, long image, long name, long handle, long stride) {
        long __functionAddress = EGL.getCapabilities().eglExportDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)image);
        }
        return JNI.callPPPPPI((long)dpy, (long)image, (long)name, (long)handle, (long)stride, (long)__functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglExportDRMImageMESA(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLImageKHR") long image, @Nullable @NativeType(value="EGLint *") IntBuffer name, @Nullable @NativeType(value="EGLint *") IntBuffer handle, @Nullable @NativeType(value="EGLint *") IntBuffer stride) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)name, (int)1);
            Checks.checkSafe((Buffer)handle, (int)1);
            Checks.checkSafe((Buffer)stride, (int)1);
        }
        return MESADRMImage.neglExportDRMImageMESA(dpy, image, MemoryUtil.memAddressSafe((IntBuffer)name), MemoryUtil.memAddressSafe((IntBuffer)handle), MemoryUtil.memAddressSafe((IntBuffer)stride)) != 0;
    }

    @NativeType(value="EGLImageKHR")
    public static long eglCreateDRMImageMESA(@NativeType(value="EGLDisplay") long dpy, @Nullable @NativeType(value="EGLint const *") int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.checkNTSafe((int[])attrib_list, (int)12344);
        }
        return JNI.callPPP((long)dpy, (int[])attrib_list, (long)__functionAddress);
    }

    @NativeType(value="EGLBoolean")
    public static boolean eglExportDRMImageMESA(@NativeType(value="EGLDisplay") long dpy, @NativeType(value="EGLImageKHR") long image, @Nullable @NativeType(value="EGLint *") int[] name, @Nullable @NativeType(value="EGLint *") int[] handle, @Nullable @NativeType(value="EGLint *") int[] stride) {
        long __functionAddress = EGL.getCapabilities().eglExportDRMImageMESA;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)dpy);
            Checks.check((long)image);
            Checks.checkSafe((int[])name, (int)1);
            Checks.checkSafe((int[])handle, (int)1);
            Checks.checkSafe((int[])stride, (int)1);
        }
        return JNI.callPPPPPI((long)dpy, (long)image, (int[])name, (int[])handle, (int[])stride, (long)__functionAddress) != 0;
    }
}

