/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jitsi.cmd.ParseException;
import org.jitsi.config.JitsiConfig;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.metaconfig.MetaconfigLogger;
import org.jitsi.metaconfig.MetaconfigSettings;
import org.jitsi.shutdown.ShutdownServiceImpl;
import org.jitsi.utils.ConfigUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class Main {
    private static final Logger logger = new LoggerImpl(Main.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) throws ParseException {
        JicofoServices jicofoServices;
        logger.info("Starting Jicofo.");
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error("An uncaught exception occurred in thread=" + t, e));
        Main.setupMetaconfigLogger();
        JitsiConfig.Companion.reloadNewConfig();
        ConfigUtils.PASSWORD_SYS_PROPS = "pass";
        ConfigUtils.PASSWORD_CMD_LINE_ARGS = "user_password";
        ShutdownServiceImpl shutdownService = new ShutdownServiceImpl();
        Runtime.getRuntime().addShutdownHook(new Thread(shutdownService::beginShutdown));
        try {
            Object object = JicofoServices.getJicofoServicesSingletonSyncRoot();
            synchronized (object) {
                jicofoServices = new JicofoServices();
                JicofoServices.setJicofoServicesSingleton(jicofoServices);
            }
        }
        catch (Exception e2) {
            logger.error("Failed to start jicofo: ", e2);
            TaskPools.shutdown();
            return;
        }
        try {
            shutdownService.waitForShutdown();
        }
        catch (Exception e3) {
            logger.error(e3, e3);
        }
        logger.info("Stopping services.");
        jicofoServices.shutdown();
        TaskPools.shutdown();
        JicofoServices.setJicofoServicesSingleton(null);
    }

    private static void setupMetaconfigLogger() {
        final LoggerImpl configLogger = new LoggerImpl("org.jitsi.config");
        MetaconfigSettings.Companion.setLogger(new MetaconfigLogger(){

            @Override
            public void warn(@NotNull Function0<String> function0) {
                configLogger.warn(function0::invoke);
            }

            @Override
            public void error(@NotNull Function0<String> function0) {
                configLogger.error(function0::invoke);
            }

            @Override
            public void debug(@NotNull Function0<String> function0) {
                configLogger.debug(function0::invoke);
            }
        });
    }
}

