/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.NonNull;

public final class FirstCommand {
    private final String line;
    private final Set<String> capabilities;

    @NonNull
    public static FirstCommand fromLine(String line) {
        int nul = line.indexOf(0);
        if (nul < 0) {
            return new FirstCommand(line, Collections.emptySet());
        }
        Set opts = Arrays.asList(line.substring(nul + 1).split(" ")).stream().collect(Collectors.toSet());
        return new FirstCommand(line.substring(0, nul), Collections.unmodifiableSet(opts));
    }

    private FirstCommand(String line, Set<String> capabilities) {
        this.line = line;
        this.capabilities = capabilities;
    }

    @NonNull
    public String getLine() {
        return this.line;
    }

    @NonNull
    public Set<String> getCapabilities() {
        return this.capabilities;
    }
}

