/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.event.ArrayDiff;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.netbeans.swing.tabcontrol.event.VeryComplexListDataEvent;
import org.openide.util.ChangeSupport;

final class DefaultTabSelectionModel
implements SingleSelectionModel,
ComplexListDataListener {
    TabDataModel dataModel;
    int sel = -1;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    public DefaultTabSelectionModel(TabDataModel tabDataModel) {
        this.dataModel = tabDataModel;
        this.attach();
    }

    public void attach() {
        this.dataModel.addComplexListDataListener(this);
    }

    public void detach() {
        this.dataModel.removeComplexListDataListener(this);
    }

    public void clearSelection() {
        this.sel = -1;
        this.cs.fireChange();
    }

    public int getSelectedIndex() {
        return this.sel;
    }

    public boolean isSelected() {
        return this.sel != -1;
    }

    public void setSelectedIndex(int n) {
        if (n != this.sel) {
            int n2 = this.sel;
            if (n < -1 || n >= this.dataModel.size()) {
                throw new IllegalArgumentException("Selected index set to " + n + " but model size is only " + this.dataModel.size());
            }
            this.sel = n;
            this.cs.fireChange();
        }
    }

    private void adjustSelectionForEvent(ListDataEvent listDataEvent) {
        if (listDataEvent.getType() == 0 || this.sel == -1) {
            return;
        }
        int n = listDataEvent.getIndex0();
        int n2 = listDataEvent.getIndex1() + 1;
        if (listDataEvent.getType() == 2) {
            if (this.sel < n) {
                return;
            }
            if (this.sel >= n) {
                if (this.sel > n2) {
                    this.sel -= n2 - n;
                } else {
                    this.sel = n;
                    if (this.sel >= this.dataModel.size()) {
                        this.sel = this.dataModel.size() - 1;
                    }
                }
                this.cs.fireChange();
            }
        } else {
            if (this.sel < n) {
                return;
            }
            if (this.sel >= n) {
                this.sel = n2 - 1 == n ? ++this.sel : (this.sel < n2 ? n2 + (this.sel - n) - 1 : (this.sel += n2 - n - 1));
                this.cs.fireChange();
            }
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.adjustSelectionForEvent(listDataEvent);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.adjustSelectionForEvent(listDataEvent);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.adjustSelectionForEvent(listDataEvent);
    }

    public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
        if (this.sel < 0) {
            return;
        }
        int[] nArray = complexListDataEvent.getIndices();
        Arrays.sort(nArray);
        int n = 0;
        for (int i = 0; i < nArray.length && this.sel >= nArray[i]; ++i) {
            ++n;
        }
        if (n > 0) {
            this.sel += n;
            this.cs.fireChange();
        }
    }

    public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
        if (this.sel < 0) {
            return;
        }
        int[] nArray = complexListDataEvent.getIndices();
        Arrays.sort(nArray);
        int n = -1;
        for (int i = 0; i < nArray.length && this.sel > nArray[i]; ++i) {
            --n;
        }
        if (this.sel == this.dataModel.size()) {
            --this.sel;
            this.cs.fireChange();
            return;
        }
        if (this.dataModel.size() == 0) {
            this.sel = -1;
            this.cs.fireChange();
        } else if (n != 0) {
            this.sel = Math.max(-1, Math.min(this.sel + n, -1));
            this.cs.fireChange();
        }
    }

    public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
        if (this.sel < 0) {
            return;
        }
        if (complexListDataEvent instanceof VeryComplexListDataEvent) {
            ArrayDiff arrayDiff = ((VeryComplexListDataEvent)complexListDataEvent).getDiff();
            boolean bl = false;
            if (arrayDiff == null) {
                return;
            }
            Set<Integer> set = arrayDiff.getDeletedIndices();
            Set<Integer> set2 = arrayDiff.getAddedIndices();
            Integer n = new Integer(this.getSelectedIndex());
            if (this.dataModel.size() == 0) {
                this.sel = -1;
                this.cs.fireChange();
                return;
            }
            Iterator<Integer> iterator = set.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Integer n3 = iterator.next();
                if (n3.compareTo(n) > 0) continue;
                ++n2;
            }
            for (Integer n3 : set2) {
                if (n3.compareTo(n) < 0) continue;
                --n2;
            }
            this.sel -= n2;
            if (this.sel < 0) {
                int n4 = this.sel = this.dataModel.size() > 0 ? 0 : -1;
            }
            if (this.sel >= this.dataModel.size()) {
                this.sel = this.dataModel.size() - 1;
            }
            if (n2 != 0) {
                this.cs.fireChange();
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }
}

