/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import gnu.getopt.Getopt;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SU3File;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.NewsFetcher;
import net.i2p.router.update.UpdateHandler;
import net.i2p.router.web.ConfigUpdateHelper;
import net.i2p.update.Checker;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateTask;
import net.i2p.update.UpdateType;
import net.i2p.util.EepGet;

public class NewsHandler
extends UpdateHandler
implements Checker {
    private static final String BACKUP_NEWS_URL = "http://dn3tvalnjz432qkqsvpfdqrwpqkw3ye4n4i2uyfr4jexvo3sp5ka.b32.i2p/news/news.atom.xml";
    private static final String DEFAULT_BACKUP_NEWS_URL_SU3 = "http://dn3tvalnjz432qkqsvpfdqrwpqkw3ye4n4i2uyfr4jexvo3sp5ka.b32.i2p/news/news.su3";
    private static final String PROP_BACKUP_NEWS_URL_SU3 = "router.backupNewsURL";

    public NewsHandler(RouterContext ctx, ConsoleUpdateManager mgr) {
        super(ctx, mgr);
    }

    @Override
    public UpdateTask check(UpdateType type, UpdateMethod method, String id, String currentVersion, long maxTime) {
        if (type != UpdateType.ROUTER_SIGNED && type != UpdateType.NEWS && type != UpdateType.NEWS_SU3 || method != UpdateMethod.HTTP) {
            return null;
        }
        ArrayList<URI> updateSources = new ArrayList<URI>(2);
        try {
            updateSources.add(new URI(ConfigUpdateHelper.getNewsURL(this._context)));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        try {
            updateSources.add(new URI(this._context.getProperty(PROP_BACKUP_NEWS_URL_SU3, DEFAULT_BACKUP_NEWS_URL_SU3)));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        NewsFetcher update = new NewsFetcher(this._context, this._mgr, updateSources, maxTime);
        return update;
    }

    public static void main(String[] args) {
        int c;
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        String url = ConfigUpdateHelper.getNewsURL(ctx);
        String proxyHost = "127.0.0.1";
        int proxyPort = 4444;
        String lang = null;
        boolean custom = false;
        boolean error = false;
        Getopt g = new Getopt("newshandler", args, "p:l:u:");
        block5: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 112: {
                    String s = g.getOptarg();
                    int colon = s.indexOf(58);
                    if (colon >= 0) {
                        if (colon > 0) {
                            proxyHost = s.substring(0, colon);
                        }
                        String port = s.substring(colon + 1);
                        proxyPort = Integer.parseInt(port);
                        continue block5;
                    }
                    proxyHost = s;
                    continue block5;
                }
                case 108: {
                    lang = g.getOptarg();
                    continue block5;
                }
                case 117: {
                    url = g.getOptarg();
                    custom = true;
                    continue block5;
                }
            }
            error = true;
        }
        if (error || args.length - g.getOptind() != 0) {
            System.err.println("Usage: newshandler [-p 127.0.0.1[:4444]] [-l en] [-u url]");
            System.exit(1);
        }
        if (lang != null) {
            url = url + "?lang=" + lang;
        }
        File file = new File("news-primary.su3");
        System.out.println("Fetching news from primary server at " + url);
        NewsHandler.test(ctx, proxyHost, proxyPort, url, file);
        if (!custom) {
            url = DEFAULT_BACKUP_NEWS_URL_SU3;
            if (lang != null) {
                url = url + "?lang=" + lang;
            }
            file = new File("news-backup.su3");
            System.out.println("Fetching news from backup server at " + url);
            NewsHandler.test(ctx, proxyHost, proxyPort, url, file);
        }
    }

    private static void test(I2PAppContext ctx, String phost, int pport, String url, File file) {
        file.delete();
        String path = file.getAbsolutePath();
        EepGet get = new EepGet(ctx, phost, pport, 0, file.getAbsolutePath(), url);
        if (get.fetch()) {
            int status = get.getStatusCode();
            if (status == 200) {
                SU3File.main(new String[]{"showversion", path});
                SU3File.main(new String[]{"extract", "-x", path});
            } else {
                System.out.println("Failed to fetch, status " + status + " for " + url);
            }
        } else {
            System.out.println("Failed to fetch " + url);
        }
    }
}

