/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jhotdraw.draw.AbstractDrawing;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureLayerComparator;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.util.ReversedList;

public class DefaultDrawing
extends AbstractDrawing {
    private boolean needsSorting = false;

    @Override
    public void basicAdd(int n, Figure figure) {
        super.basicAdd(n, figure);
        this.invalidateSortOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D graphics2D) {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureSorted();
            ArrayList<Figure> arrayList = new ArrayList<Figure>(this.getChildren().size());
            Rectangle rectangle = graphics2D.getClipBounds();
            for (Figure figure : this.getChildren()) {
                if (!figure.getDrawingArea().intersects(rectangle)) continue;
                arrayList.add(figure);
            }
            this.draw(graphics2D, arrayList);
        }
    }

    public void draw(Graphics2D graphics2D, Collection<Figure> collection) {
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null) {
            for (Figure figure : collection) {
                if (!figure.isVisible() || !figure.getDrawingArea().intersects(rectangle)) continue;
                figure.draw(graphics2D);
            }
        } else {
            for (Figure figure : collection) {
                if (!figure.isVisible()) continue;
                figure.draw(graphics2D);
            }
        }
    }

    @Override
    public List<Figure> sort(Collection<? extends Figure> collection) {
        HashSet<? extends Figure> hashSet = new HashSet<Figure>();
        hashSet.addAll(collection);
        ArrayList<Figure> arrayList = new ArrayList<Figure>(collection.size());
        for (Figure figure : this.getChildren()) {
            if (!hashSet.contains(figure)) continue;
            arrayList.add(figure);
            hashSet.remove(figure);
        }
        for (Figure figure : collection) {
            if (!hashSet.contains(figure)) continue;
            arrayList.add(figure);
            hashSet.remove(figure);
        }
        return arrayList;
    }

    @Override
    public Figure findFigure(Point2D.Double double_) {
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (!figure.isVisible() || !figure.contains(double_)) continue;
            return figure;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double double_, Figure figure) {
        for (Figure figure2 : this.getFiguresFrontToBack()) {
            if (figure2 == figure || !figure2.isVisible() || !figure2.contains(double_)) continue;
            return figure2;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double double_, Figure figure) {
        boolean bl = false;
        for (Figure figure2 : this.getFiguresFrontToBack()) {
            if (bl) {
                if (!figure2.isVisible() || !figure2.contains(double_)) continue;
                return figure2;
            }
            bl = figure == figure2;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double double_, Collection<? extends Figure> collection) {
        int n = collection.size();
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (n == 0) {
                if (!figure.isVisible() || !figure.contains(double_)) continue;
                return figure;
            }
            if (!collection.contains(figure)) continue;
            --n;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double double_, Collection<? extends Figure> collection) {
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (collection.contains(figure) || !figure.isVisible() || !figure.contains(double_)) continue;
            return figure;
        }
        return null;
    }

    @Override
    public List<Figure> findFigures(Rectangle2D.Double double_) {
        LinkedList<Figure> linkedList = new LinkedList<Figure>();
        for (Figure figure : this.getChildren()) {
            if (!figure.isVisible() || !figure.getBounds().intersects(double_)) continue;
            linkedList.add(figure);
        }
        return linkedList;
    }

    @Override
    public List<Figure> findFiguresWithin(Rectangle2D.Double double_) {
        LinkedList<Figure> linkedList = new LinkedList<Figure>();
        for (Figure figure : this.getChildren()) {
            Rectangle2D.Double double_2 = figure.getBounds();
            if (figure.get(AttributeKeys.TRANSFORM) != null) {
                Rectangle2D rectangle2D = figure.get(AttributeKeys.TRANSFORM).createTransformedShape(double_2).getBounds2D();
                Rectangle2D.Double double_3 = double_2 = rectangle2D instanceof Rectangle2D.Double ? (Rectangle2D.Double)rectangle2D : new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            }
            if (!figure.isVisible() || !Geom.contains(double_, double_2)) continue;
            linkedList.add(figure);
        }
        return linkedList;
    }

    @Override
    public Figure findFigureInside(Point2D.Double double_) {
        Figure figure = this.findFigure(double_);
        return figure == null ? null : figure.findFigureInside(double_);
    }

    @Override
    public List<Figure> getFiguresFrontToBack() {
        this.ensureSorted();
        return new ReversedList<Figure>(this.getChildren());
    }

    private void invalidateSortOrder() {
        this.needsSorting = true;
    }

    private void ensureSorted() {
        if (this.needsSorting) {
            Collections.sort(this.children, FigureLayerComparator.INSTANCE);
            this.needsSorting = false;
        }
    }

    protected void setAttributeOnChildren(AttributeKey attributeKey, Object object) {
    }

    @Override
    public int indexOf(Figure figure) {
        return this.children.indexOf(figure);
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
    }
}

