/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.Objects;
import org.apache.kafka.clients.admin.ShareMemberAssignment;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ShareMemberDescription {
    private final String memberId;
    private final String clientId;
    private final String host;
    private final ShareMemberAssignment assignment;
    private final int memberEpoch;

    public ShareMemberDescription(String memberId, String clientId, String host, ShareMemberAssignment assignment, int memberEpoch) {
        this.memberId = memberId == null ? "" : memberId;
        this.clientId = clientId == null ? "" : clientId;
        this.host = host == null ? "" : host;
        this.assignment = assignment == null ? new ShareMemberAssignment(Collections.emptySet()) : assignment;
        this.memberEpoch = memberEpoch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShareMemberDescription that = (ShareMemberDescription)o;
        return this.memberId.equals(that.memberId) && this.clientId.equals(that.clientId) && this.host.equals(that.host) && this.assignment.equals(that.assignment) && this.memberEpoch == that.memberEpoch;
    }

    public int hashCode() {
        return Objects.hash(this.memberId, this.clientId, this.host, this.assignment, this.memberEpoch);
    }

    public String consumerId() {
        return this.memberId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String host() {
        return this.host;
    }

    public ShareMemberAssignment assignment() {
        return this.assignment;
    }

    public int memberEpoch() {
        return this.memberEpoch;
    }

    public String toString() {
        return "(memberId=" + this.memberId + ", clientId=" + this.clientId + ", host=" + this.host + ", assignment=" + String.valueOf(this.assignment) + ", memberEpoch=" + this.memberEpoch + ")";
    }
}

