/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ref;

import java.lang.ref.SoftReference;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubySoftReference
extends RubyObject {
    private SoftReference _ref;
    private static final String REFERENCED_OBJECT_ID_VARIABLE = "@referenced_object_id".intern();
    public static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new RubySoftReference(ruby, rubyClass);
        }
    };

    public RubySoftReference(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
        this._ref = new SoftReference<IRubyObject>(iRubyObject);
        this.fastSetInstanceVariable(REFERENCED_OBJECT_ID_VARIABLE, iRubyObject.id());
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"object"})
    public IRubyObject object() {
        IRubyObject iRubyObject = (IRubyObject)this._ref.get();
        if (iRubyObject != null) {
            return iRubyObject;
        }
        return this.getRuntime().getNil();
    }
}

