/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.fop.area.AbstractOffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.fo.pagination.bookmarks.Bookmark;
import org.apache.fop.fo.pagination.bookmarks.BookmarkTree;

public class BookmarkData
extends AbstractOffDocumentItem
implements Resolvable {
    private ArrayList subData = new ArrayList();
    private String bookmarkTitle = null;
    private boolean bShow = true;
    private String idRef;
    private PageViewport pageRef = null;
    private HashMap unresolvedIDRefs = new HashMap();

    public BookmarkData(BookmarkTree bookmarkTree) {
        this.idRef = null;
        this.whenToProcess = 2;
        this.bShow = true;
        for (int count = 0; count < bookmarkTree.getBookmarks().size(); ++count) {
            Bookmark bkmk = (Bookmark)bookmarkTree.getBookmarks().get(count);
            this.addSubData(this.createBookmarkData(bkmk));
        }
    }

    public BookmarkData(Bookmark bookmark) {
        this.bookmarkTitle = bookmark.getBookmarkTitle();
        this.bShow = bookmark.showChildItems();
        this.idRef = bookmark.getInternalDestination();
        this.unresolvedIDRefs.put(this.idRef, this);
    }

    public String getIDRef() {
        return this.idRef;
    }

    public void addSubData(BookmarkData sub) {
        this.subData.add(sub);
        this.unresolvedIDRefs.put(sub.getIDRef(), sub);
        String[] ids = sub.getIDRefs();
        for (int count = 0; count < ids.length; ++count) {
            this.unresolvedIDRefs.put(ids[count], sub);
        }
    }

    public String getBookmarkTitle() {
        return this.bookmarkTitle;
    }

    public boolean showChildItems() {
        return this.bShow;
    }

    public int getCount() {
        return this.subData.size();
    }

    public BookmarkData getSubData(int count) {
        return (BookmarkData)this.subData.get(count);
    }

    public PageViewport getPageViewport() {
        return this.pageRef;
    }

    public boolean isResolved() {
        return this.unresolvedIDRefs == null || this.unresolvedIDRefs.size() == 0;
    }

    public String[] getIDRefs() {
        return this.unresolvedIDRefs.keySet().toArray(new String[0]);
    }

    public void resolveIDRef(String id, List pages) {
        if (!id.equals(this.idRef)) {
            BookmarkData bd = (BookmarkData)this.unresolvedIDRefs.get(id);
            if (bd != null) {
                bd.resolveIDRef(id, pages);
                this.unresolvedIDRefs.remove(id);
            }
        } else {
            this.pageRef = (PageViewport)pages.get(0);
            this.unresolvedIDRefs.remove(this.idRef);
        }
    }

    public String getName() {
        return "Bookmarks";
    }

    private BookmarkData createBookmarkData(Bookmark bookmark) {
        BookmarkData data = new BookmarkData(bookmark);
        for (int count = 0; count < bookmark.getChildBookmarks().size(); ++count) {
            Bookmark bkmk = (Bookmark)bookmark.getChildBookmarks().get(count);
            data.addSubData(this.createBookmarkData(bkmk));
        }
        return data;
    }
}

