/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.PskDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.DHClientKeyExchangeParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskDhClientKeyExchangeParser
extends DHClientKeyExchangeParser<PskDhClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PskDhClientKeyExchangeParser(int startposition, byte[] array, ProtocolVersion version, Config config) {
        super(startposition, array, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(PskDhClientKeyExchangeMessage msg) {
        LOGGER.debug("Parsing PSKDHClientKeyExchangeMessage");
        this.parsePskIdentityLength(msg);
        this.parsePskIdentity(msg);
        super.parseDhParams(msg);
    }

    @Override
    protected PskDhClientKeyExchangeMessage createHandshakeMessage() {
        return new PskDhClientKeyExchangeMessage();
    }

    private void parsePskIdentityLength(PskDhClientKeyExchangeMessage msg) {
        msg.setIdentityLength(this.parseIntField(2));
        LOGGER.debug("PSK-IdentityLength: " + msg.getIdentityLength().getValue());
    }

    private void parsePskIdentity(PskDhClientKeyExchangeMessage msg) {
        msg.setIdentity(this.parseByteArrayField((Integer)msg.getIdentityLength().getValue()));
        LOGGER.debug("SerializedPSK-Identity: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getIdentity().getValue())));
    }
}

