/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.CachedResultSetMetaData;
import ca.sqlpower.sql.RowFilter;
import ca.sqlpower.sql.RowSetChangeEvent;
import ca.sqlpower.sql.RowSetChangeListener;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class CachedRowSet
implements ResultSet,
Serializable {
    private static final Logger logger = Logger.getLogger(CachedRowSet.class);
    private static final int BEFORE_FIRST_ROW = -1;
    private static final int INSERT_ROW = -2;
    private boolean makeUppercase = true;
    private int rownum = -1;
    protected List<Object[]> data;
    protected Object[] curRow;
    private int curCol = -1;
    protected CachedResultSetMetaData rsmd = new CachedResultSetMetaData();
    private final List<RowSetChangeListener> rowSetListeners = new ArrayList<RowSetChangeListener>();
    private int rownumBeforeInserting;
    private boolean insertRowAlreadyInserted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void follow(ResultSet rs, int rowLimit, String ... extraColNames) throws SQLException {
        this.data = Collections.synchronizedList(new ArrayList());
        logger.debug((Object)("crs@" + System.identityHashCode(this) + " starting to follow..."));
        this.rsmd = new CachedResultSetMetaData(rs.getMetaData(), this.makeUppercase);
        int rsColCount = this.rsmd.getColumnCount();
        int colCount = rsColCount + extraColNames.length;
        for (String extraColName : extraColNames) {
            this.rsmd.addColumn(false, false, false, false, 1, true, 10, extraColName, extraColName, null, 10, 0, null, null, 12, "VARCHAR", false, true, true, String.class.getName());
        }
        int rowNum = 0;
        while (rs.next()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("crs@" + System.identityHashCode(this) + " populating Row " + rowNum));
            }
            Object[] row = new Object[colCount];
            for (int i = 0; i < rsColCount; ++i) {
                Object o = rs.getObject(i + 1);
                if (logger.isDebugEnabled()) {
                    if (o == null) {
                        logger.debug((Object)("   Col " + i + ": null"));
                    } else {
                        logger.debug((Object)("   Col " + i + ": " + o + " (" + o.getClass() + ")"));
                    }
                }
                row[i] = o;
            }
            List<Object[]> list = this.data;
            synchronized (list) {
                this.data.add(row);
                while (this.data.size() > rowLimit) {
                    this.data.remove(0);
                }
            }
            this.fireRowAdded(row, rowNum);
            ++rowNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedRowSet sort(RowComparator c) {
        CachedRowSet newRs = new CachedRowSet();
        try {
            newRs.populate(this);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (this.data != null) {
            List<Object[]> list = this.data;
            synchronized (list) {
                Collections.sort(newRs.data, c);
            }
        }
        return newRs;
    }

    public void populate(ResultSet rs) throws SQLException {
        this.populate(rs, null);
    }

    public void populate(ResultSet rs, RowFilter filter) throws SQLException {
        this.populate(rs, filter, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate(ResultSet rs, RowFilter filter, String ... extraColNames) throws SQLException {
        this.rsmd = new CachedResultSetMetaData(rs.getMetaData(), this.makeUppercase);
        int rsColCount = this.rsmd.getColumnCount();
        int colCount = rsColCount + extraColNames.length;
        for (String extraColName : extraColNames) {
            this.rsmd.addColumn(false, false, false, false, 1, true, 10, extraColName, extraColName, null, 10, 0, null, null, 12, "VARCHAR", false, true, true, String.class.getName());
        }
        int rowNum = 0;
        this.data = Collections.synchronizedList(new ArrayList());
        if (rs.getType() != 1003) {
            rs.beforeFirst();
        }
        while (rs.next()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Populating Row " + rowNum));
            }
            Object[] row = new Object[colCount];
            for (int i = 0; i < rsColCount; ++i) {
                Object o = rs.getObject(i + 1);
                if (o == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("   Col " + i + ": null"));
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("   Col " + i + ": " + o + " (" + o.getClass() + ")"));
                }
                row[i] = o;
            }
            if (filter == null || filter.acceptsRow(row)) {
                List<Object[]> list = this.data;
                synchronized (list) {
                    this.data.add(row);
                    ++rowNum;
                    continue;
                }
            }
            logger.debug((Object)"Skipped this row (rejected by filter)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wouldPass(int row, @Nullable RowFilter resultSetFilter) throws SQLException {
        if (resultSetFilter == null) {
            return true;
        }
        if (this.data == null) {
            return true;
        }
        List<Object[]> list = this.data;
        synchronized (list) {
            return resultSetFilter.acceptsRow(this.data.get(row - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.data == null) {
            return 0;
        }
        List<Object[]> list = this.data;
        synchronized (list) {
            return this.data.size();
        }
    }

    public void setMakeUppercase(boolean makeUppercase) {
        this.makeUppercase = makeUppercase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> getData() {
        if (this.data == null) {
            return new ArrayList<Object[]>();
        }
        List<Object[]> list = this.data;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Object[]>(this.data));
        }
    }

    public int getColumnIndex(String columnName) throws SQLException {
        int idx = -1;
        for (int i = 0; i < this.rsmd.getColumnCount(); ++i) {
            if (!this.rsmd.getColumnName(i + 1).equalsIgnoreCase(columnName)) continue;
            idx = i + 1;
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getColumnIndex(" + columnName + ") returns " + idx));
        }
        return idx;
    }

    public void addRowSetListener(@Nonnull RowSetChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("Null listener not allowed");
        }
        this.rowSetListeners.add(listener);
    }

    public void removeRowSetListener(@Nullable RowSetChangeListener listener) {
        this.rowSetListeners.remove(listener);
    }

    protected void fireRowAdded(Object[] row, int rowNum) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("crs@" + System.identityHashCode(this) + " firing RowAdded for " + this.rowSetListeners.size() + " listeners..."));
        }
        RowSetChangeEvent evt = new RowSetChangeEvent(this, row, rowNum);
        for (int i = this.rowSetListeners.size() - 1; i >= 0; --i) {
            RowSetChangeListener l = this.rowSetListeners.get(i);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("crs@" + System.identityHashCode(this) + " delivering RowAdded to " + l.getClass().getSimpleName() + "@" + System.identityHashCode(l)));
            }
            l.rowAdded(evt);
        }
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.curRow == null || this.curCol < 0) {
            throw new SQLException("You haven't accessed a value with a getXXX() method yet!");
        }
        return this.curRow[this.curCol] == null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return null;
        }
        return this.curRow[columnIndex - 1].toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return false;
        }
        return (Boolean)this.curRow[columnIndex - 1];
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0;
        }
        return ((Number)this.curRow[columnIndex - 1]).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0;
        }
        return ((Number)this.curRow[columnIndex - 1]).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0;
        }
        return ((Number)this.curRow[columnIndex - 1]).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0L;
        }
        return ((Number)this.curRow[columnIndex - 1]).longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0.0f;
        }
        return ((Number)this.curRow[columnIndex - 1]).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return 0.0;
        }
        return ((Number)this.curRow[columnIndex - 1]).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return null;
        }
        java.util.Date uDate = (java.util.Date)this.curRow[columnIndex - 1];
        return new Date(uDate.getTime());
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return null;
        }
        return (Time)this.curRow[columnIndex - 1];
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[columnIndex - 1] == null) {
            return null;
        }
        return (Timestamp)this.curRow[columnIndex - 1];
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        return this.curRow[columnIndex - 1];
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("This CachedRowSet does not support user-defined type mappings.");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        this.curCol = i - 1;
        return (Ref)this.curRow[i - 1];
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.curCol = i - 1;
        return (Blob)this.curRow[i - 1];
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.curCol = i - 1;
        return (Clob)this.curRow[i - 1];
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.curCol = i - 1;
        return (Array)this.curRow[i - 1];
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        if (this.curRow[this.curCol] == null) {
            return null;
        }
        if (this.curRow[this.curCol] instanceof URL) {
            return (URL)this.curRow[this.curCol];
        }
        try {
            return new URL(this.getString(columnIndex));
        }
        catch (MalformedURLException e) {
            throw new SQLException("Not a URL: <" + this.getString(columnIndex) + ">");
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(columnName);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(columnName);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(columnName);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rsmd;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        int index = this.getColumnIndex(columnName);
        if (index == -1) {
            throw new SQLException("No such column '" + columnName + "' in this result set.");
        }
        return index;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.data == null) {
            return false;
        }
        return this.rownum == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.data == null) {
            return false;
        }
        List<Object[]> list = this.data;
        synchronized (list) {
            return this.rownum >= this.data.size();
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.data == null) {
            return false;
        }
        return this.rownum == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLast() throws SQLException {
        if (this.data == null) {
            return false;
        }
        List<Object[]> list = this.data;
        synchronized (list) {
            return this.rownum == this.data.size() - 1;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        if (this.data != null) {
            List<Object[]> list = this.data;
            synchronized (list) {
                this.absolute(this.data.size());
            }
        }
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.rownum < 0) {
            return 0;
        }
        return this.rownum + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.data == null) {
            return false;
        }
        List<Object[]> list = this.data;
        synchronized (list) {
            this.curCol = -1;
            this.curRow = null;
            this.rownum = row < 0 ? this.data.size() + row : row - 1;
            if (this.rownum < 0) {
                this.rownum = -1;
                return false;
            }
            if (this.rownum >= this.data.size()) {
                this.rownum = this.data.size();
                return false;
            }
            if (this.data.size() > 0) {
                this.curRow = this.data.get(this.rownum);
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.data == null) {
            return false;
        }
        List<Object[]> list = this.data;
        synchronized (list) {
            this.curCol = -1;
            this.curRow = null;
            this.rownum += rows;
            if (this.rownum < 0) {
                this.rownum = -1;
                return false;
            }
            if (this.rownum >= this.data.size()) {
                this.rownum = this.data.size();
                return false;
            }
            this.curRow = this.data.get(this.rownum);
            return true;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new UnsupportedOperationException("Fetch direction is always FORWARD.");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException("This CachedRowSet does not have a reference to the Statement object.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Updates are not supported by CachedRowSet");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.curCol = columnIndex - 1;
        Object curColObject = this.curRow[columnIndex - 1];
        if (curColObject == null) {
            return new BigDecimal(0);
        }
        if (curColObject instanceof BigDecimal) {
            return (BigDecimal)this.curRow[columnIndex - 1];
        }
        if (curColObject instanceof Number) {
            return new BigDecimal(String.valueOf(curColObject));
        }
        throw new SQLException("Could not convert column " + columnIndex + " of type " + curColObject.getClass() + " to BigDecimal.");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        throw new UnsupportedOperationException("This method is not supported by CachedRowSet");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.curRow[columnIndex - 1] = null;
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.curRow[columnIndex - 1] = x ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.curRow[columnIndex - 1] = BigDecimal.valueOf(x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.curRow[columnIndex - 1] = BigDecimal.valueOf(x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.curRow[columnIndex - 1] = BigDecimal.valueOf(x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.curRow[columnIndex - 1] = BigDecimal.valueOf(x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.curRow[columnIndex - 1] = BigDecimal.valueOf(x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.curRow[columnIndex - 1] = BigDecimal.valueOf(x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        if (this.curRow == null) {
            throw new SQLException("Not on a valid row");
        }
        this.curRow[columnIndex - 1] = x;
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnName), x);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnName), x);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.curRow = new Object[this.rsmd.getColumnCount()];
        if (this.rownum != -2) {
            this.rownumBeforeInserting = this.rownum;
        }
        this.rownum = -2;
        this.insertRowAlreadyInserted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        List<Object[]> list = this.data;
        synchronized (list) {
            if (this.rownum != -2) {
                throw new SQLException("Not on insert row");
            }
            if (this.insertRowAlreadyInserted) {
                throw new SQLException("The insert row has already been inserted");
            }
            this.data.add(this.curRow);
            this.insertRowAlreadyInserted = true;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.rownum == -2) {
            this.rownum = this.rownumBeforeInserting;
            this.rownumBeforeInserting = 0;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException("Updates not supported!");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException("Updates not supported!");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException("Updates not supported!");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("Updates not supported!");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    public static class RowComparator
    implements Comparator<Object[]>,
    Serializable {
        private ArrayList<SortCol> sortCols = new ArrayList();

        public void addSortColumn(int columnIndex, boolean ascending) {
            this.sortCols.add(new SortCol(columnIndex, ascending));
        }

        @Override
        public int compare(Object[] r1, Object[] r2) {
            int diff = 0;
            for (SortCol sc : this.sortCols) {
                if (r1 == null && r2 == null) {
                    diff = 0;
                } else if (r1 == null) {
                    diff = -1;
                } else if (r2 == null) {
                    diff = 1;
                } else if (r1[sc.columnIndex - 1] instanceof Number && r2[sc.columnIndex - 1] instanceof Number) {
                    double d2;
                    double d1 = ((Number)r1[sc.columnIndex - 1]).doubleValue();
                    diff = d1 < (d2 = ((Number)r2[sc.columnIndex - 1]).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
                } else if (r1[sc.columnIndex - 1] instanceof String && r2[sc.columnIndex - 1] instanceof String) {
                    String s1 = (String)r1[sc.columnIndex - 1];
                    String s2 = (String)r2[sc.columnIndex - 1];
                    diff = s1.compareToIgnoreCase(s2);
                } else if (r1[sc.columnIndex - 1] instanceof Comparable && r2[sc.columnIndex - 1] instanceof Comparable) {
                    Comparable c1 = (Comparable)r1[sc.columnIndex - 1];
                    Comparable c2 = (Comparable)r2[sc.columnIndex - 1];
                    diff = c1.compareTo(c2);
                } else {
                    Object r1ColVal = r1[sc.columnIndex - 1];
                    Object r2ColVal = r2[sc.columnIndex - 1];
                    diff = r1ColVal == null && r2ColVal == null ? 0 : (r1ColVal == null ? -1 : (r2ColVal == null ? 1 : 0));
                }
                if (diff == 0) continue;
                if (sc.ascending) break;
                diff = 0 - diff;
                break;
            }
            return diff;
        }

        public boolean isEmpty() {
            return this.sortCols.isEmpty();
        }

        private static class SortCol
        implements Serializable {
            public int columnIndex;
            public boolean ascending;

            public SortCol(int columnIndex, boolean ascending) {
                this.columnIndex = columnIndex;
                this.ascending = ascending;
            }
        }
    }
}

