/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimephasedWork;
import plan.Convert;
import plan.PlanWriter;

public class TestConvert {
    public static void main(String[] stringArray) {
        System.out.println("TestConvert");
        try {
            if (stringArray.length < 2) {
                System.out.println("Usage: TestConvert <test data directory name> <test result directory name> [<log file name>]");
            } else {
                File file;
                if (stringArray.length == 3) {
                    System.out.println("Redirect to file " + stringArray[2]);
                    System.setOut(new PrintStream(new BufferedOutputStream(new FileOutputStream(stringArray[2])), true));
                }
                if ((file = new File(stringArray[0])).isDirectory()) {
                    TestConvert.test(file, stringArray[1]);
                } else {
                    TestConvert.testFile(stringArray[0], stringArray[1]);
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println("Exception");
            throwable.printStackTrace(System.out);
        }
    }

    private static void test(File file, String string) throws Exception {
        String[] stringArray = file.list();
        System.out.println("Data Directory: " + file.getCanonicalPath());
        for (String string2 : stringArray) {
            try {
                System.out.println();
                File file2 = new File(file, string2);
                if (file2.isDirectory()) {
                    TestConvert.test(file2, string);
                    continue;
                }
                if (string2.endsWith(".mpd")) {
                    System.out.println(".mpd file not supported: " + string2);
                    continue;
                }
                String string3 = file.getCanonicalPath() + "/" + string2;
                TestConvert.testFile(string3, string);
            }
            catch (MPXJException mPXJException) {
                System.out.println("FAIL: TestConvert, file: " + string2);
                mPXJException.printStackTrace(System.out);
            }
        }
    }

    private static void testFile(String string, String string2) {
        try {
            System.out.println("Testing input file: " + string);
            String string3 = string;
            int n = string3.lastIndexOf(47);
            if (n > 0) {
                string3 = string3.substring(n + 1, string3.length());
            }
            if ((n = string3.lastIndexOf(46)) < 0) {
                System.out.println("File must have an extension: " + string);
                return;
            }
            String string4 = string3.substring(n + 1, string3.length());
            String string5 = string3.substring(0, n);
            System.out.println("File name: " + string3);
            ProjectFile projectFile = Convert.readFile(string, string4, "password");
            TestConvert.printStatistics(projectFile);
            Object object = string2.isEmpty() ? "./" : string2 + "/";
            String string6 = (String)object + string3 + ".plan";
            System.out.println("Writing Plan output file: " + string6);
            PlanWriter planWriter = new PlanWriter();
            planWriter.write(projectFile, string6);
            System.out.println("Test completed, file: " + string3);
        }
        catch (Exception exception) {
            System.out.println("FAIL: TestConvert, file: " + string);
            exception.printStackTrace(System.out);
        }
    }

    private static void printStatistics(ProjectFile projectFile) {
        int n;
        System.out.println();
        System.out.println("Project statistics:");
        System.out.println("    Title:          " + projectFile.getProjectProperties().getProjectTitle());
        System.out.println("    Language:       " + projectFile.getProjectProperties().getLanguage());
        int n2 = 0;
        for (ProjectFile projectFile2 : projectFile.getBaselines()) {
            if (projectFile2 == null) continue;
            ++n2;
        }
        System.out.println("    Baselines:      " + n2);
        System.out.println("    Calendars:      " + projectFile.getCalendars().size());
        System.out.println("    Tasks:          " + projectFile.getTasks().size());
        boolean bl = false;
        boolean bl2 = false;
        for (Object object : projectFile.getTasks()) {
            if (!bl && ((Task)object).getCalendar() != null) {
                bl = true;
            }
            if (bl2 || ((Task)object).getPredecessors().isEmpty() && ((Task)object).getSuccessors().isEmpty()) continue;
            bl2 = true;
        }
        if (bl) {
            System.out.println("        Has Task calendar");
        }
        if (bl2) {
            System.out.println("        Has Task relations");
        }
        ArrayList arrayList = new ArrayList();
        for (Resource resource : projectFile.getResources()) {
            if (resource.getGroup() == null || resource.getGroup().isEmpty() || arrayList.contains(resource.getGroup())) continue;
            arrayList.add(resource.getGroup());
        }
        System.out.println("    Groups:         " + arrayList.size());
        for (n = 0; n < arrayList.size(); ++n) {
            System.out.println("        Group " + n + ": " + (String)arrayList.get(n));
        }
        System.out.println("    Resources:      " + projectFile.getResources().size());
        System.out.println("    Assignments:    " + projectFile.getResourceAssignments().size());
        n = 0;
        int n3 = 0;
        int n4 = 0;
        for (Resource object : projectFile.getResources()) {
            for (ResourceAssignment resourceAssignment : object.getTaskAssignments()) {
                List<TimephasedWork> list;
                if (n == 0) {
                    list = resourceAssignment.getTimephasedWork();
                    int n5 = n = list != null ? list.size() : 0;
                    if (n > 0) {
                        System.out.println("        Has Planned time phased assignments");
                    }
                }
                if (n4 == 0) {
                    list = resourceAssignment.getTimephasedOvertimeWork();
                    int n6 = n4 = list != null ? list.size() : 0;
                    if (n4 > 0) {
                        System.out.println("        Has Overtime time phased assignments");
                    }
                }
                if (n3 == 0) {
                    list = resourceAssignment.getTimephasedActualWork();
                    int n7 = n3 = list != null ? list.size() : 0;
                    if (n3 > 0) {
                        System.out.println("        Has Complete time phased assignments");
                    }
                }
                if (n <= 0 || n3 <= 0 || n4 != 0) continue;
                break;
            }
            if (n <= 0 || n3 <= 0 || n4 <= 0) continue;
            break;
        }
        for (ProjectFile projectFile2 : projectFile.getBaselines()) {
            if (projectFile2 == null) continue;
            System.out.println("    Baseline " + projectFile2);
            TestConvert.printStatistics(projectFile2);
        }
        System.out.println("    Sub-projects:   " + projectFile.getSubProjects().size());
        for (SubProject subProject : projectFile.getSubProjects()) {
            System.out.println("    Sub-project:   " + subProject);
        }
        System.out.println();
    }
}

