/*
    This file is part of the KContacts framework.
    SPDX-FileCopyrightText: 2016-2019 Laurent Montel <montel@kde.org>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef CLIENTPIDMAP_H
#define CLIENTPIDMAP_H

#include "kcontacts_export.h"

#include <QMap>
#include <QSharedDataPointer>
#include <QString>

class ClientPidMapTest;

namespace KContacts
{
class ParameterMap;

/*!
 * \class KContacts::ClientPidMap
 * \inheaderfile KContacts/ClientPidMap
 * \inmodule KContacts
 *
 * \brief Class that holds a ClientPidMap for a contact.
 * \since 5.4
 */
class KCONTACTS_EXPORT ClientPidMap
{
    friend KCONTACTS_EXPORT QDataStream &operator<<(QDataStream &, const ClientPidMap &);
    friend KCONTACTS_EXPORT QDataStream &operator>>(QDataStream &, ClientPidMap &);
    friend class VCardTool;
    friend class ::ClientPidMapTest;

public:
    /*!
     */
    ClientPidMap();

    ClientPidMap(const ClientPidMap &other);

    /*!
     */
    ClientPidMap(const QString &clientpidmap);

    ~ClientPidMap();

    /*!
     */
    typedef QList<ClientPidMap> List;

    /*!
     */
    void setClientPidMap(const QString &clientpidmap);

    /*!
     */
    [[nodiscard]] QString clientPidMap() const;

    /*!
     */
    [[nodiscard]] bool isValid() const;

    /*!
     */
    [[nodiscard]] bool operator==(const ClientPidMap &other) const;

    /*!
     */
    [[nodiscard]] bool operator!=(const ClientPidMap &other) const;

    ClientPidMap &operator=(const ClientPidMap &other);

    /*!
     */
    [[nodiscard]] QString toString() const;

private:
    // exported for ClientPidMapTest
    void setParams(const ParameterMap &params);
    [[nodiscard]] ParameterMap params() const;

    class Private;
    QSharedDataPointer<Private> d;
};

/*!
 * \relates KContacts::ClientPidMap
 */
KCONTACTS_EXPORT QDataStream &operator<<(QDataStream &stream, const ClientPidMap &object);

/*!
 * \relates KContacts::ClientPidMap
 */
KCONTACTS_EXPORT QDataStream &operator>>(QDataStream &stream, ClientPidMap &object);
}
Q_DECLARE_TYPEINFO(KContacts::ClientPidMap, Q_RELOCATABLE_TYPE);
#endif // CLIENTPIDMAP_H
