/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.observe.ObservingEndpoint;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserveRelation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObserveRelation.class);
    private final long checkIntervalTime;
    private final int checkIntervalCount;
    private final ObservingEndpoint endpoint;
    private final Resource resource;
    private final Exchange exchange;
    private Response recentControlNotification;
    private Response nextControlNotification;
    private final String key;
    private volatile boolean established;
    private volatile boolean canceled;
    private long interestCheckTimer = System.currentTimeMillis();
    private int interestCheckCounter = 1;

    public ObserveRelation(ObservingEndpoint endpoint, Resource resource, Exchange exchange) {
        if (endpoint == null) {
            throw new NullPointerException();
        }
        if (resource == null) {
            throw new NullPointerException();
        }
        if (exchange == null) {
            throw new NullPointerException();
        }
        this.endpoint = endpoint;
        this.resource = resource;
        this.exchange = exchange;
        NetworkConfig config = exchange.getEndpoint().getConfig();
        this.checkIntervalTime = config.getLong("NOTIFICATION_CHECK_INTERVAL");
        this.checkIntervalCount = config.getInt("NOTIFICATION_CHECK_INTERVAL_COUNT");
        this.key = StringUtil.toString((InetSocketAddress)this.getSource()) + "#" + exchange.getRequest().getTokenString();
    }

    public boolean isEstablished() {
        return this.established;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEstablished() {
        boolean fail;
        ObserveRelation observeRelation = this;
        synchronized (observeRelation) {
            fail = this.canceled;
            if (!fail) {
                this.established = true;
            }
        }
        if (fail) {
            throw new IllegalStateException(String.format("Could not establish observe relation %s with %s, already canceled (%s)!", this.getKey(), this.resource.getURI(), this.exchange));
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        boolean fail = false;
        boolean cancel = false;
        ObserveRelation observeRelation = this;
        synchronized (observeRelation) {
            if (!this.canceled) {
                boolean bl = fail = !this.established;
                if (!fail) {
                    this.canceled = true;
                    this.established = false;
                    cancel = true;
                }
            }
        }
        if (fail) {
            throw new IllegalStateException(String.format("Observe relation %s with %s not established (%s)!", this.getKey(), this.resource.getURI(), this.exchange));
        }
        if (cancel) {
            LOGGER.debug("Canceling observe relation {} with {} ({})", new Object[]{this.getKey(), this.resource.getURI(), this.exchange});
            Response reponse = this.exchange.getResponse();
            if (reponse != null) {
                reponse.cancel();
            }
            this.resource.removeObserveRelation(this);
            this.endpoint.removeObserveRelation(this);
            this.exchange.executeComplete();
        }
    }

    public void cancelAll() {
        this.endpoint.cancelAll();
    }

    public void notifyObservers() {
        this.resource.handleRequest(this.exchange);
    }

    public Resource getResource() {
        return this.resource;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public InetSocketAddress getSource() {
        return this.endpoint.getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check() {
        boolean check;
        long now = System.currentTimeMillis();
        ObserveRelation observeRelation = this;
        synchronized (observeRelation) {
            boolean bl = check = ++this.interestCheckCounter >= this.checkIntervalCount;
            if (check) {
                this.interestCheckTimer = now;
                this.interestCheckCounter = 0;
            }
        }
        if (check) {
            LOGGER.trace("Observe-relation check, {} notifications reached.", (Object)this.checkIntervalCount);
            return check;
        }
        observeRelation = this;
        synchronized (observeRelation) {
            boolean bl = check = now - this.interestCheckTimer - this.checkIntervalTime > 0L;
            if (check) {
                this.interestCheckTimer = now;
                this.interestCheckCounter = 0;
            }
        }
        if (check) {
            LOGGER.trace("Observe-relation check, {}s interval reached.", (Object)TimeUnit.MILLISECONDS.toSeconds(this.checkIntervalTime));
        }
        return check;
    }

    public Response getCurrentControlNotification() {
        return this.recentControlNotification;
    }

    public void setCurrentControlNotification(Response recentControlNotification) {
        this.recentControlNotification = recentControlNotification;
    }

    public Response getNextControlNotification() {
        return this.nextControlNotification;
    }

    public void setNextControlNotification(Response nextControlNotification) {
        if (this.nextControlNotification != null && nextControlNotification != null) {
            this.nextControlNotification.onComplete();
        }
        this.nextControlNotification = nextControlNotification;
    }

    public String getKey() {
        return this.key;
    }
}

