/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core;

import de.focus_shift.jollyday.core.util.ResourceUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CalendarHierarchy {
    private final String id;
    private Map<String, CalendarHierarchy> children = new HashMap<String, CalendarHierarchy>();
    private final CalendarHierarchy parent;
    private String fallbackDescription;

    public CalendarHierarchy(CalendarHierarchy parent, String id) {
        this.parent = parent;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.receiveFallbackDescription(ResourceUtil.getCountryDescription(this.getPropertiesKey()));
    }

    public String getDescription(Locale locale) {
        return this.receiveFallbackDescription(ResourceUtil.getCountryDescription(locale, this.getPropertiesKey()));
    }

    private String getPropertiesKey() {
        if (this.parent != null) {
            return this.parent.getPropertiesKey() + "." + this.getId();
        }
        return this.getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CalendarHierarchy) {
            return ((CalendarHierarchy)obj).getId().equals(this.getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public void setChildren(Map<String, CalendarHierarchy> children) {
        this.children = children;
    }

    public Map<String, CalendarHierarchy> getChildren() {
        return this.children;
    }

    public void setFallbackDescription(String description) {
        this.fallbackDescription = description;
    }

    private String receiveFallbackDescription(String description) {
        if ("undefined".equals(description) && this.fallbackDescription != null) {
            return this.fallbackDescription;
        }
        return description;
    }
}

