/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.Arrays;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.BlockwiseStatus;
import org.eclipse.californium.core.network.stack.BlockwiseTransferException;
import org.eclipse.californium.core.network.stack.KeyUri;
import org.eclipse.californium.core.observe.NotificationOrder;
import org.eclipse.californium.elements.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Block2BlockwiseStatus
extends BlockwiseStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger(Block2BlockwiseStatus.class);
    private final NotificationOrder order;
    private final byte[] etag;

    private Block2BlockwiseStatus(KeyUri keyUri, BlockwiseStatus.RemoveHandler removeHandler, Exchange exchange, Response response, int maxSize, int maxTcpBertBulkBlocks) {
        super(keyUri, removeHandler, exchange, response, maxSize, maxTcpBertBulkBlocks);
        Integer observeCount = response.getOptions().getObserve();
        if (observeCount != null && OptionSet.isValidObserveOption(observeCount)) {
            this.order = new NotificationOrder(observeCount);
            exchange.setNotificationNumber(observeCount);
        } else {
            this.order = null;
        }
        this.etag = (byte[])(response.getOptions().getETagCount() > 0 ? response.getOptions().getETags().get(0) : null);
    }

    public static Block2BlockwiseStatus forOutboundResponse(KeyUri keyUri, BlockwiseStatus.RemoveHandler removeHandler, Exchange exchange, Response response, int maxTcpBertBulkBlocks) {
        int size = response.getPayloadSize();
        Block2BlockwiseStatus status = new Block2BlockwiseStatus(keyUri, removeHandler, exchange, response, size, maxTcpBertBulkBlocks);
        if (size > 0) {
            try {
                status.addBlock(response.getPayload(), response.getMessageSize());
                status.flipBlocksBuffer();
            }
            catch (BlockwiseTransferException ex) {
                LOGGER.warn("buffer overflow on start", (Throwable)ex);
            }
        }
        return status;
    }

    public static Block2BlockwiseStatus forInboundResponse(KeyUri keyUri, BlockwiseStatus.RemoveHandler removeHandler, Exchange exchange, Response block, int maxBodySize, int maxTcpBertBulkBlocks) {
        int bufferSize = maxBodySize;
        if (block.getOptions().hasSize2()) {
            bufferSize = block.getOptions().getSize2();
        }
        Block2BlockwiseStatus status = new Block2BlockwiseStatus(keyUri, removeHandler, exchange, block, bufferSize, maxTcpBertBulkBlocks);
        return status;
    }

    public final Integer getObserve() {
        return this.order == null ? null : Integer.valueOf(this.order.getObserve());
    }

    public final boolean isNew(Response response) {
        if (response == null) {
            throw new NullPointerException("response block must not be null");
        }
        if (!response.getOptions().hasObserve()) {
            return false;
        }
        return this.order == null || this.order.isNew(response);
    }

    public final boolean matchTransfer(Exchange exchange) {
        Integer notification = exchange.getNotificationNumber();
        if (notification != null && this.order != null) {
            return this.order.getObserve() == notification.intValue();
        }
        return notification == null && this.order == null;
    }

    public synchronized void addBlock(Response responseBlock) throws BlockwiseTransferException {
        int responseOffset;
        if (responseBlock == null) {
            throw new NullPointerException("response block must not be null");
        }
        if (!responseBlock.getOptions().hasBlock2()) {
            throw new IllegalArgumentException("response block has no block2 option");
        }
        int currentOffset = this.getCurrentPosition();
        if (currentOffset != (responseOffset = responseBlock.getOptions().getBlock2().getOffset())) {
            String msg = String.format("response offset %d does not match the expected offset %d!", responseOffset, currentOffset);
            throw new BlockwiseTransferException(msg);
        }
        if (this.etag != null) {
            if (responseBlock.getOptions().getETagCount() != 1) {
                throw new BlockwiseTransferException("response does not contain a single ETag");
            }
            if (!Arrays.equals(this.etag, responseBlock.getOptions().getETags().get(0))) {
                throw new BlockwiseTransferException("response does not contain expected ETag");
            }
        }
        this.addBlock(responseBlock.getPayload(), responseBlock.getMessageSize());
        this.setCurrentNum(this.getCurrentPosition() / this.getCurrentSize());
    }

    public synchronized Request getNextRequestBlock(int blockSzx) throws BlockwiseTransferException {
        Exchange exchange = this.getExchange(false);
        if (exchange == null) {
            throw new BlockwiseTransferException("Block2 exchange already completed!", true);
        }
        this.setCurrentSzx(blockSzx);
        int size = this.getCurrentSize();
        int from = this.getCurrentPosition();
        if (from % size != 0) {
            throw new BlockwiseTransferException("Block2 buffer position " + from + " doesn't align with blocksize " + size + "!");
        }
        int num = from / size;
        this.setCurrentNum(num);
        Request request = exchange.getRequest();
        Request block = new Request(request.getCode());
        this.prepareOutgoingMessage(request, block, num == 0);
        block.getOptions().removeObserve();
        block.getOptions().setBlock2(blockSzx, false, num);
        return block;
    }

    public synchronized Response getNextResponseBlock(BlockOption block2) {
        if (block2 == null) {
            throw new NullPointerException("block option must not be null.");
        }
        int from = block2.getOffset();
        int szx = block2.getSzx();
        int size = block2.getSize();
        this.setCurrentSzx(szx);
        int num = from / size;
        this.setCurrentNum(num);
        Response block = new Response(((Response)this.firstMessage).getCode());
        int bodySize = this.getBufferSize();
        this.prepareOutgoingMessage(this.firstMessage, block, num == 0);
        if (num == 0) {
            if (!block.getOptions().hasSize2()) {
                block.getOptions().setSize2(bodySize);
            }
        } else {
            block.getOptions().removeObserve();
            block.setType(null);
        }
        boolean m = false;
        if (0 < bodySize && from < bodySize) {
            byte[] blockPayload = this.getBlock(from, this.getCurrentPayloadSize());
            m = from + blockPayload.length < bodySize;
            block.setPayload(blockPayload);
        }
        block.getOptions().setBlock2(szx, m, num);
        if (!m) {
            this.setComplete(true);
        }
        return block;
    }

    public final void completeOldTransfer(Exchange newExchange) {
        Exchange oldExchange = this.getExchange(true);
        if (oldExchange != null) {
            if (newExchange != oldExchange) {
                if (oldExchange.isNotification()) {
                    oldExchange.executeComplete();
                } else {
                    oldExchange.getRequest().setCanceled(true);
                }
            } else {
                oldExchange.setCurrentRequest(oldExchange.getRequest());
            }
        }
    }

    public final void completeNewTranfer(Exchange newExchange) {
        Exchange oldExchange = this.getExchange(false);
        if (newExchange != oldExchange) {
            if (newExchange.isNotification()) {
                newExchange.setComplete();
            } else {
                newExchange.getRequest().setCanceled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean completeResponse() {
        if (this.complete()) {
            Response response;
            Block2BlockwiseStatus block2BlockwiseStatus = this;
            synchronized (block2BlockwiseStatus) {
                response = (Response)this.firstMessage;
            }
            if (response != null) {
                response.onTransferComplete();
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized String toString() {
        String result = super.toString();
        if (this.order != null) {
            StringBuilder builder = new StringBuilder(result);
            builder.setLength(result.length() - 1);
            builder.append(", observe=").append(this.order.getObserve()).append("]");
            result = builder.toString();
        }
        return result;
    }

    public static final void crop(Response responseToCrop, BlockOption requestedBlock, int maxTcpBertBulkBlocks) {
        if (responseToCrop == null) {
            throw new NullPointerException("response message must not be null");
        }
        if (requestedBlock == null) {
            throw new NullPointerException("block option must not be null");
        }
        if (!responseToCrop.hasBlock(requestedBlock)) {
            throw new IllegalArgumentException("given response does not contain block");
        }
        int bodySize = responseToCrop.getPayloadSize();
        int from = requestedBlock.getOffset();
        int size = requestedBlock.getSize();
        if (requestedBlock.isBERT()) {
            size *= maxTcpBertBulkBlocks;
        }
        boolean m = false;
        if (responseToCrop.getOptions().hasBlock2()) {
            from -= responseToCrop.getOptions().getBlock2().getOffset();
            m = responseToCrop.getOptions().getBlock2().isM();
        }
        int to = Math.min(from + size, bodySize);
        int length = to - from;
        m = m || to < bodySize;
        responseToCrop.getOptions().setBlock2(requestedBlock.getSzx(), m, requestedBlock.getNum());
        LOGGER.debug("cropping response body [size={}] to block {}", (Object)bodySize, (Object)requestedBlock);
        if (length > 0) {
            byte[] blockPayload = new byte[length];
            System.arraycopy(responseToCrop.getPayload(), from, blockPayload, 0, length);
            responseToCrop.setPayload(blockPayload);
        } else {
            responseToCrop.setPayload(Bytes.EMPTY);
        }
    }
}

