/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TypeInfo;

final class DataTypeFilteringDTVImpl
extends DTVImpl {
    ServerDTVImpl serverDTVImpl = new ServerDTVImpl();
    TypeInfo typeInfo;
    boolean isKnownJDBCValue = false;
    private static final short ODBC_SQL_GUID = -11;
    private static final short ODBC_SQL_WCHAR = -8;
    private static final short ODBC_SQL_WVARCHAR = -9;
    private static final short ODBC_SQL_WLONGVARCHAR = -10;

    DataTypeFilteringDTVImpl() {
    }

    int setFromTDS(DTV dTV, TypeInfo typeInfo, int n, byte[] byArray, boolean bl) throws SQLServerException {
        this.typeInfo = typeInfo;
        this.isKnownJDBCValue = false;
        return this.serverDTVImpl.setFromTDS(dTV, typeInfo, n, byArray, bl);
    }

    void setValue(DTV dTV, int n, Object object, Object object2) {
    }

    Object getSetterArgs() {
        return null;
    }

    boolean isNull() {
        return false;
    }

    int getJdbcType() throws SQLServerException {
        return this.serverDTVImpl.getJdbcType();
    }

    Object getValue(DTV dTV, int n, boolean bl, int n2, Object object) throws SQLServerException {
        this.convertValue(dTV);
        return this.serverDTVImpl.getValue(dTV, n, bl, n2, object);
    }

    byte getByte(DTV dTV) throws SQLServerException {
        this.convertValue(dTV);
        return this.serverDTVImpl.getByte(dTV);
    }

    int getInt() {
        return this.serverDTVImpl.getInt();
    }

    short getShort() {
        return this.serverDTVImpl.getShort();
    }

    private final void convertValue(DTV dTV) throws SQLServerException {
        if (!this.isKnownJDBCValue) {
            short s;
            this.serverDTVImpl.getValue(dTV, 5, false, 0, null);
            short s2 = this.serverDTVImpl.getShort();
            switch (s2) {
                case -11: {
                    s = 1;
                    break;
                }
                case -8: {
                    s = 1;
                    break;
                }
                case -9: {
                    s = 12;
                    break;
                }
                case -10: {
                    s = -1;
                    break;
                }
                default: {
                    s = s2;
                }
            }
            if (s != s2) {
                byte[] byArray = this.typeInfo.getValueLengthSize() == 1 ? new byte[]{2, (byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)} : new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
                this.serverDTVImpl.setFromTDS(dTV, this.typeInfo, 0, byArray, true);
            }
            this.isKnownJDBCValue = true;
        }
    }
}

