/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aesh.utils.Config;

public class Table {
    private final List<String> headers = new ArrayList<String>();
    private final List<List<Cell>> content = new ArrayList<List<Cell>>();
    private final Map<Integer, Integer> widths = new HashMap<Integer, Integer>();

    public Table(List<String> headersList) {
        for (int i = 0; i < headersList.size(); ++i) {
            int length = headersList.get(i).length();
            Integer w = this.widths.get(i);
            if (w == null) {
                this.widths.put(i, length);
            } else if (w.compareTo(length) < 0) {
                this.widths.put(i, length);
            }
            this.headers.add(headersList.get(i));
        }
    }

    public Table(String ... headers) {
        this(Arrays.asList(headers));
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void addLine(String ... line) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (String c : line) {
            cells.add(new Cell(c));
        }
        this.addCellsLine(cells);
    }

    public void addLine(List<String> line) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (String c : line) {
            cells.add(new Cell(c));
        }
        this.addCellsLine(cells);
    }

    public void addCellsLine(Cell ... cell) {
        this.addCellsLine(Arrays.asList(cell));
    }

    public void addCellsLine(List<Cell> line) {
        for (int i = 0; i < line.size(); ++i) {
            int length = line.get(i).length();
            Integer w = this.widths.get(i);
            if (w == null) {
                this.widths.put(i, length);
                continue;
            }
            if (w.compareTo(length) >= 0) continue;
            this.widths.put(i, length);
        }
        this.content.add(line);
    }

    public void sort(SortType type) {
        if (SortType.ASCENDANT.equals((Object)type)) {
            Collections.sort(this.content, new Comparator<List<Cell>>(){

                @Override
                public int compare(List<Cell> o1, List<Cell> o2) {
                    return o1.get(0).getFirstLine().compareTo(o2.get(0).getFirstLine());
                }
            });
        } else {
            Collections.sort(this.content, new Comparator<List<Cell>>(){

                @Override
                public int compare(List<Cell> o1, List<Cell> o2) {
                    return o2.get(0).getFirstLine().compareTo(o1.get(0).getFirstLine());
                }
            });
        }
    }

    public String build() {
        return this.build(true);
    }

    public String build(boolean linesVisible) {
        Integer w;
        StringBuilder builder = new StringBuilder();
        String line = null;
        String separator = " ";
        if (linesVisible) {
            StringBuilder lineBuilder = new StringBuilder();
            for (int i = 0; i < this.headers.size(); ++i) {
                w = this.widths.get(i);
                lineBuilder.append(Table.line(w)).append(separator);
            }
            line = lineBuilder.toString();
            builder.append(line).append(Config.getLineSeparator());
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            String header = this.headers.get(i);
            w = this.widths.get(i);
            if (w > header.length()) {
                header = Table.pad(header, w);
            }
            builder.append(header).append(separator);
        }
        if (line != null) {
            builder.append(Config.getLineSeparator()).append(line);
        }
        builder.append(Config.getLineSeparator());
        String tab = "";
        for (List<Cell> c : this.content) {
            for (int i = 0; i < c.size(); ++i) {
                Cell val = c.get(i);
                Integer w2 = this.widths.get(i);
                String fl = val.getFirstLine();
                if (w2 > val.length()) {
                    fl = Table.pad(fl, w2);
                }
                builder.append(fl).append(separator);
                for (String l : val.getMultiLines()) {
                    builder.append(Config.getLineSeparator());
                    if (w2 > val.length()) {
                        l = Table.pad(l, w2);
                    }
                    builder.append(tab).append(l).append(separator);
                }
                tab = Table.tab(tab.length() + w2 + 1);
            }
            tab = "";
            builder.append(Config.getLineSeparator());
        }
        return builder.toString();
    }

    private static String line(int width) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            builder.append("=");
        }
        return builder.toString();
    }

    private static String tab(int width) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }

    private static String pad(String s, int length) {
        StringBuilder builder = new StringBuilder();
        builder.append(s);
        for (int i = 0; i < length - s.length(); ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }

    public static class Cell {
        private final List<String> items = new ArrayList<String>();
        int length = 0;

        public Cell(String ... content) {
            for (String c : content) {
                this.addLine(c);
            }
        }

        public void addLine(String line) {
            this.items.add(line);
            if (line.length() > this.length) {
                this.length = line.length();
            }
        }

        int length() {
            return this.length;
        }

        boolean isMultiLine() {
            return this.items.size() > 1;
        }

        String getFirstLine() {
            return this.items.get(0);
        }

        List<String> getMultiLines() {
            if (this.items.size() < 2) {
                return Collections.emptyList();
            }
            return this.items.subList(1, this.items.size());
        }
    }

    public static enum SortType {
        ASCENDANT,
        DESCENDANT;

    }

    public static class Tree {
        StringBuilder builder;
        Map<Integer, Integer> columnsWidth = new HashMap<Integer, Integer>();
        List<String> headers;
        private final List<Node> trees = new ArrayList<Node>();

        public Tree(String ... headers) {
            this(Arrays.asList(headers));
        }

        public Tree(List<String> headers) {
            this.headers = headers;
        }

        public void add(Node line) {
            this.trees.add(line);
        }

        public void addAll(Collection<Node> nodes) {
            this.trees.addAll(nodes);
        }

        public String build() {
            this.builder = new StringBuilder();
            this.columnsWidth.clear();
            this.computeWidths(this.trees, 0);
            StringBuilder lineBuilder = new StringBuilder();
            for (int i = 0; i < this.headers.size(); ++i) {
                int max = this.columnsWidth.get(i);
                lineBuilder.append(Table.line(max)).append(" ");
            }
            String line = lineBuilder.toString();
            this.builder.append(line).append(Config.getLineSeparator());
            for (int i = 0; i < this.headers.size(); ++i) {
                String header = this.headers.get(i);
                Integer w = this.columnsWidth.get(i);
                header = Table.pad(header, w);
                this.builder.append(header).append(" ");
            }
            if (line != null) {
                this.builder.append(Config.getLineSeparator()).append(line).append(Config.getLineSeparator());
            }
            this.render(this.trees, 0, 0);
            return this.builder.append(Config.getLineSeparator()).toString();
        }

        void computeWidths(List<Node> trees, int column) {
            if (column >= this.headers.size()) {
                return;
            }
            int max = 0;
            ArrayList<Node> next = new ArrayList<Node>();
            for (Node n : trees) {
                if (n.getValue().length() > max) {
                    max = n.getValue().length();
                }
                next.addAll(n.next);
            }
            int hsize = this.headers.get(column).length();
            if (hsize > max) {
                max = hsize;
            }
            this.columnsWidth.put(column, max);
            this.computeWidths(next, column + 1);
        }

        void render(List<Node> trees, int offset, int column) {
            if (trees.isEmpty()) {
                return;
            }
            Collections.sort(trees);
            int max = this.columnsWidth.get(column);
            String tab = "";
            for (int i = 0; i < trees.size(); ++i) {
                Node n = trees.get(i);
                String content = Table.pad(n.getValue(), max);
                this.builder.append(tab).append(content).append(" ");
                this.render(n.next, offset + max + 1, column + 1);
                if (i < trees.size() - 1) {
                    this.builder.append(Config.getLineSeparator());
                }
                tab = Table.tab(offset);
            }
        }
    }

    public static class Node
    implements Comparable<Node> {
        private final List<Node> next = new ArrayList<Node>();
        private final String value;

        public Node(String value) {
            this.value = value;
        }

        public void addNext(Node next) {
            this.next.add(next);
        }

        String getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Node o) {
            return this.value.compareTo(o.value);
        }
    }
}

