/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;

public class VkQueueFamilyProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int QUEUEFLAGS;
    public static final int QUEUECOUNT;
    public static final int TIMESTAMPVALIDBITS;
    public static final int MINIMAGETRANSFERGRANULARITY;

    public VkQueueFamilyProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkQueueFamilyProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkQueueFlags")
    public int queueFlags() {
        return VkQueueFamilyProperties.nqueueFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueCount() {
        return VkQueueFamilyProperties.nqueueCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int timestampValidBits() {
        return VkQueueFamilyProperties.ntimestampValidBits(this.address());
    }

    public VkExtent3D minImageTransferGranularity() {
        return VkQueueFamilyProperties.nminImageTransferGranularity(this.address());
    }

    public static VkQueueFamilyProperties malloc() {
        return (VkQueueFamilyProperties)VkQueueFamilyProperties.wrap(VkQueueFamilyProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkQueueFamilyProperties calloc() {
        return (VkQueueFamilyProperties)VkQueueFamilyProperties.wrap(VkQueueFamilyProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkQueueFamilyProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkQueueFamilyProperties)VkQueueFamilyProperties.wrap(VkQueueFamilyProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkQueueFamilyProperties create(long address) {
        return (VkQueueFamilyProperties)VkQueueFamilyProperties.wrap(VkQueueFamilyProperties.class, (long)address);
    }

    @Nullable
    public static VkQueueFamilyProperties createSafe(long address) {
        return address == 0L ? null : (VkQueueFamilyProperties)VkQueueFamilyProperties.wrap(VkQueueFamilyProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkQueueFamilyProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkQueueFamilyProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkQueueFamilyProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkQueueFamilyProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkQueueFamilyProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkQueueFamilyProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkQueueFamilyProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkQueueFamilyProperties mallocStack() {
        return VkQueueFamilyProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkQueueFamilyProperties callocStack() {
        return VkQueueFamilyProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkQueueFamilyProperties mallocStack(MemoryStack stack) {
        return VkQueueFamilyProperties.malloc(stack);
    }

    @Deprecated
    public static VkQueueFamilyProperties callocStack(MemoryStack stack) {
        return VkQueueFamilyProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkQueueFamilyProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkQueueFamilyProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkQueueFamilyProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkQueueFamilyProperties.calloc(capacity, stack);
    }

    public static VkQueueFamilyProperties malloc(MemoryStack stack) {
        return (VkQueueFamilyProperties)VkQueueFamilyProperties.wrap(VkQueueFamilyProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkQueueFamilyProperties calloc(MemoryStack stack) {
        return (VkQueueFamilyProperties)VkQueueFamilyProperties.wrap(VkQueueFamilyProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkQueueFamilyProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkQueueFamilyProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nqueueFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEFLAGS);
    }

    public static int nqueueCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUECOUNT);
    }

    public static int ntimestampValidBits(long struct) {
        return UNSAFE.getInt(null, struct + (long)TIMESTAMPVALIDBITS);
    }

    public static VkExtent3D nminImageTransferGranularity(long struct) {
        return VkExtent3D.create(struct + (long)MINIMAGETRANSFERGRANULARITY);
    }

    static {
        Struct.Layout layout = VkQueueFamilyProperties.__struct((Struct.Member[])new Struct.Member[]{VkQueueFamilyProperties.__member((int)4), VkQueueFamilyProperties.__member((int)4), VkQueueFamilyProperties.__member((int)4), VkQueueFamilyProperties.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        QUEUEFLAGS = layout.offsetof(0);
        QUEUECOUNT = layout.offsetof(1);
        TIMESTAMPVALIDBITS = layout.offsetof(2);
        MINIMAGETRANSFERGRANULARITY = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkQueueFamilyProperties, Buffer>
    implements NativeResource {
        private static final VkQueueFamilyProperties ELEMENT_FACTORY = VkQueueFamilyProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkQueueFamilyProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkQueueFlags")
        public int queueFlags() {
            return VkQueueFamilyProperties.nqueueFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueCount() {
            return VkQueueFamilyProperties.nqueueCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int timestampValidBits() {
            return VkQueueFamilyProperties.ntimestampValidBits(this.address());
        }

        public VkExtent3D minImageTransferGranularity() {
            return VkQueueFamilyProperties.nminImageTransferGranularity(this.address());
        }
    }
}

