/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.gantt;

import com.projectlibre1.association.InvalidAssociationException;
import com.projectlibre1.graphic.configuration.GraphicConfiguration;
import com.projectlibre1.pm.graphic.graph.GraphModel;
import com.projectlibre1.pm.graphic.model.cache.GraphicNode;
import com.projectlibre1.pm.graphic.timescale.CoordinatesConverter;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.timescale.TimeScaleEvent;
import com.projectlibre1.timescale.TimeScaleListener;
import java.awt.geom.AffineTransform;
import java.io.Serializable;

public class GanttModel
extends GraphModel
implements TimeScaleListener,
Serializable {
    private static final long serialVersionUID = 357529278107413145L;
    protected CoordinatesConverter coord;
    protected int rowHeight = GraphicConfiguration.getInstance().getRowHeight();

    public GanttModel(Project project, String string) {
        super(project, string);
    }

    public AffineTransform getTransform(double d) {
        double d2 = (double)(this.coord.getEnd() - this.coord.getOrigin()) / d;
        double d3 = 1.0 / (double)this.getRowHeight();
        return new AffineTransform(d2, 0.0, 0.0, d3, (double)this.coord.getOrigin(), 0.0);
    }

    public void createEdge(GraphicNode graphicNode, GraphicNode graphicNode2) throws InvalidAssociationException {
        this.getCache().createDependency(graphicNode, graphicNode2);
    }

    public CoordinatesConverter getCoord() {
        return this.coord;
    }

    public void setCoord(CoordinatesConverter coordinatesConverter) {
        if (this.coord != null) {
            this.coord.removeTimeScaleListener(this);
        }
        this.coord = coordinatesConverter;
        coordinatesConverter.addTimeScaleListener(this);
    }

    @Override
    public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n) {
        this.rowHeight = n;
    }
}

