/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.compat.Jre9Compat;
import org.apache.tomcat.util.res.StringManager;

public class Jre12Compat
extends Jre9Compat {
    private static final Log log = LogFactory.getLog(Jre12Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre12Compat.class);
    private static final boolean supported;

    static boolean isSupported() {
        return supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanonCachesDisabled() {
        if (canonCachesDisabled != null) {
            return canonCachesDisabled;
        }
        Object object = canonCachesDisabledLock;
        synchronized (object) {
            if (canonCachesDisabled != null) {
                return canonCachesDisabled;
            }
            List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : args) {
                String value;
                boolean cacheEnabled;
                if (!arg.startsWith("-Dsun.io.useCanonCaches=") || !(cacheEnabled = Boolean.valueOf(value = arg.substring("-Dsun.io.useCanonCaches=".length())).booleanValue())) continue;
                canonCachesDisabled = Boolean.FALSE;
                return false;
            }
            canonCachesDisabled = Boolean.TRUE;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureUseCanonCachesFieldIsPopulated() {
        if (useCanonCachesField != null) {
            return;
        }
        Object object = useCanonCachesFieldLock;
        synchronized (object) {
            if (useCanonCachesField != null) {
                return;
            }
            Field f = null;
            try {
                Class<?> clazz = Class.forName("java.io.FileSystem");
                f = clazz.getDeclaredField("useCanonCaches");
                f.setAccessible(true);
                Method privateLookupInMethod = MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
                Method findVarHandleMethod = MethodHandles.Lookup.class.getDeclaredMethod("findVarHandle", Class.class, String.class, Class.class);
                clazz = Class.forName("java.lang.invoke.VarHandle");
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)privateLookupInMethod.invoke(null, Field.class, MethodHandles.lookup());
                Object modifiers = findVarHandleMethod.invoke((Object)lookup, Field.class, "modifiers", Integer.TYPE);
                Method setMethod = null;
                try {
                    setMethod = modifiers.getClass().getDeclaredMethod("set", modifiers.getClass(), Object.class, Integer.TYPE);
                }
                catch (NoSuchMethodException e) {
                    setMethod = modifiers.getClass().getDeclaredMethod("set", clazz, Object.class, Integer.TYPE);
                }
                setMethod.setAccessible(true);
                setMethod.invoke(null, modifiers, f, f.getModifiers() & 0xFFFFFFEF);
            }
            catch (NoSuchMethodException e) {
                f = null;
                log.warn((Object)sm.getString("jreCompat.useCanonCaches.java18"), (Throwable)e);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                f = null;
                log.warn((Object)sm.getString("jreCompat.useCanonCaches.init"), t);
            }
            useCanonCachesField = f == null ? Optional.empty() : Optional.of(f);
        }
    }

    static {
        Class<?> c1 = null;
        try {
            c1 = Class.forName("java.text.CompactNumberFormat");
        }
        catch (ReflectiveOperationException e) {
            log.debug((Object)sm.getString("jre12Compat.javaPre12"), (Throwable)e);
        }
        supported = c1 != null;
    }
}

