##! Events generated by the PostgreSQL analyzer.

## Event generated for frontend SSLRequest messages.
##
## c: The connection.
global PostgreSQL::ssl_request: event(c: connection);

## Event generated for backend SSL reply.
##
## c: The connection.
##
## data: The server's reply: S for secure, N for unencrypted.
global PostgreSQL::ssl_reply: event(c: connection, data: string);

## Event generated for backend authentication requests.
##
## c: The connection.
##
## identifier: The identifier in the request.
##
## data: The request data, if any.
##
## .. zeek:see:: PostgreSQL::authentication_response
## .. zeek:see:: PostgreSQL::authentication_ok
global PostgreSQL::authentication_request: event(c: connection, identifier: count, data: string);

## Event generated for backend authentication requests indicating successful
## authentication.
##
## c: The connection.
##
## .. zeek:see:: PostgreSQL::authentication_request
## .. zeek:see:: PostgreSQL::authentication_response
global PostgreSQL::authentication_ok: event(c: connection);

## Event generated for frontend authentication responses.
##
## c: The connection.
##
## data: The response data, if any.
##
## .. zeek:see:: PostgreSQL::authentication_request
## .. zeek:see:: PostgreSQL::authentication_ok
global PostgreSQL::authentication_response: event(c: connection, data: string);


## Event generated for every parameter in a StartupMessage.
##
## c: The connection.
##
## name: The name of the parameter.
##
## value: The value of the parameter.
global PostgreSQL::startup_parameter: event(c: connection, name: string, value: string);

## Event generated for a StartupMessage.
##
## c: The connection.
##
## major: The major protocol version.
##
## minor: The minor protocol version.
global PostgreSQL::startup_message: event(c: connection, major: count, minor: count);

## Event generated for every backed ReadyForQuery message.
##
## c: The connection.
##
## transaction_status: I (idle), T (in transaction block), E (error).
global PostgreSQL::ready_for_query: event(c: connection, transaction_status: string);

## Event generated for every frontend SimpleQuery message.
##
## c: The connection.
##
## query: The query string.
global PostgreSQL::simple_query: event(c: connection, query: string);

## Event generated for identified field within an ErrorResponse.
##
## c: The connection.
##
## code: The code (https://www.postgresql.org/docs/current/protocol-error-fields.html)
##
## value: The field value.
##
## .. zeek:see:: PostgreSQL::error_response
global PostgreSQL::error_response_identified_field: event(c: connection, code: string, value: string);

## Event generated for a ErrorResponse.
##
## c: The connection.
##
## .. zeek:see:: PostgreSQL::error_response_identified_field
global PostgreSQL::error_response: event(c: connection);

## Event generated for identified field within a NoticeResponse.
##
## c: The connection.
##
## code: The code (https://www.postgresql.org/docs/current/protocol-error-fields.html)
##
## value: The field value.
##
## .. zeek:see:: PostgreSQL::notice_response
global PostgreSQL::notice_response_identified_field: event(c: connection, code: string, value: string);

## Event generated for a NoticeResponse.
##
## c: The connection.
##
## .. zeek:see:: PostgreSQL::notice_response_identified_field
global PostgreSQL::notice_response: event(c: connection);

## Event generated for every backend DataRow message.
##
## c: The connection.
##
## column_values: The number of columns in this row.
global PostgreSQL::data_row: event(c: connection, column_values: count);

## Event generated for backend runtime parameter status reports.
##
## c: The connection.
##
## name: The name of the runtime parameter.
##
## value: The current value of the parameter.
##
global PostgreSQL::parameter_status: event(c: connection, name: string, value: string);

## Generated for a BackendKeyData message for cancellation.
##
## c: The connection.
##
## process_id: The process ID of the backend.
##
## secret_key: The secret key of the backend.
global PostgreSQL::backend_key_data: event(c: connection, process_id: count, secret_key: count);

## Event generated For a frontend Terminate message.
##
## c: The connection.
global PostgreSQL::terminate: event(c: connection);

## Event generated for not implemented messages.
global PostgreSQL::not_implemented: event(c: connection, is_orig: bool, typ: string, chunk: string);
