/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSettingFactory;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleIndex;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.TokenMgrError;
import org.openstreetmap.josm.gui.mappaint.styleelement.LineElement;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSStyleSource
extends StyleSource {
    public static final String MAPCSS_STYLE_MIME_TYPES = "text/x-mapcss, text/mapcss, text/css; q=0.9, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5";
    public final List<MapCSSRule> rules = new ArrayList<MapCSSRule>();
    private final MapCSSStyleIndex ruleIndex = new MapCSSStyleIndex();
    private Color backgroundColorOverride;
    private String css;
    private ZipFile zipFile;
    private boolean removeAreaStylePseudoClass;
    public static final ReadWriteLock STYLE_SOURCE_LOCK = new ReentrantReadWriteLock();
    static final Set<String> SUPPORTED_KEYS = new HashSet<String>();

    public MapCSSStyleSource(String url, String name, String shortdescription) {
        super(url, name, shortdescription);
    }

    public MapCSSStyleSource(SourceEntry entry) {
        super(entry);
    }

    public MapCSSStyleSource(String css) {
        super(null, null, null);
        CheckParameterUtil.ensureParameterNotNull(css);
        this.css = css;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadStyleSource(boolean metadataOnly) {
        STYLE_SOURCE_LOCK.writeLock().lock();
        try {
            this.init();
            this.rules.clear();
            this.ruleIndex.clear();
            this.removeAreaStylePseudoClass = this.url == null || !this.url.contains("validator");
            try (InputStream in = this.getSourceInputStream();){
                try (BufferedReader reader = new BufferedReader(UTFInputStreamReader.create(in));){
                    MapCSSParser preprocessor = new MapCSSParser(reader, MapCSSParser.LexicalState.PREPROCESSOR);
                    try (StringReader in2 = new StringReader(preprocessor.pp_root(this));){
                        new MapCSSParser(in2, MapCSSParser.LexicalState.DEFAULT).sheet(this);
                    }
                    this.loadMeta();
                    if (!metadataOnly) {
                        this.loadCanvas();
                        this.loadSettings();
                    } else {
                        this.rules.clear();
                    }
                }
                finally {
                    this.closeSourceInputStream(in);
                }
            }
            catch (IOException | IllegalArgumentException e) {
                Logging.warn(I18n.tr("Failed to load Mappaint styles from ''{0}''. Exception was: {1}", this.url, e.toString()));
                Logging.log(Logging.LEVEL_ERROR, e);
                this.logError(e);
            }
            catch (TokenMgrError e) {
                Logging.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, e.getMessage()));
                Logging.error(e);
                this.logError(e);
            }
            catch (ParseException e) {
                Logging.warn(I18n.tr("Failed to parse Mappaint styles from ''{0}''. Error was: {1}", this.url, e.getMessage()));
                Logging.error(e);
                this.logError(new ParseException(e.getMessage()));
            }
            if (metadataOnly) {
                return;
            }
            this.ruleIndex.buildIndex(this.rules.stream());
            this.loaded = true;
        }
        finally {
            STYLE_SOURCE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        if (this.css != null) {
            return new ByteArrayInputStream(this.css.getBytes(StandardCharsets.UTF_8));
        }
        try (CachedFile cf = this.getCachedFile();){
            if (this.isZip) {
                File file = cf.getFile();
                this.zipFile = new ZipFile(file, StandardCharsets.UTF_8);
                this.zipIcons = file;
                I18n.addTexts(this.zipIcons);
                ZipEntry zipEntry = this.zipFile.getEntry(this.zipEntryPath);
                InputStream inputStream = this.zipFile.getInputStream(zipEntry);
                return inputStream;
            }
            this.zipFile = null;
            this.zipIcons = null;
            InputStream inputStream = cf.getInputStream();
            return inputStream;
        }
    }

    @Override
    public CachedFile getCachedFile() throws IOException {
        return new CachedFile(this.url).setHttpAccept(MAPCSS_STYLE_MIME_TYPES);
    }

    @Override
    public void closeSourceInputStream(InputStream is) {
        super.closeSourceInputStream(is);
        if (this.isZip) {
            Utils.close(this.zipFile);
        }
    }

    private void loadMeta() {
        Cascade c = this.constructSpecial("meta");
        String pTitle = c.get("title", null, String.class);
        if (this.title == null) {
            this.title = pTitle;
        }
        String pIcon = c.get("icon", null, String.class);
        if (this.icon == null) {
            this.icon = pIcon;
        }
    }

    private void loadCanvas() {
        Cascade c = this.constructSpecial("canvas");
        this.backgroundColorOverride = c.get("fill-color", null, Color.class);
    }

    private static void loadSettings(MapCSSRule r, Selector.GeneralSelector gs, Environment env) {
        if (gs.matchesConditions(env)) {
            env.layer = null;
            env.layer = gs.getSubpart().getId(env);
            r.execute(env);
        }
    }

    private void loadSettings() {
        this.settings.clear();
        this.settingValues.clear();
        this.settingGroups.clear();
        MultiCascade mc = new MultiCascade();
        MultiCascade mcGroups = new MultiCascade();
        Node n = new Node();
        n.put("lang", LanguageInfo.getJOSMLocaleCode());
        Environment env = new Environment(n, mc, "default", this);
        Environment envGroups = new Environment(n, mcGroups, "default", this);
        for (MapCSSRule mapCSSRule : this.rules) {
            Selector gs = mapCSSRule.selectors.get(0);
            if (!(gs instanceof Selector.GeneralSelector)) continue;
            if ("setting".equals(gs.getBase())) {
                MapCSSStyleSource.loadSettings(mapCSSRule, (Selector.GeneralSelector)gs, env);
                continue;
            }
            if (!"settings".equals(gs.getBase())) continue;
            MapCSSStyleSource.loadSettings(mapCSSRule, (Selector.GeneralSelector)gs, envGroups);
        }
        for (Map.Entry entry : mcGroups.getLayers()) {
            if ("default".equals(entry.getKey())) {
                Logging.warn("settings requires layer identifier e.g. 'settings::settings_group {...}'");
                continue;
            }
            this.settingGroups.put(StyleSetting.StyleSettingGroup.create((Cascade)entry.getValue(), this, (String)entry.getKey()), new ArrayList());
        }
        for (Map.Entry entry : mc.getLayers()) {
            if ("default".equals(entry.getKey())) {
                Logging.warn("setting requires layer identifier e.g. 'setting::my_setting {...}'");
                continue;
            }
            Cascade c = (Cascade)entry.getValue();
            StyleSetting set = StyleSettingFactory.create(c, this, (String)entry.getKey());
            if (set == null) continue;
            this.settings.add(set);
            this.settingValues.put((String)entry.getKey(), set.getValue());
            String groupId = c.get("group", null, String.class);
            if (groupId == null) continue;
            StyleSetting.StyleSettingGroup group = this.settingGroups.keySet().stream().filter(g -> g.key.equals(groupId)).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown settings group: " + groupId));
            ((List)this.settingGroups.get(group)).add(set);
        }
        this.settings.sort(null);
    }

    private Cascade constructSpecial(String type) {
        MultiCascade mc = new MultiCascade();
        Node n = new Node();
        String code = LanguageInfo.getJOSMLocaleCode();
        n.put("lang", code);
        Environment env = new Environment(n, mc, "default", this);
        for (MapCSSRule r : this.rules) {
            boolean matches = r.selectors.stream().anyMatch(gs -> gs instanceof Selector.GeneralSelector && gs.getBase().equals(type) && ((Selector.GeneralSelector)gs).matchesConditions(env));
            if (!matches) continue;
            r.execute(env);
        }
        return mc.getCascade("default");
    }

    @Override
    public Color getBackgroundColorOverride() {
        return this.backgroundColorOverride;
    }

    @Override
    public void apply(MultiCascade mc, IPrimitive osm, double scale, boolean pretendWayIsClosed) {
        Environment env = new Environment(osm, mc, null, this);
        int lastDeclUsed = -1;
        Iterator<MapCSSRule> candidates = this.ruleIndex.getRuleCandidates(osm);
        while (candidates.hasNext()) {
            MapCSSRule r = candidates.next();
            for (Selector s : r.selectors) {
                env.clearSelectorMatchingInformation();
                String sub = env.layer = s.getSubpart().getId(env);
                if (!s.matches(env)) continue;
                if (!s.getRange().contains(scale)) {
                    mc.range = mc.range.reduceAround(scale, s.getRange());
                    continue;
                }
                mc.range = Range.cut(mc.range, s.getRange());
                if (r.declaration.idx == lastDeclUsed) continue;
                lastDeclUsed = r.declaration.idx;
                if ("*".equals(sub)) {
                    for (Map.Entry<String, Cascade> entry : mc.getLayers()) {
                        env.layer = entry.getKey();
                        if ("*".equals(env.layer)) continue;
                        r.execute(env);
                    }
                }
                env.layer = sub;
                r.execute(env);
            }
        }
    }

    public boolean evalSupportsDeclCondition(String feature, Object val) {
        if (feature == null) {
            return false;
        }
        if (SUPPORTED_KEYS.contains(feature)) {
            return true;
        }
        switch (feature) {
            case "user-agent": {
                String s = Cascade.convertTo(val, String.class);
                return "josm".equals(s);
            }
            case "min-josm-version": {
                Float min = Cascade.convertTo(val, Float.class);
                return min != null && Math.round(min.floatValue()) <= Version.getInstance().getVersion();
            }
            case "max-josm-version": {
                Float max = Cascade.convertTo(val, Float.class);
                return max != null && Math.round(max.floatValue()) >= Version.getInstance().getVersion();
            }
        }
        return false;
    }

    public void removeMetaRules() {
        this.rules.removeIf(x -> x.selectors.get(0) instanceof Selector.GeneralSelector && "meta".equals(x.selectors.get(0).getBase()));
    }

    public boolean isRemoveAreaStylePseudoClass() {
        return this.removeAreaStylePseudoClass;
    }

    @Override
    public String toString() {
        return new ArrayList<MapCSSRule>(this.rules).stream().map(MapCSSRule::toString).collect(Collectors.joining("\n"));
    }

    static {
        for (Field field : StyleKeys.class.getDeclaredFields()) {
            try {
                SUPPORTED_KEYS.add((String)field.get(null));
                if (field.getName().toLowerCase(Locale.ENGLISH).replace('_', '-').equals(field.get(null))) continue;
                throw new JosmRuntimeException(field.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new JosmRuntimeException(ex);
            }
        }
        for (LineElement.LineType lineType : LineElement.LineType.values()) {
            SUPPORTED_KEYS.add(lineType.prefix + "color");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-background-color");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-background-opacity");
            SUPPORTED_KEYS.add(lineType.prefix + "dashes-offset");
            SUPPORTED_KEYS.add(lineType.prefix + "linecap");
            SUPPORTED_KEYS.add(lineType.prefix + "linejoin");
            SUPPORTED_KEYS.add(lineType.prefix + "miterlimit");
            SUPPORTED_KEYS.add(lineType.prefix + "offset");
            SUPPORTED_KEYS.add(lineType.prefix + "opacity");
            SUPPORTED_KEYS.add(lineType.prefix + "real-width");
            SUPPORTED_KEYS.add(lineType.prefix + "width");
        }
    }
}

