/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.lsp.internal;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.model.lsp.internal.RuntimeServerModule;
import org.openhab.core.model.script.ScriptServiceUtil;
import org.openhab.core.model.script.engine.ScriptEngine;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ModelServer.class}, configurationPid={"org.openhab.lsp"}, property={"service.pid=org.openhab.lsp"})
@ConfigurableService(category="system", label="Language Server (LSP)", description_uri="system:lsp")
@NonNullByDefault
public class ModelServer {
    public static final String CONFIGURATION_PID = "org.openhab.lsp";
    protected static final String CONFIG_URI = "system:lsp";
    private static final String KEY_PORT = "port";
    private static final int DEFAULT_PORT = 5007;
    private final ExecutorService pool = ThreadPoolManager.getPool((String)"lsp");
    private final Logger logger = LoggerFactory.getLogger(ModelServer.class);
    private @Nullable ServerSocket socket;
    private final Injector injector;

    @Activate
    public ModelServer(@Reference ScriptServiceUtil scriptServiceUtil, @Reference ScriptEngine scriptEngine) {
        this.injector = Guice.createInjector((Module[])new Module[]{new RuntimeServerModule(scriptServiceUtil, scriptEngine)});
    }

    @Activate
    public void activate(Map<String, Object> config) {
        int port = 5007;
        try {
            port = config.containsKey(KEY_PORT) ? Integer.parseInt(config.get(KEY_PORT).toString()) : 5007;
        }
        catch (NumberFormatException e) {
            this.logger.warn("Couldn't parse '{}', using default port '{}' for the Language Server instead", config.get(KEY_PORT), (Object)5007);
        }
        int serverPort = port;
        this.pool.submit(() -> this.listen(serverPort));
    }

    @Deactivate
    public void deactivate() {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Error shutting down the Language Server", (Throwable)e);
        }
    }

    private void listen(int port) {
        try {
            this.socket = new ServerSocket(port);
            this.logger.info("Started Language Server Protocol (LSP) service on port {}", (Object)port);
            while (!this.socket.isClosed()) {
                this.logger.debug("Going to wait for a client to connect");
                try {
                    Socket client = this.socket.accept();
                    this.pool.submit(() -> this.handleConnection(client));
                }
                catch (IOException e) {
                    if (this.socket.isClosed()) continue;
                    this.logger.error("Error accepting client connection: {}", (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Error starting the Language Server", (Throwable)e);
        }
    }

    private void handleConnection(Socket client) {
        this.logger.debug("Client {} connected", (Object)client.getRemoteSocketAddress());
        try {
            LanguageServerImpl languageServer = (LanguageServerImpl)this.injector.getInstance(LanguageServerImpl.class);
            Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)languageServer, (InputStream)client.getInputStream(), (OutputStream)client.getOutputStream());
            languageServer.connect((LanguageClient)launcher.getRemoteProxy());
            Future future = launcher.startListening();
            future.get();
        }
        catch (IOException e) {
            this.logger.warn("Error communicating with LSP client {}", (Object)client.getRemoteSocketAddress());
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            this.logger.error("Error running the Language Server", (Throwable)e);
        }
        this.logger.debug("Client {} disconnected", (Object)client.getRemoteSocketAddress());
    }
}

