/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.Publisher;
import org.osgi.framework.Filter;

public class FilteredPublisher<T>
implements AutoCloseable {
    private Publisher<? super T> _publisher;
    private Filter _filter;
    private AtomicBoolean _closed = new AtomicBoolean(false);
    private IdentityHashMap<T, List<OSGiResult>> _results = new IdentityHashMap();

    public FilteredPublisher(Publisher<? super T> publisher, Filter filter) {
        this._publisher = publisher;
        this._filter = filter;
    }

    @Override
    public void close() {
        if (this._closed.compareAndSet(false, true)) {
            this._results.forEach((__, result) -> result.forEach(OSGiResult::close));
            this._results.clear();
        }
    }

    public void publishIfMatched(T t, Map<String, ?> properties) {
        if (this._closed.get()) {
            return;
        }
        if (this._filter.matches(properties)) {
            OSGiResult result = this._publisher.publish(t);
            this._results.compute(t, (__, results) -> {
                if (results == null) {
                    results = new ArrayList<OSGiResult>();
                }
                results.add(result);
                return results;
            });
            if (this._closed.get()) {
                result.close();
            }
        }
    }

    public void retract(T t) {
        if (this._closed.get()) {
            return;
        }
        List<OSGiResult> resultList = this._results.remove(t);
        if (resultList != null) {
            resultList.forEach(OSGiResult::close);
        }
    }
}

